/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.jcajce.provider.digest;

import cfca.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.org.bouncycastle.crypto.CipherKeyGenerator;
import cfca.org.bouncycastle.crypto.digests.MD4Digest;
import cfca.org.bouncycastle.crypto.macs.HMac;
import cfca.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cfca.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import cfca.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cfca.org.bouncycastle.jce.provider.JCEMac;

public class MD4 {

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = MD4.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.MD4", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md4, "MD4");
            this.addHMACAlgorithm(provider, "MD4", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new MD4Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new MD4Digest((MD4Digest)this.digest);
            return d;
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACMD4", 128, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends JCEMac {
        public HashMac() {
            super(new HMac(new MD4Digest()));
        }
    }
}

