/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.jcajce.provider.symmetric;

import cfca.org.bouncycastle.crypto.CipherKeyGenerator;
import cfca.org.bouncycastle.crypto.engines.TwofishEngine;
import cfca.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cfca.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import cfca.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Twofish {
    private Twofish() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Twofish.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.Twofish", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.Twofish", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.Twofish", PREFIX + "$AlgParams");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Twofish IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Twofish", 256, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new TwofishEngine());
        }
    }
}

