/*
 * Decompiled with CFR 0.152.
 */
package cfca.rsa.envelope;

import cfca.asn1.parser.BigFileEncrypt;
import cfca.internal.tool.Mechanism_Inside;
import cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.StreamUtil;
import cfca.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.PKIException;
import java.io.File;
import java.io.IOException;

public class RSAEncryptedInputStream
extends ASN1Primitive {
    private File f;
    private byte[] key;
    private Mechanism_Inside contentEncryptionAlg;
    private long totalLength;

    public RSAEncryptedInputStream() {
    }

    public static RSAEncryptedInputStream getInstance(Object obj) {
        if (obj != null && obj instanceof RSAEncryptedInputStream) {
            return (RSAEncryptedInputStream)obj;
        }
        return null;
    }

    public RSAEncryptedInputStream(File f, byte[] key, Mechanism_Inside contentEncryptionAlg) throws PKIException {
        this.f = f;
        if (f.length() == 0L) {
            throw new PKIException("source file is empty!");
        }
        this.key = key;
        this.contentEncryptionAlg = contentEncryptionAlg;
    }

    public int hashCode() {
        return 0;
    }

    public boolean isConstructed() {
        return false;
    }

    public long encodedLength() throws IOException {
        if (this.contentEncryptionAlg.getMechanismType().indexOf("DESede") != -1) {
            long srcLength = this.f.length();
            long padd = srcLength & 7L;
            this.totalLength = srcLength + 8L - padd;
        } else if (this.contentEncryptionAlg.getMechanismType().indexOf("RC4") != -1) {
            this.totalLength = this.f.length();
        } else {
            throw new IOException("can not support this algorithm:" + this.contentEncryptionAlg);
        }
        return (long)(1 + StreamUtil.calculateBodyLength(this.totalLength)) + this.totalLength;
    }

    public void encode(ASN1OutputStream out) {
        try {
            out.write(4);
            out.writeLength(this.totalLength);
            this.cryptoUtil(this.key, this.contentEncryptionAlg, out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean asn1Equals(ASN1Primitive o) {
        return false;
    }

    private void cryptoUtil(byte[] key, Mechanism_Inside algName, ASN1OutputStream out) throws Exception {
        if (algName.getMechanismType().indexOf("DESede") != -1 && algName.getMechanismType().indexOf("CBC") != -1) {
            CBCParam param = (CBCParam)algName.getParam();
            BigFileEncrypt.bigFileBlockEncrypt(key, new DESedeEngine(), param, this.f, out);
        } else if (algName.getMechanismType().indexOf("DESede") != -1 && algName.getMechanismType().indexOf("ECB") != -1) {
            BigFileEncrypt.bigFileBlockEncrypt(key, new DESedeEngine(), null, this.f, out);
        } else if (algName.getMechanismType().indexOf("RC4") != -1) {
            BigFileEncrypt.bigFileRC4Encrypt(key, this.f, out);
        } else {
            throw new Exception("can not support this algorithm to encrypt:" + algName.getMechanismType());
        }
    }
}

