/*
 * Decompiled with CFR 0.152.
 */
package cfca.rsa.envelope;

import cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.org.bouncycastle.crypto.AsymmetricBlockCipher;
import cfca.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import cfca.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.org.bouncycastle.crypto.engines.RC4Engine;
import cfca.org.bouncycastle.crypto.engines.RSAEngine;
import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.org.bouncycastle.crypto.util.PrivateKeyFactory;
import cfca.org.bouncycastle.crypto.util.PublicKeyFactory;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKIException;
import cfca.system.SecureRandoms;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;

public class RSASymmetricCryptoUtil {
    public static byte[] encrypt(byte[] key, byte[] sourceData, Mechanism algName) throws Exception {
        if (algName.getMechanismType().indexOf("RC4") != -1) {
            return RSASymmetricCryptoUtil.useRC4Encrypt(true, key, sourceData);
        }
        if (algName.getMechanismType().indexOf("DESede") != -1 && algName.getMechanismType().indexOf("CBC") != -1) {
            CBCParam param = (CBCParam)algName.getParam();
            return RSASymmetricCryptoUtil.useDesedeCBCEncrypt(true, key, sourceData, param.getIv());
        }
        if (algName.getMechanismType().indexOf("DESede") != -1 && algName.getMechanismType().indexOf("ECB") != -1) {
            return RSASymmetricCryptoUtil.useDesedeECBEncrypt(true, key, sourceData);
        }
        if (algName.getMechanismType().indexOf("RSA") != -1) {
            return RSASymmetricCryptoUtil.useRSAECBEncrypt(true, key, sourceData);
        }
        throw new Exception("can not support this algorithm to encrypt:" + algName.getMechanismType());
    }

    public static byte[] decrypt(byte[] key, byte[] encryptData, Mechanism algName) throws Exception {
        if (algName.getMechanismType().indexOf("RC4") != -1) {
            return RSASymmetricCryptoUtil.useRC4Encrypt(false, key, encryptData);
        }
        if (algName.getMechanismType().indexOf("DESede") != -1 && algName.getMechanismType().indexOf("CBC") != -1) {
            CBCParam param = (CBCParam)algName.getParam();
            return RSASymmetricCryptoUtil.useDesedeCBCEncrypt(false, key, encryptData, param.getIv());
        }
        if (algName.getMechanismType().indexOf("DESede") != -1 && algName.getMechanismType().indexOf("ECB") != -1) {
            return RSASymmetricCryptoUtil.useDesedeECBEncrypt(false, key, encryptData);
        }
        if (algName.getMechanismType().indexOf("RSA") != -1) {
            return RSASymmetricCryptoUtil.useRSAECBEncrypt(false, key, encryptData);
        }
        throw new Exception("can not support this algorithm to decrypt:" + algName.getMechanismType());
    }

    private static byte[] useRC4Encrypt(boolean isEncrypted, byte[] key, byte[] input) {
        RC4Engine rc4 = new RC4Engine();
        KeyParameter param = new KeyParameter(key);
        rc4.init(isEncrypted, param);
        byte[] out = new byte[input.length];
        rc4.processBytes(input, 0, input.length, out, 0);
        return out;
    }

    private static byte[] useDesedeECBEncrypt(boolean isEncrypted, byte[] key, byte[] input) throws Exception {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new DESedeEngine(), new PKCS7Padding());
        KeyParameter params = new KeyParameter(key);
        cipher.init(isEncrypted, params);
        int len = cipher.getOutputSize(input.length);
        byte[] out = new byte[len];
        int len1 = cipher.processBytes(input, 0, input.length, out, 0);
        int len2 = cipher.doFinal(out, len1);
        int total = len1 + len2;
        if (total < len) {
            byte[] out2 = new byte[total];
            System.arraycopy(out, 0, out2, 0, total);
            return out2;
        }
        return out;
    }

    private static byte[] useDesedeCBCEncrypt(boolean isEncrypted, byte[] key, byte[] input, byte[] iv) throws Exception {
        ParametersWithIV param = new ParametersWithIV(new KeyParameter(key), iv);
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()), new PKCS7Padding());
        cipher.init(isEncrypted, param);
        int len = cipher.getOutputSize(input.length);
        byte[] out = new byte[len];
        int len1 = cipher.processBytes(input, 0, input.length, out, 0);
        int len2 = cipher.doFinal(out, len1);
        int total = len1 + len2;
        if (total < len) {
            byte[] out2 = new byte[total];
            System.arraycopy(out, 0, out2, 0, total);
            return out2;
        }
        return out;
    }

    private static byte[] useRSAECBEncrypt(boolean isEncrypted, byte[] key, byte[] input) throws Exception {
        RSAKeyParameters param = null;
        if (isEncrypted) {
            SubjectPublicKeyInfo pubKeyInfo = SubjectPublicKeyInfo.getInstance(key);
            param = (RSAKeyParameters)PublicKeyFactory.createKey(pubKeyInfo);
            AsymmetricBlockCipher eng = new RSAEngine();
            eng = new PKCS1Encoding(eng);
            eng.init(true, param);
            return eng.processBlock(input, 0, input.length);
        }
        param = (RSAKeyParameters)PrivateKeyFactory.createKey(key);
        AsymmetricBlockCipher eng = new RSAEngine();
        eng = new PKCS1Encoding(eng);
        eng.init(false, param);
        return eng.processBlock(input, 0, input.length);
    }

    public static byte[] generateSecretKey(String symmetricAlgorithm) throws Exception {
        String contentEncryptionAlg = symmetricAlgorithm.toUpperCase();
        SecureRandoms random = SecureRandoms.getInstance();
        if (contentEncryptionAlg.indexOf("RC4") != -1) {
            return random.genBytes(16);
        }
        if (contentEncryptionAlg.indexOf("DESEDE") != -1) {
            return random.genBytes(24);
        }
        throw new Exception("can not generate such key:" + contentEncryptionAlg);
    }

    public static byte[] generateIV() {
        return SecureRandoms.getInstance().genBytes(8);
    }

    public static final Key generateSecureKey(Mechanism mechanism) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        String type = mechanism.getMechanismType();
        SecureRandoms random = SecureRandoms.getInstance();
        if (type.equals("DESede")) {
            SecretKeySpec key = new SecretKeySpec(random.genBytes(24), type);
            return key;
        }
        if (type.equals("SM4")) {
            SecretKeySpec key = new SecretKeySpec(random.genBytes(16), type);
            return key;
        }
        if (type.equals("RC4")) {
            SecretKeySpec key = new SecretKeySpec(random.genBytes(16), type);
            return key;
        }
        throw new PKIException("do not support this key type:" + type);
    }
}

