/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cmbc.apple.pay;

import cfca.org.bouncycastle.cert.X509CertificateHolder;
import cfca.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import cfca.org.bouncycastle.cms.SignerInformationVerifier;
import cfca.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cfca.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import cfca.org.bouncycastle.operator.DigestCalculatorProvider;
import cfca.org.bouncycastle.operator.OperatorCreationException;
import cfca.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import cfca.sadk.cmbc.apple.pay.BcECDSAContentVerifierProviderBuilder;

class BcECDSASignerInfoVerifierBuilder {
    private BcECDSAContentVerifierProviderBuilder contentVerifierProviderBuilder;
    private DigestCalculatorProvider digestCalculatorProvider;
    private CMSSignatureAlgorithmNameGenerator sigAlgNameGen;
    private SignatureAlgorithmIdentifierFinder sigAlgIdFinder;

    BcECDSASignerInfoVerifierBuilder(CMSSignatureAlgorithmNameGenerator sigAlgNameGen, SignatureAlgorithmIdentifierFinder sigAlgIdFinder, DigestAlgorithmIdentifierFinder digestAlgorithmFinder, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigAlgNameGen = sigAlgNameGen;
        this.sigAlgIdFinder = sigAlgIdFinder;
        this.contentVerifierProviderBuilder = new BcECDSAContentVerifierProviderBuilder(digestAlgorithmFinder);
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public SignerInformationVerifier build(X509CertificateHolder certHolder) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(certHolder), this.digestCalculatorProvider);
    }

    public SignerInformationVerifier build(AsymmetricKeyParameter pubKey) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(pubKey), this.digestCalculatorProvider);
    }
}

