/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cmbc.tools;

import java.math.BigInteger;
import java.util.Locale;
import java.util.ResourceBundle;

public class DecryptKitException
extends Exception {
    private static final long serialVersionUID = 5053337972928402991L;
    private static final String basename = "DecryptKitErrcode";
    private static final Locale currentLocale = Locale.getDefault();
    private static final ResourceBundle bundle = ResourceBundle.getBundle("DecryptKitErrcode", currentLocale);
    private int errorCode = 0;

    public DecryptKitException(int errorCode) {
        this.errorCode = errorCode;
    }

    public DecryptKitException(int errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public DecryptKitException(int errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public DecryptKitException(int errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String toString() {
        String code = "0x" + BigInteger.valueOf(this.errorCode).toString(16);
        StringBuilder builder = new StringBuilder();
        builder.append("DecryptKitException [ErrorCode=");
        builder.append(code);
        builder.append(", ErrorMessage=");
        try {
            String text = bundle.getString(code);
            if (text != null) {
                builder.append(text);
            } else {
                builder.append("missing errcode message");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String hint = this.getMessage();
        if (hint != null) {
            builder.append(", ErrorHint=");
            builder.append(hint);
        }
        builder.append("]");
        return builder.toString();
    }
}

