/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cmbc.tools;

import cfca.sadk.cmbc.tools.DecryptKitException;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.util.cipher.lib.JCrypto;
import cmbc.cfca.util.cipher.lib.Session;
import cmbc.cfca.x509.certificate.X509Cert;
import java.io.File;
import java.security.PrivateKey;

abstract class Signer {
    PrivateKey privateKey = null;
    X509Cert signedCert = null;

    Signer() {
    }

    final boolean load(String myPrivateFile, String myPrivateFilePassword) throws DecryptKitException {
        boolean verifyResult;
        String algorithm;
        String extensionName;
        if (myPrivateFile == null) {
            throw new DecryptKitException(0x70011001);
        }
        if (myPrivateFilePassword == null) {
            throw new DecryptKitException(1879117826);
        }
        File privateFile = new File(myPrivateFile);
        if (!privateFile.exists()) {
            throw new DecryptKitException(1879121921);
        }
        Mechanism mechanism = this.getMechanism();
        String keyType = this.getKeyType();
        String allowedExtensionName = this.getAllowedExtensionName();
        if (!allowedExtensionName.equals(extensionName = Signer.getExtensionFilename(privateFile.getName()))) {
            throw new DecryptKitException(1879126019);
        }
        this.privateKey = this.loadPrivateKey(myPrivateFile, myPrivateFilePassword);
        if (!keyType.equalsIgnoreCase(this.privateKey.getAlgorithm())) {
            throw new DecryptKitException(1879134210);
        }
        this.signedCert = this.loadCertificate(myPrivateFile, myPrivateFilePassword);
        try {
            algorithm = this.signedCert.getPublicKey().getAlgorithm();
        }
        catch (Exception e) {
            throw new DecryptKitException(1879130114, (Throwable)e);
        }
        if (!keyType.equalsIgnoreCase(algorithm)) {
            throw new DecryptKitException(1879134210);
        }
        try {
            byte[] data = "testing".getBytes();
            JCrypto.getInstance().initialize("JSOFT_LIB", null);
            Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
            byte[] sign = session.sign(mechanism, this.privateKey, data);
            verifyResult = session.verifySign(mechanism, this.signedCert.getPublicKey(), data, sign);
        }
        catch (Exception e) {
            throw new DecryptKitException(1879134213, (Throwable)e);
        }
        if (!verifyResult) {
            throw new DecryptKitException(1879134212);
        }
        return verifyResult;
    }

    abstract PrivateKey loadPrivateKey(String var1, String var2) throws DecryptKitException;

    abstract X509Cert loadCertificate(String var1, String var2) throws DecryptKitException;

    abstract Mechanism getMechanism();

    abstract String getKeyType();

    abstract String getAllowedExtensionName();

    static final String getExtensionFilename(String filename) {
        int index;
        String extension = null;
        if (filename != null && (index = filename.lastIndexOf(".")) != -1) {
            extension = filename.substring(index + 1, filename.length()).toLowerCase();
        }
        return extension;
    }
}

