/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk32.org.bouncycastle.asn1.sm2;

import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.asn1.ASN1Integer;
import cfca.org.bouncycastle.asn1.ASN1Object;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.DERSequence;
import cfca.sadk32.org.bouncycastle.asn1.sm2.TLV;
import cfca.sadk32.org.bouncycastle.util.Arrays;
import cfca.sadk32.org.bouncycastle.util.BigIntegers;
import cfca.sm2rsa.common.PKIException;
import cfca.system.Debugger;
import java.math.BigInteger;
import java.util.Enumeration;

public final class ASN1SM2Signature
extends ASN1Object {
    private BigInteger r;
    private BigInteger s;

    public static ASN1SM2Signature getInstance(Object o) throws IllegalArgumentException {
        if (o instanceof ASN1SM2Signature) {
            return (ASN1SM2Signature)o;
        }
        if (o instanceof byte[]) {
            try {
                return new ASN1SM2Signature((byte[])o);
            }
            catch (PKIException e) {
                throw new SecurityException("Invalid parameter", e);
            }
        }
        if (o != null) {
            return new ASN1SM2Signature(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public ASN1SM2Signature(BigInteger r, BigInteger s) {
        this.r = new ASN1Integer(r).getPositiveValue();
        this.s = new ASN1Integer(s).getPositiveValue();
    }

    public ASN1SM2Signature(ASN1Integer r, ASN1Integer s) {
        this.r = r.getPositiveValue();
        this.s = s.getPositiveValue();
    }

    public ASN1SM2Signature(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.r = ((ASN1Integer)e.nextElement()).getPositiveValue();
        this.s = ((ASN1Integer)e.nextElement()).getPositiveValue();
    }

    public ASN1SM2Signature(byte[] signature) throws PKIException {
        if (signature == null) {
            throw new PKIException("Unknown signature value");
        }
        if (signature.length == 64 && !ASN1SM2Signature.isASN1SignType(signature)) {
            this.r = new BigInteger(1, Arrays.copyOfRange(signature, 0, 32));
            this.s = new BigInteger(1, Arrays.copyOfRange(signature, 32, 64));
        } else {
            ASN1InputStream asn1Is = null;
            try {
                asn1Is = new ASN1InputStream(signature);
                ASN1Sequence seq = (ASN1Sequence)asn1Is.readObject();
                if (seq.size() != 2) {
                    throw new PKIException("Invalid signature value:  signedData[ASN1(R+S)]");
                }
                Enumeration e = seq.getObjects();
                this.r = ((ASN1Integer)e.nextElement()).getPositiveValue();
                this.s = ((ASN1Integer)e.nextElement()).getPositiveValue();
            }
            catch (Exception e) {
                throw new PKIException("Unknown  signature value: " + Debugger.dump(signature), e);
            }
            finally {
                if (asn1Is != null) {
                    try {
                        asn1Is.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public BigInteger getRInt() {
        return this.r;
    }

    public BigInteger getSInt() {
        return this.s;
    }

    public final byte[] getRS() {
        byte[] dest = new byte[64];
        System.arraycopy(BigIntegers.asUnsignedByteArray(32, this.r), 0, dest, 0, 32);
        System.arraycopy(BigIntegers.asUnsignedByteArray(32, this.s), 0, dest, 32, 32);
        return dest;
    }

    public ASN1Integer getR() {
        return new ASN1Integer(this.r);
    }

    public ASN1Integer getS() {
        return new ASN1Integer(this.s);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.r));
        v.add(new ASN1Integer(this.s));
        return new DERSequence(v);
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("SM2Signature [r=");
        builder.append(this.r != null ? this.r.toString(16) : "none");
        builder.append(", s=");
        builder.append(this.s != null ? this.s.toString(16) : "none");
        builder.append(']');
        return builder.toString();
    }

    public static final boolean isASN1SignType(byte[] signature) {
        if (signature == null) {
            return false;
        }
        if (signature.length < 58 || signature.length > 80) {
            return false;
        }
        int offset = 0;
        TLV tlv = new TLV(signature, offset);
        if (tlv.failure || tlv.type != 48 || tlv.vLength < 56) {
            return false;
        }
        int maxLength = (offset += tlv.hLength) + tlv.vLength;
        int num = 0;
        while (offset < maxLength) {
            tlv = new TLV(signature, offset);
            if (tlv.failure || tlv.type != 2 || tlv.vLength < 26) {
                return false;
            }
            offset += tlv.hLength;
            offset += tlv.vLength;
            if (++num != 2) continue;
        }
        return num == 2 && offset == maxLength;
    }
}

