/*
 * Decompiled with CFR 0.152.
 */
package cfca.util.api;

import cfca.internal.tool.MechanismUtil;
import cfca.internal.tool.PKCS12;
import cfca.internal.tool.PKCS12_SM2;
import cfca.org.bouncycastle.asn1.DERBitString;
import cfca.org.bouncycastle.asn1.pkcs.CertificationRequest;
import cfca.org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKIException;
import cfca.system.Debugger;
import cfca.util.Base64;
import cfca.util.KeyUtil;
import cfca.util.api.StringHelper;
import cfca.util.cipher.lib.JCrypto;
import cfca.util.cipher.lib.Session;
import cfca.x509.certificate.X509Cert;
import java.security.KeyPair;
import java.security.PrivateKey;

public final class P12FileKit {
    static final Logger logger = LoggerFactory.getLogger(P12FileKit.class);
    private KeyPair keypair;
    static volatile Session session = null;

    public final String RSAGeneratep10(String subjectDN, int bitLength) throws PKIException {
        try {
            byte[] base64p10Bytes;
            Session session = P12FileKit.session();
            if (bitLength != 1024 && bitLength != 2048) {
                throw new PKIException("PFX KeyPair Invalid bitLength=" + bitLength);
            }
            this.keypair = KeyUtil.generateRSAKeyPair(new Mechanism("RSA"), bitLength, session);
            try {
                base64p10Bytes = this.generateP10(subjectDN, "SHA256withRSAEncryption");
            }
            catch (PKIException e) {
                throw new PKIException("PFX P10 Generated PKCS10 failure ", e);
            }
            String base64SM2P10Text = new String(base64p10Bytes);
            return base64SM2P10Text;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAGenerateP10<<<<<<Failure", e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAGenerateP10<<<<<<Failure", e);
            }
            throw new PKIException("RSAGenerateP10 Failure", e);
        }
    }

    public final String SM2GenerateP10(String subjectDN) throws PKIException {
        try {
            byte[] base64p10;
            Session session = P12FileKit.session();
            this.keypair = KeyUtil.generateSM2KeyPair(new Mechanism("SM2"), session);
            try {
                base64p10 = this.generateP10(subjectDN, "SM3withSM2");
            }
            catch (PKIException e) {
                throw new PKIException("SM2 P10 Generated PKCS10 failure ", e);
            }
            String base64SM2P10Text = new String(base64p10);
            return base64SM2P10Text;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2GenerateP10<<<<<<Failure", e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2GenerateP10<<<<<<Failure", e);
            }
            throw new PKIException("SM2GenerateP10 Failure", e);
        }
    }

    public KeyPair getKeyPair() {
        return this.keypair;
    }

    public final String RSACombineP12(PrivateKey privateKey, String base64CertData, String password) throws PKIException {
        if (privateKey == null) {
            throw new PKIException("null not allowed for privateKey");
        }
        if (StringHelper.isEmpty(base64CertData)) {
            throw new PKIException("null not allowed for base64CertData");
        }
        if (StringHelper.isEmpty(password)) {
            throw new PKIException("null not allowed for password");
        }
        try {
            byte[] data;
            X509Cert cert;
            try {
                cert = new X509Cert(base64CertData.getBytes());
            }
            catch (PKIException e) {
                throw new PKIException("PFX Combine Decoded base64CertData failure", e);
            }
            this.checkKeys(privateKey, cert, "SHA1withRSAEncryption");
            try {
                data = PKCS12.generatePfxData(cert, privateKey, password);
            }
            catch (Exception e) {
                throw new PKIException("PFX Combine failure", e);
            }
            String base64RSAP12Bytes = new String(Base64.encode(data), "UTF8");
            return base64RSAP12Bytes;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("RSACombineP12>>>>>>Running");
                buffer.append("\n base64EncryptedKeyData: ");
                buffer.append("\n base64CertData: ");
                buffer.append(Debugger.dump(base64CertData));
                logger.error(buffer.toString());
                logger.error("RSACombineP12<<<<<<Failure", e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSACombineP12<<<<<<Failure", e);
            }
            throw new PKIException("RSACombineP12 Failure", e);
        }
    }

    public final String SM2CombineP12(PrivateKey privateKey, String base64CertData, String password) throws PKIException {
        if (privateKey == null) {
            throw new PKIException("null not allowed for privateKey");
        }
        if (StringHelper.isEmpty(base64CertData)) {
            throw new PKIException("null not allowed for base64CertData");
        }
        if (StringHelper.isEmpty(password)) {
            throw new PKIException("null not allowed for password");
        }
        try {
            byte[] data;
            X509Cert cert;
            try {
                cert = new X509Cert(base64CertData.getBytes());
            }
            catch (PKIException e) {
                throw new PKIException("SM2 Combine Fatched base64CertData failure", e);
            }
            this.checkKeys(privateKey, cert, "SM3withSM2");
            try {
                data = this.SM2CombineP12Data(cert, privateKey, password);
            }
            catch (Exception e) {
                throw new PKIException("SM2 Combine failure", e);
            }
            String base64SM2P12Text = new String(Base64.encode(data), "UTF8");
            if (logger.isDebugEnabled()) {
                logger.debug("SM2CombineP12<<<<<<Finished: base64SM2P12Text=" + base64SM2P12Text);
            }
            return base64SM2P12Text;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SM2CombineP12>>>>>>Running");
                buffer.append("\n base64EncryptedKeyData: ");
                buffer.append("\n base64CertData: ");
                buffer.append(Debugger.dump(base64CertData));
                logger.error(buffer.toString());
                logger.error("SM2CombineP12<<<<<<Failure", e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2CombineP12<<<<<<Failure", e);
            }
            throw new PKIException("SM2CombineP12 Failure", e);
        }
    }

    private byte[] SM2CombineP12Data(X509Cert x509Cert, PrivateKey priKey, String password) throws PKIException {
        try {
            byte[] binaryP12Data = PKCS12_SM2.CombineSM2Data(x509Cert, priKey, password);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2CombineP12Data<<<<<<Finished: binaryP12Data=" + Debugger.dump(binaryP12Data));
            }
            return binaryP12Data;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SM2CombineP12Data>>>>>>Running");
                buffer.append("\n x509Cert: ");
                buffer.append(Debugger.dump(x509Cert));
                logger.error(buffer.toString());
                logger.error("SM2CombineP12Data<<<<<<Failure", e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2CombineP12Data<<<<<<Failure", e);
            }
            throw new PKIException("SM2CombineP12Data Failure", e);
        }
    }

    private void checkKeys(PrivateKey privateKey, X509Cert cert, String mechanism) throws PKIException {
        Session session = P12FileKit.session();
        byte[] sourceData = "Testing".getBytes();
        Mechanism signAlg = new Mechanism(mechanism);
        byte[] signData = session.sign(signAlg, privateKey, sourceData);
        boolean verifyResult = session.verifySign(signAlg, cert.getPublicKey(), sourceData, signData);
        if (!verifyResult) {
            throw new PKIException("\u4f7f\u7528\u7684\u516c\u94a5\u8bc1\u4e66\u548c\u7b7e\u540d\u8005\u7684\u79c1\u94a5\u8bc1\u4e66\u4e0d\u5339\u914d");
        }
    }

    private final byte[] generateP10(String subjectDN, String mechanism) throws PKIException {
        try {
            boolean useDefaultDN = StringHelper.isEmpty(subjectDN);
            SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance(this.keypair.getPublic().getEncoded());
            X500Name subject = new X500Name(useDefaultDN ? "CN=certRequisition,O=CFCA AGENT,C=CN" : subjectDN);
            CertificationRequestInfo certRequestInfo = new CertificationRequestInfo(subject, pubInfo, null);
            byte[] sourceData = certRequestInfo.getEncoded("DER");
            AlgorithmIdentifier signAlg = MechanismUtil.getAlgorithmIdentifier(mechanism);
            Mechanism signMechanism = new Mechanism(mechanism);
            byte[] signature = session.sign(signMechanism, this.keypair.getPrivate(), sourceData, true);
            CertificationRequest certRequest = new CertificationRequest(certRequestInfo, signAlg, new DERBitString(signature));
            PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(certRequest);
            byte[] base64P10Bytes = Base64.encode(p10.getEncoded());
            return base64P10Bytes;
        }
        catch (Exception e) {
            throw new PKIException("851712", "\u7533\u8bf7\u5de5\u5177\u5305\u6784\u5efa\u7533\u8bf7\u6587\u4ef6\u5931\u8d25", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Session session() throws PKIException {
        if (session != null) return session;
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            if (session != null) return session;
            try {
                String deviceName = "JSOFT_LIB";
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (PKIException e) {
                throw new PKIException("Open session failure: " + e.getMessage());
            }
            return session;
        }
    }
}

