/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.asn1;

import cmbc.cfca.org.bouncycastle.asn1.ASN1Enumerated;
import cmbc.cfca.org.bouncycastle.asn1.ASN1OctetString;
import cmbc.cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Primitive;
import cmbc.cfca.org.bouncycastle.asn1.ASN1TaggedObject;
import cmbc.cfca.org.bouncycastle.asn1.StreamUtil;
import cmbc.cfca.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class DEREnumerated
extends ASN1Primitive {
    byte[] bytes;
    private static ASN1Enumerated[] cache = new ASN1Enumerated[12];

    public static ASN1Enumerated getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Enumerated) {
            return (ASN1Enumerated)obj;
        }
        if (obj instanceof DEREnumerated) {
            return new ASN1Enumerated(((DEREnumerated)obj).getValue());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DEREnumerated getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DEREnumerated) {
            return DEREnumerated.getInstance(o);
        }
        return DEREnumerated.fromOctetString(((ASN1OctetString)o).getOctets());
    }

    public DEREnumerated(int value) {
        this.bytes = BigInteger.valueOf(value).toByteArray();
    }

    public DEREnumerated(BigInteger value) {
        this.bytes = value.toByteArray();
    }

    public DEREnumerated(byte[] bytes) {
        this.bytes = bytes;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public boolean isConstructed() {
        return false;
    }

    public long encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.bytes.length) + this.bytes.length;
    }

    public void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(10, this.bytes);
    }

    public boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DEREnumerated)) {
            return false;
        }
        DEREnumerated other = (DEREnumerated)o;
        return Arrays.areEqual(this.bytes, other.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    static ASN1Enumerated fromOctetString(byte[] enc) {
        if (enc.length > 1) {
            return new ASN1Enumerated(Arrays.clone(enc));
        }
        if (enc.length == 0) {
            throw new IllegalArgumentException("ENUMERATED has zero length");
        }
        int value = enc[0] & 0xFF;
        if (value >= cache.length) {
            return new ASN1Enumerated(Arrays.clone(enc));
        }
        ASN1Enumerated possibleMatch = cache[value];
        if (possibleMatch == null) {
            possibleMatch = DEREnumerated.cache[value] = new ASN1Enumerated(Arrays.clone(enc));
        }
        return possibleMatch;
    }
}

