/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.asn1.x500.style;

import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Primitive;
import cmbc.cfca.org.bouncycastle.asn1.ASN1String;
import cmbc.cfca.org.bouncycastle.asn1.DERUniversalString;
import cmbc.cfca.org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import cmbc.cfca.org.bouncycastle.asn1.x500.RDN;
import cmbc.cfca.org.bouncycastle.asn1.x500.X500NameBuilder;
import cmbc.cfca.org.bouncycastle.asn1.x500.X500NameStyle;
import cmbc.cfca.org.bouncycastle.asn1.x500.style.X500NameTokenizer;
import cmbc.cfca.org.bouncycastle.util.Strings;
import cmbc.cfca.org.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class IETFUtils {
    public static RDN[] rDNsFromString(String name, X500NameStyle x500Style) {
        X500NameTokenizer nTok = new X500NameTokenizer(name);
        X500NameBuilder builder = new X500NameBuilder(x500Style);
        while (nTok.hasMoreTokens()) {
            String token = nTok.nextToken();
            int index = token.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String attr = token.substring(0, index);
            String value = token.substring(index + 1);
            ASN1ObjectIdentifier oid = x500Style.attrNameToOID(attr);
            if (value.indexOf(43) > 0) {
                X500NameTokenizer vTok = new X500NameTokenizer(value, '+');
                String v = vTok.nextToken();
                Vector<ASN1ObjectIdentifier> oids = new Vector<ASN1ObjectIdentifier>();
                Vector<String> values = new Vector<String>();
                oids.addElement(oid);
                values.addElement(v);
                while (vTok.hasMoreTokens()) {
                    String sv = vTok.nextToken();
                    int ndx = sv.indexOf(61);
                    String nm = sv.substring(0, ndx);
                    String vl = sv.substring(ndx + 1);
                    oids.addElement(x500Style.attrNameToOID(nm));
                    values.addElement(vl);
                }
                builder.addMultiValuedRDN(IETFUtils.toOIDArray(oids), IETFUtils.toValueArray(values));
                continue;
            }
            builder.addRDN(oid, value);
        }
        return builder.build().getRDNs();
    }

    private static String[] toValueArray(Vector values) {
        String[] tmp = new String[values.size()];
        for (int i = 0; i != tmp.length; ++i) {
            tmp[i] = (String)values.elementAt(i);
        }
        return tmp;
    }

    private static ASN1ObjectIdentifier[] toOIDArray(Vector oids) {
        ASN1ObjectIdentifier[] tmp = new ASN1ObjectIdentifier[oids.size()];
        for (int i = 0; i != tmp.length; ++i) {
            tmp[i] = (ASN1ObjectIdentifier)oids.elementAt(i);
        }
        return tmp;
    }

    public static ASN1ObjectIdentifier decodeAttrName(String name, Hashtable lookUp) {
        String dnName = Strings.toLowerCase(name.trim());
        if (dnName.startsWith("oid")) {
            return new ASN1ObjectIdentifier(name.substring(4));
        }
        if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            return new ASN1ObjectIdentifier(name);
        }
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)lookUp.get(dnName);
        if (oid == null) {
            throw new IllegalArgumentException("Unknown object id - " + name + " - passed to distinguished name");
        }
        return oid;
    }

    public static ASN1Encodable valueFromHexString(String str, int off) throws IOException {
        str = Strings.toLowerCase(str);
        byte[] data = new byte[(str.length() - off) / 2];
        for (int index = 0; index != data.length; ++index) {
            char left = str.charAt(index * 2 + off);
            char right = str.charAt(index * 2 + off + 1);
            data[index] = left < 'a' ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
            if (right < 'a') {
                int n = index;
                data[n] = (byte)(data[n] | (byte)(right - 48));
                continue;
            }
            int n = index;
            data[n] = (byte)(data[n] | (byte)(right - 97 + 10));
        }
        return ASN1Primitive.fromByteArray(data);
    }

    public static void appendTypeAndValue(StringBuffer buf, AttributeTypeAndValue typeAndValue, Hashtable oidSymbols) {
        String sym = (String)oidSymbols.get(typeAndValue.getType());
        if (sym != null) {
            buf.append(sym);
        } else {
            buf.append(typeAndValue.getType().getId());
        }
        buf.append('=');
        buf.append(IETFUtils.valueToString(typeAndValue.getValue()));
    }

    public static String valueToString(ASN1Encodable value) {
        StringBuffer vBuf = new StringBuffer();
        if (value instanceof ASN1String && !(value instanceof DERUniversalString)) {
            String v = ((ASN1String)((Object)value)).getString();
            if (v.length() > 0 && v.charAt(0) == '#') {
                vBuf.append("\\" + v);
            } else {
                vBuf.append(v);
            }
        } else {
            try {
                vBuf.append("#" + IETFUtils.bytesToString(Hex.encode(value.toASN1Primitive().getEncoded("DER"))));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Other value has no encoded form");
            }
        }
        int end = vBuf.length();
        int index = 0;
        if (vBuf.length() >= 2 && vBuf.charAt(0) == '\\' && vBuf.charAt(1) == '#') {
            index += 2;
        }
        while (index != end) {
            if (vBuf.charAt(index) == ',' || vBuf.charAt(index) == '\"' || vBuf.charAt(index) == '\\' || vBuf.charAt(index) == '+' || vBuf.charAt(index) == '=' || vBuf.charAt(index) == '<' || vBuf.charAt(index) == '>' || vBuf.charAt(index) == ';') {
                vBuf.insert(index, "\\");
                ++index;
                ++end;
            }
            ++index;
        }
        return vBuf.toString();
    }

    private static String bytesToString(byte[] data) {
        char[] cs = new char[data.length];
        for (int i = 0; i != cs.length; ++i) {
            cs[i] = (char)(data[i] & 0xFF);
        }
        return new String(cs);
    }

    public static String canonicalize(String s) {
        ASN1Primitive obj;
        String value = Strings.toLowerCase(s.trim());
        if (value.length() > 0 && value.charAt(0) == '#' && (obj = IETFUtils.decodeObject(value)) instanceof ASN1String) {
            value = Strings.toLowerCase(((ASN1String)((Object)obj)).getString().trim());
        }
        value = IETFUtils.stripInternalSpaces(value);
        return value;
    }

    private static ASN1Primitive decodeObject(String oValue) {
        try {
            return ASN1Primitive.fromByteArray(Hex.decode(oValue.substring(1)));
        }
        catch (IOException e) {
            throw new IllegalStateException("unknown encoding in name: " + e);
        }
    }

    public static String stripInternalSpaces(String str) {
        StringBuffer res = new StringBuffer();
        if (str.length() != 0) {
            char c1 = str.charAt(0);
            res.append(c1);
            for (int k = 1; k < str.length(); ++k) {
                char c2 = str.charAt(k);
                if (c1 != ' ' || c2 != ' ') {
                    res.append(c2);
                }
                c1 = c2;
            }
        }
        return res.toString();
    }
}

