/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cert.crmf;

import cmbc.cfca.org.bouncycastle.asn1.DERBitString;
import cmbc.cfca.org.bouncycastle.asn1.crmf.PKMACValue;
import cmbc.cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cmbc.cfca.org.bouncycastle.cert.crmf.CRMFException;
import cmbc.cfca.org.bouncycastle.cert.crmf.PKMACBuilder;
import cmbc.cfca.org.bouncycastle.operator.MacCalculator;
import java.io.IOException;
import java.io.OutputStream;

class PKMACValueGenerator {
    private PKMACBuilder builder;

    public PKMACValueGenerator(PKMACBuilder builder) {
        this.builder = builder;
    }

    public PKMACValue generate(char[] password, SubjectPublicKeyInfo keyInfo) throws CRMFException {
        MacCalculator calculator = this.builder.build(password);
        OutputStream macOut = calculator.getOutputStream();
        try {
            macOut.write(keyInfo.getEncoded("DER"));
            macOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("exception encoding mac input: " + e.getMessage(), e);
        }
        return new PKMACValue(calculator.getAlgorithmIdentifier(), new DERBitString(calculator.getMac()));
    }
}

