/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cms;

import cmbc.cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.BEROctetString;
import cmbc.cfca.org.bouncycastle.asn1.BERSet;
import cmbc.cfca.org.bouncycastle.asn1.DEROctetString;
import cmbc.cfca.org.bouncycastle.asn1.DERSet;
import cmbc.cfca.org.bouncycastle.asn1.cms.AuthenticatedData;
import cmbc.cfca.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.cms.ContentInfo;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.cms.CMSAuthenticatedData;
import cmbc.cfca.org.bouncycastle.cms.CMSAuthenticatedGenerator;
import cmbc.cfca.org.bouncycastle.cms.CMSEnvelopedHelper;
import cmbc.cfca.org.bouncycastle.cms.CMSException;
import cmbc.cfca.org.bouncycastle.cms.CMSProcessable;
import cmbc.cfca.org.bouncycastle.cms.CMSTypedData;
import cmbc.cfca.org.bouncycastle.cms.CMSUtils;
import cmbc.cfca.org.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import cmbc.cfca.org.bouncycastle.cms.RecipientInfoGenerator;
import cmbc.cfca.org.bouncycastle.cms.jcajce.JceCMSMacCalculatorBuilder;
import cmbc.cfca.org.bouncycastle.operator.DigestCalculator;
import cmbc.cfca.org.bouncycastle.operator.DigestCalculatorProvider;
import cmbc.cfca.org.bouncycastle.operator.MacCalculator;
import cmbc.cfca.org.bouncycastle.operator.OperatorCreationException;
import cmbc.cfca.org.bouncycastle.util.io.TeeOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;

public class CMSAuthenticatedDataGenerator
extends CMSAuthenticatedGenerator {
    public CMSAuthenticatedDataGenerator() {
    }

    public CMSAuthenticatedData generate(CMSTypedData typedData, MacCalculator macCalculator) throws CMSException {
        return this.generate(typedData, macCalculator, null);
    }

    public CMSAuthenticatedData generate(CMSTypedData typedData, MacCalculator macCalculator, final DigestCalculator digestCalculator) throws CMSException {
        AuthenticatedData authData;
        ByteArrayOutputStream bOut;
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        for (RecipientInfoGenerator recipient : this.recipientInfoGenerators) {
            recipientInfos.add(recipient.generate(macCalculator.getKey()));
        }
        if (digestCalculator != null) {
            DEROctetString macResult;
            BEROctetString encContent;
            try {
                bOut = new ByteArrayOutputStream();
                TeeOutputStream out = new TeeOutputStream(digestCalculator.getOutputStream(), bOut);
                typedData.write(out);
                ((OutputStream)out).close();
                encContent = new BEROctetString(bOut.toByteArray());
            }
            catch (IOException e) {
                throw new CMSException("unable to perform digest calculation: " + e.getMessage(), e);
            }
            Map parameters = this.getBaseParameters(typedData.getContentType(), digestCalculator.getAlgorithmIdentifier(), digestCalculator.getDigest());
            if (this.authGen == null) {
                this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
            }
            DERSet authed = new DERSet(this.authGen.getAttributes(Collections.unmodifiableMap(parameters)).toASN1EncodableVector());
            try {
                OutputStream mOut = macCalculator.getOutputStream();
                mOut.write(authed.getEncoded("DER"));
                mOut.close();
                macResult = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException e) {
                throw new CMSException("exception decoding algorithm parameters.", e);
            }
            BERSet unauthed = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(Collections.unmodifiableMap(parameters)).toASN1EncodableVector()) : null;
            ContentInfo eci = new ContentInfo(CMSObjectIdentifiers.data, encContent);
            authData = new AuthenticatedData(this.originatorInfo, new DERSet(recipientInfos), macCalculator.getAlgorithmIdentifier(), digestCalculator.getAlgorithmIdentifier(), eci, authed, macResult, unauthed);
        } else {
            DEROctetString macResult;
            BEROctetString encContent;
            try {
                bOut = new ByteArrayOutputStream();
                TeeOutputStream mOut = new TeeOutputStream(bOut, macCalculator.getOutputStream());
                typedData.write(mOut);
                ((OutputStream)mOut).close();
                encContent = new BEROctetString(bOut.toByteArray());
                macResult = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException e) {
                throw new CMSException("exception decoding algorithm parameters.", e);
            }
            BERSet unauthed = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(new HashMap()).toASN1EncodableVector()) : null;
            ContentInfo eci = new ContentInfo(CMSObjectIdentifiers.data, encContent);
            authData = new AuthenticatedData(this.originatorInfo, new DERSet(recipientInfos), macCalculator.getAlgorithmIdentifier(), null, eci, null, macResult, unauthed);
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.authenticatedData, authData);
        return new CMSAuthenticatedData(contentInfo, new DigestCalculatorProvider(){

            public DigestCalculator get(AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
                return digestCalculator;
            }
        });
    }

    public CMSAuthenticatedDataGenerator(SecureRandom rand) {
        super(rand);
    }

    private CMSAuthenticatedData generate(final CMSProcessable content, String macOID, KeyGenerator keyGen, Provider provider) throws NoSuchAlgorithmException, CMSException {
        Provider encProvider = keyGen.getProvider();
        this.convertOldRecipients(this.rand, provider);
        return this.generate(new CMSTypedData(){

            public ASN1ObjectIdentifier getContentType() {
                return CMSObjectIdentifiers.data;
            }

            public void write(OutputStream out) throws IOException, CMSException {
                content.write(out);
            }

            public Object getContent() {
                return content;
            }
        }, new JceCMSMacCalculatorBuilder(new ASN1ObjectIdentifier(macOID)).setProvider(encProvider).setSecureRandom(this.rand).build());
    }

    public CMSAuthenticatedData generate(CMSProcessable content, String macOID, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, macOID, CMSUtils.getProvider(provider));
    }

    public CMSAuthenticatedData generate(CMSProcessable content, String encryptionOID, Provider provider) throws NoSuchAlgorithmException, CMSException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        return this.generate(content, encryptionOID, keyGen, provider);
    }
}

