/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cms;

import cmbc.cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Integer;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Set;
import cmbc.cfca.org.bouncycastle.asn1.BERSequenceGenerator;
import cmbc.cfca.org.bouncycastle.asn1.BERSet;
import cmbc.cfca.org.bouncycastle.asn1.DERInteger;
import cmbc.cfca.org.bouncycastle.asn1.DERSet;
import cmbc.cfca.org.bouncycastle.asn1.DERTaggedObject;
import cmbc.cfca.org.bouncycastle.asn1.cms.AttributeTable;
import cmbc.cfca.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.cms.EnvelopedData;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.cms.CMSEnvelopedGenerator;
import cmbc.cfca.org.bouncycastle.cms.CMSEnvelopedHelper;
import cmbc.cfca.org.bouncycastle.cms.CMSException;
import cmbc.cfca.org.bouncycastle.cms.CMSUtils;
import cmbc.cfca.org.bouncycastle.cms.RecipientInfoGenerator;
import cmbc.cfca.org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import cmbc.cfca.org.bouncycastle.operator.GenericKey;
import cmbc.cfca.org.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.KeyGenerator;

public class CMSEnvelopedDataStreamGenerator
extends CMSEnvelopedGenerator {
    private ASN1Set _unprotectedAttributes = null;
    private int _bufferSize;
    private boolean _berEncodeRecipientSet;

    public CMSEnvelopedDataStreamGenerator() {
    }

    public CMSEnvelopedDataStreamGenerator(SecureRandom rand) {
        super(rand);
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setBEREncodeRecipients(boolean berEncodeRecipientSet) {
        this._berEncodeRecipientSet = berEncodeRecipientSet;
    }

    private DERInteger getVersion() {
        if (this.originatorInfo != null || this._unprotectedAttributes != null) {
            return new DERInteger(2);
        }
        return new DERInteger(0);
    }

    private OutputStream open(OutputStream out, String encryptionOID, int keySize, Provider encProvider, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        this.convertOldRecipients(this.rand, provider);
        JceCMSContentEncryptorBuilder builder = keySize != -1 ? new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(encryptionOID), keySize) : new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(encryptionOID));
        builder.setProvider(encProvider);
        builder.setSecureRandom(this.rand);
        return this.doOpen(CMSObjectIdentifiers.data, out, builder.build());
    }

    private OutputStream doOpen(ASN1ObjectIdentifier dataType, OutputStream out, OutputEncryptor encryptor) throws IOException, CMSException {
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        GenericKey encKey = encryptor.getKey();
        for (RecipientInfoGenerator recipient : this.recipientInfoGenerators) {
            recipientInfos.add(recipient.generate(encKey));
        }
        return this.open(dataType, out, recipientInfos, encryptor);
    }

    protected OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, ASN1EncodableVector recipientInfos, OutputEncryptor encryptor) throws IOException {
        BERSequenceGenerator cGen = new BERSequenceGenerator(out);
        cGen.addObject(CMSObjectIdentifiers.envelopedData);
        BERSequenceGenerator envGen = new BERSequenceGenerator(cGen.getRawOutputStream(), 0, true);
        envGen.addObject(this.getVersion());
        if (this.originatorInfo != null) {
            envGen.addObject(new DERTaggedObject(false, 0, this.originatorInfo));
        }
        if (this._berEncodeRecipientSet) {
            envGen.getRawOutputStream().write(new BERSet(recipientInfos).getEncoded());
        } else {
            envGen.getRawOutputStream().write(new DERSet(recipientInfos).getEncoded());
        }
        BERSequenceGenerator eiGen = new BERSequenceGenerator(envGen.getRawOutputStream());
        eiGen.addObject(dataType);
        AlgorithmIdentifier encAlgId = encryptor.getAlgorithmIdentifier();
        eiGen.getRawOutputStream().write(encAlgId.getEncoded());
        OutputStream octetStream = CMSUtils.createBEROctetOutputStream(eiGen.getRawOutputStream(), 0, false, this._bufferSize);
        OutputStream cOut = encryptor.getOutputStream(octetStream);
        return new CmsEnvelopedDataOutputStream(cOut, cGen, envGen, eiGen);
    }

    protected OutputStream open(OutputStream out, ASN1EncodableVector recipientInfos, OutputEncryptor encryptor) throws CMSException {
        try {
            BERSequenceGenerator cGen = new BERSequenceGenerator(out);
            cGen.addObject(CMSObjectIdentifiers.envelopedData);
            BERSequenceGenerator envGen = new BERSequenceGenerator(cGen.getRawOutputStream(), 0, true);
            ASN1Set recipients = this._berEncodeRecipientSet ? new BERSet(recipientInfos) : new DERSet(recipientInfos);
            envGen.addObject(new ASN1Integer(EnvelopedData.calculateVersion(this.originatorInfo, recipients, this._unprotectedAttributes)));
            if (this.originatorInfo != null) {
                envGen.addObject(new DERTaggedObject(false, 0, this.originatorInfo));
            }
            envGen.getRawOutputStream().write(recipients.getEncoded());
            BERSequenceGenerator eiGen = new BERSequenceGenerator(envGen.getRawOutputStream());
            eiGen.addObject(CMSObjectIdentifiers.data);
            AlgorithmIdentifier encAlgId = encryptor.getAlgorithmIdentifier();
            eiGen.getRawOutputStream().write(encAlgId.getEncoded());
            OutputStream octetStream = CMSUtils.createBEROctetOutputStream(eiGen.getRawOutputStream(), 0, false, this._bufferSize);
            return new CmsEnvelopedDataOutputStream(encryptor.getOutputStream(octetStream), cGen, envGen, eiGen);
        }
        catch (IOException e) {
            throw new CMSException("exception decoding algorithm parameters.", e);
        }
    }

    public OutputStream open(OutputStream out, String encryptionOID, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        return this.open(out, encryptionOID, CMSUtils.getProvider(provider));
    }

    public OutputStream open(OutputStream out, String encryptionOID, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        keyGen.init(this.rand);
        return this.open(out, encryptionOID, -1, keyGen.getProvider(), provider);
    }

    public OutputStream open(OutputStream out, String encryptionOID, int keySize, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        return this.open(out, encryptionOID, keySize, CMSUtils.getProvider(provider));
    }

    public OutputStream open(OutputStream out, String encryptionOID, int keySize, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        keyGen.init(keySize, this.rand);
        return this.open(out, encryptionOID, -1, keyGen.getProvider(), provider);
    }

    public OutputStream open(OutputStream out, OutputEncryptor encryptor) throws CMSException, IOException {
        return this.doOpen(new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId()), out, encryptor);
    }

    public OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, OutputEncryptor encryptor) throws CMSException, IOException {
        return this.doOpen(dataType, out, encryptor);
    }

    private class CmsEnvelopedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private BERSequenceGenerator _cGen;
        private BERSequenceGenerator _envGen;
        private BERSequenceGenerator _eiGen;

        public CmsEnvelopedDataOutputStream(OutputStream out, BERSequenceGenerator cGen, BERSequenceGenerator envGen, BERSequenceGenerator eiGen) {
            this._out = out;
            this._cGen = cGen;
            this._envGen = envGen;
            this._eiGen = eiGen;
        }

        public void write(int b) throws IOException {
            this._out.write(b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this._out.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            if (CMSEnvelopedDataStreamGenerator.this.unprotectedAttributeGenerator != null) {
                AttributeTable attrTable = CMSEnvelopedDataStreamGenerator.this.unprotectedAttributeGenerator.getAttributes(new HashMap());
                BERSet unprotectedAttrs = new BERSet(attrTable.toASN1EncodableVector());
                this._envGen.addObject(new DERTaggedObject(false, 1, unprotectedAttrs));
            }
            this._envGen.close();
            this._cGen.close();
        }
    }
}

