/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cms;

import cmbc.cfca.org.bouncycastle.asn1.cms.KEKIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.cms.AuthAttributesProvider;
import cmbc.cfca.org.bouncycastle.cms.CMSEnvelopedHelper;
import cmbc.cfca.org.bouncycastle.cms.CMSException;
import cmbc.cfca.org.bouncycastle.cms.CMSSecureReadable;
import cmbc.cfca.org.bouncycastle.cms.CMSTypedStream;
import cmbc.cfca.org.bouncycastle.cms.CMSUtils;
import cmbc.cfca.org.bouncycastle.cms.KEKRecipient;
import cmbc.cfca.org.bouncycastle.cms.KEKRecipientId;
import cmbc.cfca.org.bouncycastle.cms.Recipient;
import cmbc.cfca.org.bouncycastle.cms.RecipientInformation;
import cmbc.cfca.org.bouncycastle.cms.RecipientOperator;
import cmbc.cfca.org.bouncycastle.cms.jcajce.JceKEKAuthenticatedRecipient;
import cmbc.cfca.org.bouncycastle.cms.jcajce.JceKEKEnvelopedRecipient;
import cmbc.cfca.org.bouncycastle.cms.jcajce.JceKEKRecipient;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.SecretKey;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(prov));
    }

    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            JceKEKRecipient recipient = this.secureReadable instanceof CMSEnvelopedHelper.CMSEnvelopedSecureReadable ? new JceKEKEnvelopedRecipient((SecretKey)key) : new JceKEKAuthenticatedRecipient((SecretKey)key);
            if (prov != null) {
                recipient.setProvider(prov);
            }
            return this.getContentStream(recipient);
        }
        catch (IOException e) {
            throw new CMSException("encoding error: " + e.getMessage(), e);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

