/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cms.jcajce;

import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.cms.CMSException;
import cmbc.cfca.org.bouncycastle.cms.KEKRecipient;
import cmbc.cfca.org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import cmbc.cfca.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import cmbc.cfca.org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import cmbc.cfca.org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import cmbc.cfca.org.bouncycastle.operator.OperatorException;
import cmbc.cfca.org.bouncycastle.operator.SymmetricKeyUnwrapper;
import java.security.Key;
import java.security.Provider;
import javax.crypto.SecretKey;

public abstract class JceKEKRecipient
implements KEKRecipient {
    private SecretKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;

    public JceKEKRecipient(SecretKey recipientKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
        this.recipientKey = recipientKey;
    }

    public JceKEKRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKEKRecipient setProvider(String providerName) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceKEKRecipient setContentProvider(Provider provider) {
        this.contentHelper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKEKRecipient setContentProvider(String providerName) {
        this.contentHelper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    protected Key extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        SymmetricKeyUnwrapper unwrapper = this.helper.createSymmetricUnwrapper(keyEncryptionAlgorithm, this.recipientKey);
        try {
            return this.helper.getJceKey(contentEncryptionAlgorithm.getAlgorithm(), unwrapper.generateUnwrappedKey(contentEncryptionAlgorithm, encryptedContentEncryptionKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
        }
    }
}

