/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.operator.bc;

import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cmbc.cfca.org.bouncycastle.crypto.Digest;
import cmbc.cfca.org.bouncycastle.crypto.Signer;
import cmbc.cfca.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cmbc.cfca.org.bouncycastle.crypto.signers.RSADigestSigner;
import cmbc.cfca.org.bouncycastle.crypto.util.PublicKeyFactory;
import cmbc.cfca.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import cmbc.cfca.org.bouncycastle.operator.OperatorCreationException;
import cmbc.cfca.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import cmbc.cfca.org.bouncycastle.operator.bc.BcUtil;
import java.io.IOException;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        Digest dig = BcUtil.createDigest(digAlg);
        return new RSADigestSigner(dig);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}

