/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.operator.jcajce;

import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.DERInteger;
import cmbc.cfca.org.bouncycastle.asn1.DERNull;
import cmbc.cfca.org.bouncycastle.asn1.DERObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import cmbc.cfca.org.bouncycastle.jcajce.NamedJcaJceHelper;
import cmbc.cfca.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import cmbc.cfca.org.bouncycastle.operator.GenericKey;
import cmbc.cfca.org.bouncycastle.operator.OperatorException;
import cmbc.cfca.org.bouncycastle.operator.SymmetricKeyWrapper;
import cmbc.cfca.org.bouncycastle.operator.jcajce.OperatorHelper;
import cmbc.cfca.org.bouncycastle.operator.jcajce.OperatorUtils;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class JceSymmetricKeyWrapper
extends SymmetricKeyWrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecureRandom random;
    private SecretKey wrappingKey;

    public JceSymmetricKeyWrapper(SecretKey wrappingKey) {
        super(JceSymmetricKeyWrapper.determineKeyEncAlg(wrappingKey));
        this.wrappingKey = wrappingKey;
    }

    public JceSymmetricKeyWrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceSymmetricKeyWrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceSymmetricKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        Key contentEncryptionKeySpec = OperatorUtils.getJceKey(encryptionKey);
        Cipher keyEncryptionCipher = this.helper.createSymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
        try {
            keyEncryptionCipher.init(3, (Key)this.wrappingKey, this.random);
            return keyEncryptionCipher.wrap(contentEncryptionKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw new OperatorException("cannot wrap key: " + e.getMessage(), e);
        }
    }

    private static AlgorithmIdentifier determineKeyEncAlg(SecretKey key) {
        String algorithm = key.getAlgorithm();
        if (algorithm.startsWith("DES")) {
            return new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.6"), (ASN1Encodable)new DERNull());
        }
        if (algorithm.startsWith("RC2")) {
            return new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.7"), (ASN1Encodable)new DERInteger(58));
        }
        if (algorithm.startsWith("AES")) {
            ASN1ObjectIdentifier wrapOid;
            int length = key.getEncoded().length * 8;
            if (length == 128) {
                wrapOid = NISTObjectIdentifiers.id_aes128_wrap;
            } else if (length == 192) {
                wrapOid = NISTObjectIdentifiers.id_aes192_wrap;
            } else if (length == 256) {
                wrapOid = NISTObjectIdentifiers.id_aes256_wrap;
            } else {
                throw new IllegalArgumentException("illegal keysize in AES");
            }
            return new AlgorithmIdentifier((DERObjectIdentifier)wrapOid);
        }
        if (algorithm.startsWith("SEED")) {
            return new AlgorithmIdentifier(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap);
        }
        if (algorithm.startsWith("Camellia")) {
            ASN1ObjectIdentifier wrapOid;
            int length = key.getEncoded().length * 8;
            if (length == 128) {
                wrapOid = NTTObjectIdentifiers.id_camellia128_wrap;
            } else if (length == 192) {
                wrapOid = NTTObjectIdentifiers.id_camellia192_wrap;
            } else if (length == 256) {
                wrapOid = NTTObjectIdentifiers.id_camellia256_wrap;
            } else {
                throw new IllegalArgumentException("illegal keysize in Camellia");
            }
            return new AlgorithmIdentifier((DERObjectIdentifier)wrapOid);
        }
        throw new IllegalArgumentException("unknown algorithm");
    }
}

