/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.pkcs.bc;

import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.DERNull;
import cmbc.cfca.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.crypto.ExtendedDigest;
import cmbc.cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cmbc.cfca.org.bouncycastle.operator.MacCalculator;
import cmbc.cfca.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import cmbc.cfca.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import cmbc.cfca.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProviderBuilder
implements PKCS12MacCalculatorBuilderProvider {
    private ExtendedDigest digest;
    private AlgorithmIdentifier digestAlgorithmIdentifier;

    public BcPKCS12MacCalculatorBuilderProviderBuilder() {
        this(new SHA1Digest(), new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE));
    }

    public BcPKCS12MacCalculatorBuilderProviderBuilder(ExtendedDigest digest, AlgorithmIdentifier algorithmIdentifier) {
        this.digest = digest;
        this.digestAlgorithmIdentifier = algorithmIdentifier;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] password) {
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(BcPKCS12MacCalculatorBuilderProviderBuilder.this.digestAlgorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProviderBuilder.this.digest, pbeParams, password);
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return BcPKCS12MacCalculatorBuilderProviderBuilder.this.digestAlgorithmIdentifier;
            }
        };
    }
}

