/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.sadk32.org.bouncycastle.asn1.sm2;

import cmbc.cfca.org.bouncycastle.util.encoders.Hex;
import cmbc.cfca.sadk32.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import java.io.IOException;
import java.util.Arrays;

final class ASN1SM2SignatureTest {
    ASN1SM2SignatureTest() {
    }

    public static void main(String[] args) throws Exception {
        String signText = null;
        String signRSvl = null;
        ASN1SM2Signature asn1 = null;
        signText = "30440220017777777777777777777777777777777777777777777777777777777777777702200177777777777777777777777777777777777777777777777777777777777777";
        signRSvl = "01777777777777777777777777777777777777777777777777777777777777770177777777777777777777777777777777777777777777777777777777777777";
        asn1 = new ASN1SM2Signature(Hex.decode(signText));
        ASN1SM2SignatureTest.println(asn1, signRSvl, "T1");
        signText = "30440220887777777777777777777777777777777777777777777777777777777777777702200177777777777777777777777777777777777777777777777777777777777777";
        signRSvl = "88777777777777777777777777777777777777777777777777777777777777770177777777777777777777777777777777777777777777777777777777777777";
        asn1 = new ASN1SM2Signature(Hex.decode(signText));
        ASN1SM2SignatureTest.println(asn1, signRSvl, "T2");
        signText = "3045022100887777777777777777777777777777777777777777777777777777777777777702200177777777777777777777777777777777777777777777777777777777777777";
        signRSvl = "88777777777777777777777777777777777777777777777777777777777777770177777777777777777777777777777777777777777777777777777777777777";
        asn1 = new ASN1SM2Signature(Hex.decode(signText));
        ASN1SM2SignatureTest.println(asn1, signRSvl, "T3");
        signText = "30440220017777777777777777777777777777777777777777777777777777777777777702208877777777777777777777777777777777777777777777777777777777777777";
        signRSvl = "01777777777777777777777777777777777777777777777777777777777777778877777777777777777777777777777777777777777777777777777777777777";
        asn1 = new ASN1SM2Signature(Hex.decode(signText));
        ASN1SM2SignatureTest.println(asn1, signRSvl, "T4");
        signText = "3045022001777777777777777777777777777777777777777777777777777777777777770221008877777777777777777777777777777777777777777777777777777777777777";
        signRSvl = "01777777777777777777777777777777777777777777777777777777777777778877777777777777777777777777777777777777777777777777777777777777";
        asn1 = new ASN1SM2Signature(Hex.decode(signText));
        ASN1SM2SignatureTest.println(asn1, signRSvl, "T5");
        signText = "30440220887777777777777777777777777777777777777777777777777777777777777702208877777777777777777777777777777777777777777777777777777777777777";
        signRSvl = "88777777777777777777777777777777777777777777777777777777777777778877777777777777777777777777777777777777777777777777777777777777";
        asn1 = new ASN1SM2Signature(Hex.decode(signText));
        ASN1SM2SignatureTest.println(asn1, signRSvl, "T6");
        signText = "304602210088777777777777777777777777777777777777777777777777777777777777770221008877777777777777777777777777777777777777777777777777777777777777";
        signRSvl = "88777777777777777777777777777777777777777777777777777777777777778877777777777777777777777777777777777777777777777777777777777777";
        asn1 = new ASN1SM2Signature(Hex.decode(signText));
        ASN1SM2SignatureTest.println(asn1, signRSvl, "T7");
        signText = "303e021a017777777777777777777777777777777777777777777777777702200177777777777777777777777777777777777777777777777777777777777777";
        signRSvl = "00000000000001777777777777777777777777777777777777777777777777770177777777777777777777777777777777777777777777777777777777777777";
        asn1 = new ASN1SM2Signature(Hex.decode(signText));
        ASN1SM2SignatureTest.println(asn1, signRSvl, "T8");
        signText = "303e02200177777777777777777777777777777777777777777777777777777777777777021a0177777777777777777777777777777777777777777777777777";
        signRSvl = "01777777777777777777777777777777777777777777777777777777777777770000000000000177777777777777777777777777777777777777777777777777";
        asn1 = new ASN1SM2Signature(Hex.decode(signText));
        ASN1SM2SignatureTest.println(asn1, signRSvl, "T9");
        signText = "3038021a0177777777777777777777777777777777777777777777777777021a0177777777777777777777777777777777777777777777777777";
        signRSvl = "00000000000001777777777777777777777777777777777777777777777777770000000000000177777777777777777777777777777777777777777777777777";
        asn1 = new ASN1SM2Signature(Hex.decode(signText));
        ASN1SM2SignatureTest.println(asn1, signRSvl, "T10");
        signText = "303d02200177777777777777777777777777777777777777777777777777777777777777021901777777777777777777777777777777777777777777777777";
        asn1 = new ASN1SM2Signature(Hex.decode(signText));
        ASN1SM2SignatureTest.failure(asn1, "T11");
    }

    static final void println(ASN1SM2Signature asn1, String signRSvl, String testName) throws IOException {
        byte[] data = asn1.getEncoded();
        StringBuilder builder = new StringBuilder();
        builder.append(testName);
        builder.append(" signLength=").append(data.length);
        builder.append(" : [ ").append(ASN1SM2Signature.isASN1SignType(data));
        builder.append(" , ").append(Arrays.equals(asn1.getRS(), Hex.decode(signRSvl)));
        builder.append(" ]");
        System.err.println(builder);
    }

    static final void failure(ASN1SM2Signature asn1, String testName) throws IOException {
        byte[] data = asn1.getEncoded();
        StringBuilder builder = new StringBuilder();
        builder.append(testName);
        builder.append(" signLength=").append(data.length);
        builder.append(" : [ ").append(!ASN1SM2Signature.isASN1SignType(data));
        builder.append(" ]");
        System.err.println(builder);
    }
}

