/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.sm2.envelope;

import cmbc.cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Object;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Primitive;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Sequence;
import cmbc.cfca.org.bouncycastle.asn1.BERSequence;
import cmbc.cfca.org.bouncycastle.asn1.BERTaggedObject;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.sm2.envelope.SM2EncryptedInputStream;

public class SM2EncryptedContentInfo
extends ASN1Object {
    private ASN1ObjectIdentifier contentType;
    private AlgorithmIdentifier contentEncryptionAlgorithm;
    private SM2EncryptedInputStream encryptedStream;

    public SM2EncryptedContentInfo(ASN1ObjectIdentifier contentType, AlgorithmIdentifier contentEncryptionAlgorithm, SM2EncryptedInputStream encryptedStream) {
        this.contentType = contentType;
        this.contentEncryptionAlgorithm = contentEncryptionAlgorithm;
        this.encryptedStream = encryptedStream;
    }

    private SM2EncryptedContentInfo(ASN1Sequence seq) {
        if (seq.size() < 2) {
            throw new IllegalArgumentException("Truncated Sequence Found");
        }
        this.contentType = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        this.contentEncryptionAlgorithm = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        if (seq.size() > 2) {
            this.encryptedStream = SM2EncryptedInputStream.getInstance(seq.getObjectAt(2));
        }
    }

    public static SM2EncryptedContentInfo getInstance(Object obj) {
        if (obj instanceof SM2EncryptedContentInfo) {
            return (SM2EncryptedContentInfo)obj;
        }
        if (obj != null) {
            return new SM2EncryptedContentInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public SM2EncryptedInputStream getEncryptedContent() {
        return this.encryptedStream;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.contentType);
        v.add(this.contentEncryptionAlgorithm);
        if (this.encryptedStream != null) {
            v.add(new BERTaggedObject(false, 0, this.encryptedStream));
        }
        return new BERSequence(v);
    }
}

