/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.sm2.envelope;

import cmbc.cfca.asn1.parser.ASN1Node;
import cmbc.cfca.asn1.parser.BigFileDecrypt;
import cmbc.cfca.asn1.parser.EnvelopFileParser;
import cmbc.cfca.internal.tool.ASN1Parser;
import cmbc.cfca.internal.tool.Mechanism_Inside;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cmbc.cfca.org.bouncycastle.asn1.ASN1OctetString;
import cmbc.cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Sequence;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Set;
import cmbc.cfca.org.bouncycastle.asn1.BEROctetString;
import cmbc.cfca.org.bouncycastle.asn1.DERNull;
import cmbc.cfca.org.bouncycastle.asn1.DEROctetString;
import cmbc.cfca.org.bouncycastle.asn1.DEROutputStream;
import cmbc.cfca.org.bouncycastle.asn1.DERSet;
import cmbc.cfca.org.bouncycastle.asn1.cms.ContentInfo;
import cmbc.cfca.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import cmbc.cfca.org.bouncycastle.asn1.cms.EnvelopedData;
import cmbc.cfca.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cmbc.cfca.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cmbc.cfca.org.bouncycastle.asn1.cms.RecipientIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.cms.RecipientInfo;
import cmbc.cfca.org.bouncycastle.asn1.x500.X500Name;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cmbc.cfca.org.bouncycastle.cms.CMSEnvelopedData;
import cmbc.cfca.sm.algorithm.SM4Engine;
import cmbc.cfca.sm2.envelope.SM2EncryptedContentInfo;
import cmbc.cfca.sm2.envelope.SM2EncryptedInputStream;
import cmbc.cfca.sm2.envelope.SM2EnvelopedData;
import cmbc.cfca.sm2.envelope.SM2SymmetricCryptoUtil;
import cmbc.cfca.sm2rsa.common.CBCParam;
import cmbc.cfca.sm2rsa.common.PKCS7EnvelopedData;
import cmbc.cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.sm2rsa.common.SymmetricAlgorithm;
import cmbc.cfca.util.Base64;
import cmbc.cfca.util.cipher.lib.BCSoftLib;
import cmbc.cfca.util.cipher.lib.JCrypto;
import cmbc.cfca.util.cipher.lib.Session;
import cmbc.cfca.x509.certificate.X509Cert;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;

public class SM2EnvelopeUtil {
    private static final int recipientPolicy = 0;

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        return SM2EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session, 0);
    }

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicyType) throws Exception {
        SymmetricAlgorithm.SymmetricAlgorithmParameters params = SM2EnvelopeUtil.buildSymmetricAlgorithmParameters(symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
        byte[] encryptedData = SM2EnvelopeUtil.SM4Encrypt(params.symmetricKey, sourceData, params.contentEncryptionAlg);
        BEROctetString encryptOctet = new BEROctetString(encryptedData);
        EncryptedContentInfo eci = new EncryptedContentInfo(PKCSObjectIdentifiers.sm2Data, params.contentEncryptionAlgId, encryptOctet);
        EnvelopedData enData = new EnvelopedData(null, new DERSet(params.recipientInfos), eci, null);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.sm2EnvelopedData, enData);
        byte[] envelopeBytes = ASN1Parser.writeDERObj2Bytes(new CMSEnvelopedData(contentInfo).toASN1Structure());
        return Base64.encode(envelopeBytes);
    }

    public static final byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts) throws Exception {
        return SM2EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, BCSoftLib.INSTANCE(), 0);
    }

    public static void envelopeFile(String sourceFilePath, String encryptedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        SM2EnvelopeUtil.envelopeFile(sourceFilePath, encryptedFilePath, symmetricAlgorithm, receiverCerts, session, 0);
    }

    public static void envelopeFile(String sourceFilePath, String encryptedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicyType) throws Exception {
        SymmetricAlgorithm.SymmetricAlgorithmParameters params = SM2EnvelopeUtil.buildSymmetricAlgorithmParameters(symmetricAlgorithm, receiverCerts, session, recipientPolicyType);
        SM2EncryptedInputStream encryptStream = new SM2EncryptedInputStream(new File(sourceFilePath), params.symmetricKey, params.contentEncryptionAlg);
        SM2EncryptedContentInfo sm2Eci = new SM2EncryptedContentInfo(PKCSObjectIdentifiers.sm2Data, params.contentEncryptionAlgId, encryptStream);
        SM2EnvelopedData enData = new SM2EnvelopedData(null, new DERSet(params.recipientInfos), sm2Eci, null);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.sm2EnvelopedData, enData);
        File file = new File(encryptedFilePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fos = null;
        ASN1OutputStream dos = null;
        try {
            fos = new FileOutputStream(file);
            dos = new DEROutputStream(fos);
            ((DEROutputStream)dos).writeObject(contentInfo);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static final void envelopeFile(String sourceFilePath, String encryptedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts) throws Exception {
        SM2EnvelopeUtil.envelopeFile(sourceFilePath, encryptedFilePath, symmetricAlgorithm, receiverCerts, BCSoftLib.INSTANCE(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void openEnvelopedFile(String encryptedFilePath, String plainTextFilePath, PrivateKey privateKey, X509Cert recipientCert, Session session) throws Exception {
        EnvelopFileParser parser = new EnvelopFileParser(new File(encryptedFilePath));
        parser.parser();
        ASN1Node receiver_node = parser.getReceiver_node();
        ASN1Node encrypted_node = parser.getEncrypted_node();
        FileOutputStream fos = null;
        try {
            ASN1Set receivers = ASN1Set.getInstance(receiver_node.getData());
            byte[] symmetricKey = SM2EnvelopeUtil.checkRecipientsAndSymmetricKey(privateKey, recipientCert, receivers, session);
            ASN1Node symmetric_encrypted = (ASN1Node)encrypted_node.childNodes.get(1);
            byte[] symmetricAlg_byte = symmetric_encrypted.getData();
            AlgorithmIdentifier symmetricAlgId = AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(symmetricAlg_byte));
            Mechanism_Inside mechanism = SM2EnvelopeUtil.buildMechanism(symmetricAlgId);
            File plainTextFile = new File(plainTextFilePath);
            if (!plainTextFile.exists()) {
                plainTextFile.createNewFile();
            }
            fos = new FileOutputStream(plainTextFile);
            ASN1Node file_encrypted = (ASN1Node)encrypted_node.childNodes.get(2);
            if (file_encrypted.childNodes.size() == 1) {
                file_encrypted = (ASN1Node)file_encrypted.childNodes.get(0);
            }
            BigFileDecrypt.bigFileBlockDecrypt(symmetricKey, new SM4Engine(), (CBCParam)mechanism.getParam(), file_encrypted, fos);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static final void openEnvelopedFile(String encryptedFilePath, String plainTextFilePath, PrivateKey privateKey, X509Cert recipientCert) throws Exception {
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        SM2EnvelopeUtil.openEnvelopedFile(encryptedFilePath, plainTextFilePath, privateKey, recipientCert, session);
    }

    public static final byte[] openEvelopedMessage(byte[] cmsEnvelopedData, PrivateKey privateKey, X509Cert recipientCert, Session session) throws Exception {
        byte[] bEnvelop = ASN1Parser.isBase64Encode(cmsEnvelopedData) ? Base64.decode(cmsEnvelopedData) : cmsEnvelopedData;
        CMSEnvelopedData cmsEnData = new CMSEnvelopedData(bEnvelop);
        ContentInfo info = cmsEnData.toASN1Structure();
        EnvelopedData enData = EnvelopedData.getInstance(info.getContent());
        ASN1Set receivers = enData.getRecipientInfos();
        byte[] symmetricKey = SM2EnvelopeUtil.checkRecipientsAndSymmetricKey(privateKey, recipientCert, receivers, session);
        EncryptedContentInfo data = enData.getEncryptedContentInfo();
        ASN1OctetString os = data.getEncryptedContent();
        AlgorithmIdentifier symmetricAlgId = data.getContentEncryptionAlgorithm();
        Mechanism_Inside mechanism = SM2EnvelopeUtil.buildMechanism(symmetricAlgId);
        byte[] sourceData = SM2EnvelopeUtil.SM4Decrypt(symmetricKey, os.getOctets(), mechanism);
        return sourceData;
    }

    public static final byte[] openEvelopedMessage(byte[] cmsEnvelopedData, PrivateKey privateKey, X509Cert recipientCert) throws Exception {
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        return SM2EnvelopeUtil.openEvelopedMessage(cmsEnvelopedData, privateKey, recipientCert, session);
    }

    private static byte[] checkRecipientsAndSymmetricKey(PrivateKey privateKey, X509Cert recipientCert, ASN1Set receivers, Session session) throws Exception {
        if (receivers == null) {
            throw new Exception("the receiver is null!!!");
        }
        SubjectKeyIdentifier acceptedRecipientSubjectKeyID = recipientCert.getSubjectKeyIdentifier();
        X500Name acceptedRecipientIssuer = recipientCert.getIssuerX500Name();
        BigInteger acceptedRecipientSN = recipientCert.getSerialNumber();
        ASN1OctetString encryptKey = null;
        AlgorithmIdentifier algId = null;
        RecipientInfo recip = null;
        KeyTransRecipientInfo inf = null;
        int len = receivers.size();
        for (int i = 0; i < len; ++i) {
            recip = RecipientInfo.getInstance(receivers.getObjectAt(i));
            if (!(recip.getInfo() instanceof KeyTransRecipientInfo) || !SM2EnvelopeUtil.hasRecipent(inf = KeyTransRecipientInfo.getInstance(recip.getInfo()), acceptedRecipientSubjectKeyID, acceptedRecipientIssuer, acceptedRecipientSN)) continue;
            encryptKey = inf.getEncryptedKey();
            algId = inf.getKeyEncryptionAlgorithm();
            break;
        }
        if (encryptKey == null || algId == null) {
            throw new Exception("can not find the receiver!!!");
        }
        byte[] symmetricKey = SM2EnvelopeUtil.SM2DecryptSymmetricKey(privateKey, encryptKey.getOctets(), session);
        if (symmetricKey == null) {
            throw new SecurityException("decrypt symmetricKey failure");
        }
        return symmetricKey;
    }

    private static boolean hasRecipent(KeyTransRecipientInfo keyTransRecipientInfo, SubjectKeyIdentifier acceptedRecipientSubjectKeyID, X500Name acceptedRecipientIssuer, BigInteger acceptedRecipientSN) {
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier == null) {
            return false;
        }
        IssuerAndSerialNumber issu = new IssuerAndSerialNumber(acceptedRecipientIssuer, acceptedRecipientSN);
        if (!recipientIdentifier.getId().toASN1Primitive().asn1Equals(issu.toASN1Primitive())) {
            return false;
        }
        if (acceptedRecipientSubjectKeyID != null && recipientIdentifier.getId() != null) {
            DEROctetString oct = new DEROctetString(acceptedRecipientSubjectKeyID.getKeyIdentifier());
            return recipientIdentifier.getId().toASN1Primitive().asn1Equals(oct);
        }
        return false;
    }

    private static Mechanism_Inside buildMechanism(AlgorithmIdentifier symmetricAlgId) throws PKIException {
        Mechanism_Inside mechanism = null;
        String encryptionAlgStr = (String)PKCS7EnvelopedData.OID_MECH.get(symmetricAlgId.getAlgorithm());
        if (encryptionAlgStr.indexOf("CBC") != -1) {
            DEROctetString doct = (DEROctetString)symmetricAlgId.getParameters();
            CBCParam cbcParam = new CBCParam(doct.getOctets());
            mechanism = encryptionAlgStr.equals("SM4/CBC/PKCS7Padding") ? new Mechanism_Inside("SM4/CBC/PKCS7Padding", cbcParam) : new Mechanism_Inside("SM4/CBC/PKCS7Padding", cbcParam);
        } else if (encryptionAlgStr.indexOf("ECB") != -1) {
            mechanism = new Mechanism_Inside("SM4/ECB/PKCS7Padding");
        } else {
            throw new PKIException("850629", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301Algorithm is:" + encryptionAlgStr);
        }
        return mechanism;
    }

    private static RecipientInfo buildRecipientInfo(X509Cert cert, byte[] symmetricKey, Session session, int recipientPolicy) throws Exception {
        if (cert == null) {
            throw new Exception("buildRecipientInfo failure without RecipientCert");
        }
        byte[] encryptedKey = SM2EnvelopeUtil.SM2EncryptSymmetricKey(cert.getPublicKey(), symmetricKey, session);
        DEROctetString encKey = new DEROctetString(encryptedKey);
        RecipientIdentifier recipientIdentifier = cert.generateRecipientIdentifier(recipientPolicy);
        AlgorithmIdentifier keyEncAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.SM2_pubKey_encrypt, (ASN1Encodable)new DERNull());
        KeyTransRecipientInfo ktr = new KeyTransRecipientInfo(recipientIdentifier, keyEncAlg, encKey);
        return new RecipientInfo(ktr);
    }

    private static SymmetricAlgorithm.SymmetricAlgorithmParameters buildSymmetricAlgorithmParameters(String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicy) throws Exception {
        if (receiverCerts == null || receiverCerts.length == 0 || receiverCerts[0] == null) {
            throw new Exception("buildSymmetricAlgorithmParameters failure without ReceiverCerts");
        }
        SymmetricAlgorithm.SymmetricAlgorithmParameters params = SymmetricAlgorithm.buildSM2SymmetricAlgorithmParameters(symmetricAlgorithm);
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        for (int i = 0; i < receiverCerts.length; ++i) {
            recipientInfos.add(SM2EnvelopeUtil.buildRecipientInfo(receiverCerts[i], params.symmetricKey, session, recipientPolicy));
        }
        params.recipientInfos = recipientInfos;
        return params;
    }

    private static final byte[] SM4Encrypt(byte[] key, byte[] sourceData, Mechanism_Inside contentEncryptionAlg) throws Exception {
        return SM2SymmetricCryptoUtil.cryptoUtil(true, key, sourceData, contentEncryptionAlg);
    }

    private static final byte[] SM4Decrypt(byte[] symmetricKey, byte[] octets, Mechanism_Inside mechanism) throws Exception {
        return SM2SymmetricCryptoUtil.cryptoUtil(false, symmetricKey, octets, mechanism);
    }

    private static final byte[] SM2EncryptSymmetricKey(PublicKey publicKey, byte[] symmetricKey, Session session) throws Exception {
        Mechanism_Inside contentEncryptionAlg = new Mechanism_Inside("SM2");
        byte[] encryptedSymmetricKey = session.encrypt(contentEncryptionAlg, publicKey, symmetricKey);
        return encryptedSymmetricKey;
    }

    private static final byte[] SM2DecryptSymmetricKey(PrivateKey privateKey, byte[] encryptedSymmetricKey, Session session) throws Exception {
        Mechanism_Inside contentEncryptionAlg = new Mechanism_Inside("SM2");
        byte[] decryptedSymmetricKey = session.decrypt(contentEncryptionAlg, privateKey, encryptedSymmetricKey);
        return decryptedSymmetricKey;
    }
}

