/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.sm2rsa.common;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cmbc.cfca.internal.tool.ASN1Parser;
import cmbc.cfca.internal.tool.BigIntegerUtil;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cmbc.cfca.org.bouncycastle.asn1.ASN1InputStream;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Integer;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.ASN1OctetString;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Sequence;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Set;
import cmbc.cfca.org.bouncycastle.asn1.BERSet;
import cmbc.cfca.org.bouncycastle.asn1.DERNull;
import cmbc.cfca.org.bouncycastle.asn1.DERObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.DEROctetString;
import cmbc.cfca.org.bouncycastle.asn1.DERSet;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.ContentInfo;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.SignedData;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.SignerInfo;
import cmbc.cfca.org.bouncycastle.asn1.x500.X500Name;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.x509.Certificate;
import cmbc.cfca.sadk32.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cmbc.cfca.sm2.signature.SM2SignerInfo;
import cmbc.cfca.sm2.signature.SM2SignerInfo2;
import cmbc.cfca.sm2.signature.SM2SignerInfox;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.system.Debugger;
import cmbc.cfca.util.Base64;
import cmbc.cfca.util.cipher.lib.BCSoftLib;
import cmbc.cfca.util.cipher.lib.Session;
import cmbc.cfca.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Enumeration;

public class PKCS7SignedData {
    static final Logger logger = LoggerFactory.getLogger(PKCS7SignedData.class);
    private Session session = null;
    private SignedData signedData = null;
    static final String pkcs_7 = "1.2.840.113549.1.7";
    public static final String DATA = new DERObjectIdentifier("1.2.840.113549.1.7.1").getId();
    public static final String SIGNED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.2").getId();
    public static final String ENVELOPED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.3").getId();
    public static final String SIGNED_ENVELOPED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.4").getId();
    public static final String DIGESTED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.5").getId();
    public static final String ENCRYPTED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.6").getId();

    public PKCS7SignedData(Session session) {
        this.session = session == null ? new BCSoftLib() : session;
    }

    public final byte[] packageSM2SignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] signature, X509Cert[] certs) throws Exception {
        StringBuffer buffer;
        if (logger.isDebugEnabled()) {
            buffer = new StringBuffer();
            buffer.append("packageSM2SignedData>>>>>>Running");
            buffer.append("\n ifAttach: " + ifAttach);
            buffer.append("\n contentType: ");
            buffer.append(Debugger.dump(contentType));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n encryptedData(signature): ");
            buffer.append(Debugger.dump(signature));
            buffer.append("\n certs: ");
            buffer.append(Debugger.dump(certs));
            logger.debug(buffer.toString());
        }
        if (certs == null || certs.length == 0) {
            if (logger.isErrorEnabled()) {
                buffer = new StringBuffer();
                buffer.append("packageSM2SignedData<<<<<<Failure: Required certs");
                buffer.append("\n certs: ");
                buffer.append(Debugger.dump(certs));
                logger.error(buffer.toString());
            }
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        if (signature == null || signature.length != 64) {
            if (logger.isErrorEnabled()) {
                buffer = new StringBuffer();
                buffer.append("packageSM2SignedData<<<<<<Failure: Required signature MUST BE 64Bytes");
                buffer.append("\n signature: ");
                buffer.append(Debugger.dump(signature));
                logger.error(buffer.toString());
            }
            throw new PKIException("signature of SM2 MUST BE NOT NULL AND LENGTH MUST BE 64");
        }
        try {
            ASN1SM2Signature derSignature = new ASN1SM2Signature(signature);
            ASN1Integer derR = derSignature.getR();
            ASN1Integer derS = derSignature.getS();
            BigInteger sn = certs[0].getSerialNumber();
            X500Name issuer = certs[0].getIssuerX500Name();
            IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
            AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.SM2_sign, (ASN1Encodable)new DERNull());
            AlgorithmIdentifier digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm3, (ASN1Encodable)new DERNull());
            SM2SignerInfox signerInfo = null;
            if (this.isNewFormat()) {
                logger.debug("packageSM2SignedData::::::isNewFormat=True");
                signerInfo = new SM2SignerInfo2(new ASN1Integer(1), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null);
            } else {
                logger.debug("packageSM2SignedData::::::isNewFormat=False");
                signerInfo = new SM2SignerInfo(new ASN1Integer(1), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null);
            }
            ContentInfo contentInfo = null;
            if (ifAttach) {
                logger.debug("packageSM2SignedData::::::ifAttach" + ifAttach);
                DEROctetString derSourceData = new DEROctetString(sourceData);
                if (contentType == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("packageSM2SignedData::::::contentType=SM2(" + PKCSObjectIdentifiers.sm2Data.getId() + ")");
                    }
                    contentInfo = new ContentInfo(PKCSObjectIdentifiers.sm2Data, derSourceData);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("packageSM2SignedData::::::contentType=" + contentType);
                    }
                    contentInfo = new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
                }
            } else {
                logger.debug("packageSM2SignedData::::::ifAttach" + ifAttach);
                if (contentType == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("packageSM2SignedData::::::contentType=SM2(" + PKCSObjectIdentifiers.sm2Data.getId() + ")");
                    }
                    contentInfo = new ContentInfo(PKCSObjectIdentifiers.sm2Data, null);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("packageSM2SignedData::::::contentType=" + contentType);
                    }
                    contentInfo = new ContentInfo(new ASN1ObjectIdentifier(contentType), null);
                }
            }
            ASN1EncodableVector derV = new ASN1EncodableVector();
            derV.add(digestAlgIdentifier);
            DERSet digestAlgorithmSets = new DERSet(derV);
            derV = new ASN1EncodableVector();
            derV.add(signerInfo);
            DERSet signerInfos = new DERSet(derV);
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i < certs.length; ++i) {
                Certificate certStruc = certs[i].getCertStructure();
                v.add(certStruc);
            }
            BERSet setCert = new BERSet(v);
            SignedData signedData = new SignedData(new ASN1Integer(1), digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
            ContentInfo contentInfoTemp = new ContentInfo(PKCSObjectIdentifiers.sm2SignedData, signedData);
            byte[] returnBytes = ASN1Parser.writeDERObj2Bytes(contentInfoTemp);
            logger.debug("packageSM2SignedData<<<<<<Finished.");
            return returnBytes;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer2 = new StringBuffer();
                buffer2.append("packageSM2SignedData<<<<<<Running");
                buffer2.append("\n ifAttach: " + ifAttach);
                buffer2.append("\n contentType: ");
                buffer2.append(Debugger.dump(contentType));
                buffer2.append("\n sourceData: ");
                buffer2.append(Debugger.dump(sourceData));
                buffer2.append("\n encryptedData(signature): ");
                buffer2.append(Debugger.dump(signature));
                buffer2.append("\n certs: ");
                buffer2.append(Debugger.dump(certs));
                logger.error(buffer2.toString(), e);
            }
            throw e;
        }
    }

    public byte[] packageSignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] encryptData, Mechanism digestAlgorithm, X509Cert[] certs) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("packageSignedData::>>>>>>Running");
            buffer.append("\n ifAttach: " + ifAttach);
            buffer.append("\n contentType: ");
            buffer.append(Debugger.dump(contentType));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n encryptData: ");
            buffer.append(Debugger.dump(encryptData));
            buffer.append("\n digestAlgorithm: ");
            buffer.append(Debugger.dump(digestAlgorithm));
            buffer.append("\n certs: ");
            buffer.append(Debugger.dump(certs));
            logger.debug(buffer.toString());
        }
        try {
            if (certs == null || certs.length == 0 || certs[0] == null) {
                throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
            }
            if (certs[0].isSM2Cert()) {
                logger.debug("packageSignedData::::::packageSM2SignedData");
                return this.packageSM2SignedData(ifAttach, contentType, sourceData, encryptData, certs);
            }
            if (certs[0].isRSACert()) {
                logger.debug("packageSignedData::::::packageRSASignedData");
                return this.packageRSASignedData(ifAttach, contentType, sourceData, encryptData, digestAlgorithm, certs);
            }
            throw new PKIException("Invalid X509Cert");
        }
        catch (Exception e) {
            logger.error("packageSignedData<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDer(byte[] data) throws PKIException {
        logger.debug("loadDer>>>>>>Running");
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            this.load(bis);
        }
        finally {
            logger.debug("loadDer<<<<<<Finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBase64(byte[] data) throws PKIException {
        logger.debug("loadBase64>>>>>>Running");
        try {
            byte[] encoding = ASN1Parser.isBase64Encode(data) ? Base64.decode(data) : data;
            logger.debug("loadBase64::::::Decoding Finished");
            this.load(new ByteArrayInputStream(encoding));
        }
        finally {
            logger.debug("loadBase64<<<<<<Finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAsn1(byte[] asn1Encoding) throws PKIException {
        logger.debug("loadAsn1>>>>>>Running");
        try {
            this.load(new ByteArrayInputStream(asn1Encoding));
        }
        finally {
            logger.debug("loadAsn1<<<<<<Finished");
        }
    }

    private void load(InputStream ins) throws PKIException {
        logger.debug("load::>>>>>>Running");
        ASN1InputStream ais = null;
        try {
            ais = new ASN1InputStream(ins);
            ASN1Sequence seq = (ASN1Sequence)ais.readObject();
            ContentInfo contentInfo = ContentInfo.getInstance(seq);
            this.signedData = SignedData.getInstance(contentInfo.getContent());
            logger.debug("load::<<<<<<Finished");
        }
        catch (Exception e) {
            logger.error("load::<<<<<<Failure", e);
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    logger.error("load::<<<<<<Failure", e);
                }
            }
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (IOException e) {
                    logger.error("load::<<<<<<Failure", e);
                }
            }
        }
    }

    public boolean verifyP7SignedDataAttach() throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifyP7SignedDataAttach>>>>>>Running");
            logger.debug(buffer.toString());
        }
        byte[] sourceData = this.getSourceData();
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            logger.debug("verifyP7SignedDataAttach::::::verifySM2SignerInfo");
            return this.verifySM2SignerInfo((byte[])sourceData.clone(), null, aset, null);
        }
        logger.debug("verifyP7SignedDataAttach::::::verifySignerInfo");
        return this.verifySignerInfo((byte[])sourceData.clone(), aset, null);
    }

    public byte[] getSourceData() throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getSourceData>>>>>>Running");
            logger.debug(buffer.toString());
        }
        try {
            ContentInfo contentInfo = this.signedData.getContentInfo();
            byte[] sourceData = null;
            if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.sm2Data)) {
                if (contentInfo.getContent() == null) {
                    throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", new Exception("no sourceData to be verify."));
                }
                sourceData = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            } else {
                sourceData = ASN1Parser.writeDERObj2Bytes(contentInfo.getContent().toASN1Primitive());
            }
            byte[] returnBytes = (byte[])sourceData.clone();
            logger.debug("getSourceData<<<<<<Finished");
            return returnBytes;
        }
        catch (PKIException e) {
            logger.debug("getSourceData<<<<<<Failure", e);
            throw e;
        }
    }

    private boolean verifySignerInfoByFile(String sourceFilePath, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        logger.debug("verifySignerInfoByFile::>>>>>>Running");
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifySignerInfoByFile::<<<<<<Failure: DO NOT FIND SignerCert");
                        buffer.append("\n issuerAndSN: ");
                        buffer.append(Debugger.dump(issuerAndSN));
                        buffer.append("\n certs: ");
                        buffer.append(Debugger.dump(certs));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifySignerInfoByFile::<<<<<<Failure: DO NOT SUPPORT DigestEncryptionAlgorithm");
                        buffer.append("\n encryptionId: ");
                        buffer.append(Debugger.dump(encryptionId));
                        buffer.append("\n Valid DigestEncryptionAlgorithm : ");
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.rsaEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.md5WithRSAEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.sha1WithRSAEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.sha256WithRSAEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.sha512WithRSAEncryption));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                Mechanism signM = null;
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("MD5withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = new Mechanism("SHA1withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                    signM = new Mechanism("SHA256withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                    signM = new Mechanism("SHA512withRSA");
                } else {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySignerInfoByFile::::::::verifySign Running signature=" + Debugger.dump(signature));
                }
                boolean verifyResult = this.session.verifySign(signM, pubKey, sourceFilePath, signature);
                logger.debug("verifySignerInfoByFile::::::::verifySign Finished");
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySignerInfoByFile::<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            logger.debug("verifySignerInfoByFile::<<<<<<Finished: False");
            return false;
        }
        catch (Exception e) {
            logger.error("verifySignerInfoByFile::<<<<<<Failure", e);
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    private boolean verifySignerInfo(byte[] content, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        logger.debug("verifySignerInfo::>>>>>>Running");
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                boolean verifyResult;
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifySignerInfo::<<<<<<Failure: DO NOT FIND SignerCert");
                        buffer.append("\n issuerAndSN: ");
                        buffer.append(Debugger.dump(issuerAndSN));
                        buffer.append("\n certs: ");
                        buffer.append(Debugger.dump(certs));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifySignerInfo::<<<<<<Failure: DO NOT SUPPORT DigestEncryptionAlgorithm");
                        buffer.append("\n encryptionId: ");
                        buffer.append(Debugger.dump(encryptionId));
                        buffer.append("\n Valid DigestEncryptionAlgorithm : ");
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.rsaEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.md5WithRSAEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.sha1WithRSAEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.sha256WithRSAEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.sha512WithRSAEncryption));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                Mechanism signM = null;
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("MD5withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = new Mechanism("SHA1withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                    signM = new Mechanism("SHA256withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                    signM = new Mechanism("SHA512withRSA");
                } else {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                if (authAttributes != null) {
                    byte[] bAuthAttries = ASN1Parser.writeDERObj2Bytes(authAttributes);
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifySignerInfo::::::::verifySign [With AuthenticatedAttributes] Running signature=" + Debugger.dump(signature));
                    }
                    verifyResult = this.session.verifySign(signM, pubKey, bAuthAttries, signature);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifySignerInfo::::::::verifySign [None AuthenticatedAttributes] Running signature=" + Debugger.dump(signature));
                    }
                    verifyResult = this.session.verifySign(signM, pubKey, content, signature);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySignerInfo::<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            logger.debug("verifySignerInfo::<<<<<<Finished: False");
            return false;
        }
        catch (Exception e) {
            logger.error("verifySignerInfo::<<<<<<Failure", e);
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    private boolean verifySM2SignerInfoByFile(String sourceFilePath, boolean ifZValue, byte[] userId, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        logger.debug("verifySM2SignerInfoByFile::>>>>>>Running");
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            SM2SignerInfox signerInfo = null;
            if (signerEnumer.hasMoreElements()) {
                if (this.isNewFormat()) {
                    logger.debug("verifySM2SignerInfoByFile::::::isNewFormat=True");
                    signerInfo = SM2SignerInfo2.getInstance(signerEnumer.nextElement());
                } else {
                    logger.debug("verifySM2SignerInfoByFile::::::isNewFormat=False");
                    signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
                }
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifySM2SignerInfoByFile<<<<<<Failure: DO NOT FIND SignerCert");
                        buffer.append("\n issuerAndSN: ");
                        buffer.append(Debugger.dump(issuerAndSN));
                        buffer.append("\n certs: ");
                        buffer.append(Debugger.dump(certs));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySM2SignerInfoByFile::::::::verifySign Running signature=" + Debugger.dump(signature));
                }
                boolean verifyResult = this.session.verifySign(new Mechanism("SM3withSM2"), pubKey, sourceFilePath, signature);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySM2SignerInfoByFile::<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            logger.debug("verifySM2SignerInfoByFile::<<<<<<Finished: False");
            return false;
        }
        catch (Exception e) {
            logger.error("verifySM2SignerInfoByFile::<<<<<<Failure", e);
            throw new PKIException("8506204", "\u9a8c\u8bc1SM2\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    private boolean verifySM2SignerInfo(byte[] content, byte[] userId, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        logger.debug("verifySM2SignerInfo::>>>>>>Running");
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            SM2SignerInfox signerInfo = null;
            if (signerEnumer.hasMoreElements()) {
                boolean verifyResult;
                ASN1Set authAttributes;
                byte[] signature;
                if (this.isNewFormat()) {
                    logger.debug("verifySM2SignerInfo::::::isNewFormat=True");
                    signerInfo = SM2SignerInfo2.getInstance(signerEnumer.nextElement());
                } else {
                    logger.debug("verifySM2SignerInfo::::::isNewFormat=False");
                    signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
                }
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifySM2SignerInfo<<<<<<Failure: DO NOT FIND SignerCert");
                        buffer.append("\n issuerAndSN: ");
                        buffer.append(Debugger.dump(issuerAndSN));
                        buffer.append("\n certs: ");
                        buffer.append(Debugger.dump(certs));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signatureAsBytes = signerInfo.getSignatureAsBytes();
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySM2SignerInfo::::::::signatureAsBytes" + Debugger.dump(signatureAsBytes));
                }
                if (128 != signatureAsBytes.length) {
                    byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                    byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                    signature = new byte[64];
                    System.arraycopy(r, 0, signature, 0, 32);
                    System.arraycopy(s, 0, signature, 32, 32);
                } else {
                    signature = (byte[])signatureAsBytes.clone();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySM2SignerInfo::::::::signature" + Debugger.dump(signature));
                }
                if ((authAttributes = signerInfo.getAuthenticatedAttributes()) != null) {
                    byte[] bAuthAttries = ASN1Parser.writeDERObj2Bytes(authAttributes);
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifySM2SignerInfo::::::::verifySign [With AuthenticatedAttributes] Running signature=" + Debugger.dump(signature));
                    }
                    verifyResult = this.session.verifySign(new Mechanism("SM3withSM2"), pubKey, bAuthAttries, signature);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifySM2SignerInfo::::::::verifySign [None AuthenticatedAttributes] Running signature=" + Debugger.dump(signature));
                    }
                    verifyResult = this.session.verifySign(new Mechanism("SM3withSM2"), pubKey, content, signature);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySM2SignerInfo::<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            logger.debug("verifySM2SignerInfo::<<<<<<Finished: False");
            return false;
        }
        catch (Exception e) {
            logger.error("verifySM2SignerInfo::<<<<<<Failure", e);
            throw new PKIException("8506204", "\u9a8c\u8bc1SM2\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    private boolean isSM2Cert() {
        if (logger.isDebugEnabled()) {
            logger.debug("isSM2Cert::>>>>>>Running");
        }
        ASN1Set certSet = this.signedData.getCertificates();
        Certificate certStru = Certificate.getInstance(certSet.getObjectAt(0));
        boolean isSM2Cert = new X509Cert(certStru).isSM2Cert();
        if (logger.isDebugEnabled()) {
            logger.debug("isSM2Cert::<<<<<<Finished,isSM2Cert=" + isSM2Cert);
        }
        return isSM2Cert;
    }

    private X509Cert[] getSignerCerts() throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSignerCerts::>>>>>>Running");
        }
        ASN1Set certSet = this.signedData.getCertificates();
        X509Cert[] signerCerts = new X509Cert[certSet.size()];
        for (int i = 0; i < certSet.size(); ++i) {
            Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
            signerCerts[i] = new X509Cert(certStru);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getSignerCerts::<<<<<<Finished");
        }
        return signerCerts;
    }

    public X509Cert getSignerX509Cert() throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSignerX509Cert::>>>>>>Running");
        }
        X509Cert signerCerts = null;
        ASN1Set certSet = this.signedData.getCertificates();
        Certificate certStru = Certificate.getInstance(certSet.getObjectAt(0));
        signerCerts = new X509Cert(certStru);
        if (logger.isDebugEnabled()) {
            logger.debug("getSignerX509Cert::<<<<<<Finished");
        }
        return signerCerts;
    }

    private X509Cert getSignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSignerCert::>>>>>>Running");
        }
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        for (int i = 0; i < certs.length; ++i) {
            X500Name tmpIssuer = certs[i].getIssuerX500Name();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (!tmpIssuer.toString().equals(issuer) || tmpSN.compareTo(sn) != 0) continue;
            logger.debug("getSignerCert::<<<<<<Finished,FindSignerCert");
            return certs[i];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getSignerCert::<<<<<<Finished,NoneSignerCert");
        }
        return null;
    }

    private X509Cert getSM2SignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSM2SignerCert::>>>>>>Running");
        }
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        for (int i = 0; i < certs.length; ++i) {
            X500Name tmpIssuer = certs[i].getIssuerX500Name();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (!tmpIssuer.toString().equals(issuer) || tmpSN.compareTo(sn) != 0) continue;
            logger.debug("getSM2SignerCert::<<<<<<Finished,FindSignerCert");
            return certs[i];
        }
        logger.debug("getSM2SignerCert::<<<<<<Finished,NoneSignerCert");
        return null;
    }

    public boolean verifyP7SignedData(String sourceDataFilePath) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifyP7SignedData>>>>>>Running");
            buffer.append("\n sourceDataFilePath: " + sourceDataFilePath);
            logger.debug(buffer.toString());
        }
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            logger.debug("verifyP7SignedData::::::verifySM2SignerInfoByFile");
            return this.verifySM2SignerInfoByFile(sourceDataFilePath, true, null, aset, null);
        }
        logger.debug("verifyP7SignedData::::::verifyP7SignedData");
        return this.verifySignerInfoByFile(sourceDataFilePath, aset, null);
    }

    public boolean verifyP7SignedData(byte[] sourceData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifyP7SignedData>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            logger.debug("verifyP7SignedData::::::verifySM2SignerInfo");
            return this.verifySM2SignerInfo(sourceData, null, aset, null);
        }
        logger.debug("verifyP7SignedData::::::verifySignerInfo");
        return this.verifySignerInfo(sourceData, aset, null);
    }

    private byte[] getSM2Signature() throws PKIException {
        ASN1Set signerInfos;
        Enumeration signerEnumer;
        if (logger.isDebugEnabled()) {
            logger.debug("getSM2Signature::>>>>>>Running");
        }
        if ((signerEnumer = (signerInfos = this.signedData.getSignerInfos()).getObjects()).hasMoreElements()) {
            SM2SignerInfox signerInfo = null;
            if (this.isNewFormat()) {
                logger.debug("getSM2Signature::::::isNewFormat=True");
                signerInfo = SM2SignerInfo2.getInstance(signerEnumer.nextElement());
            } else {
                logger.debug("getSM2Signature::::::isNewFormat=False");
                signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
            }
            byte[] signatureAsBytes = signerInfo.getSignatureAsBytes();
            if (logger.isDebugEnabled()) {
                logger.debug("getSM2Signature::::::::signatureAsBytes" + Debugger.dump(signatureAsBytes));
            }
            byte[] signature = null;
            if (signatureAsBytes != null && signatureAsBytes.length == 128) {
                signature = signatureAsBytes;
            } else {
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getSM2Signature::<<<<<<signature" + Debugger.dump(signature));
            }
            return signature;
        }
        logger.error("getSM2Signature::<<<<<<Failure: can not get SM2SignerInfo object!!!");
        throw new PKIException("can not get SM2SignerInfo object!!!");
    }

    public byte[] getSignature() throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSignature>>>>>>Running");
        }
        if (this.isSM2Cert()) {
            logger.debug("getSignature::::::getSM2Signature");
            return this.getSM2Signature();
        }
        logger.debug("getSignature::::::Enumeration");
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        if (signerEnumer.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            return signerInfo.getEncryptedDigest().getOctets();
        }
        logger.error("getSignature::<<<<<<Failure: can not get SignerInfo object!!!");
        throw new PKIException("can not get SignerInfo object!!!");
    }

    public String getDigestAlgorithm() throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getDigestAlgorithm>>>>>>Running");
        }
        if (this.isSM2Cert()) {
            logger.debug("getDigestAlgorithm::::::SM3");
            return "SM3";
        }
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        String signM = null;
        if (signerEnumer.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
            if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                signM = "MD5";
            } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                signM = "SHA1";
            } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                signM = "SHA256";
            } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                signM = "SHA512";
            } else {
                throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getDigestAlgorithm::::::signM=" + signM);
            }
            return signM;
        }
        logger.error("getDigestAlgorithm::<<<<<<Failure: can not get SignerInfo object!!!");
        throw new PKIException("can not get SignerInfo object!!!");
    }

    public boolean verifySM2SignedData(String sourceFilePath, boolean ifZValue, byte[] userId) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifySM2SignedData>>>>>>Running");
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n ifZValue: " + ifZValue);
            buffer.append("\n userId: ");
            buffer.append(Debugger.dump(userId));
            logger.debug(buffer.toString());
        }
        ASN1Set aset = this.signedData.getSignerInfos();
        if (ifZValue) {
            if (userId != null) {
                logger.debug("verifySM2SignedData::::::verifySM2SignerInfoByFile,ifZValue=True");
                return this.verifySM2SignerInfoByFile(sourceFilePath, true, (byte[])userId.clone(), aset, null);
            }
            logger.debug("verifySM2SignedData::::::verifySM2SignerInfoByFile,ifZValue=True");
            return this.verifySM2SignerInfoByFile(sourceFilePath, true, null, aset, null);
        }
        logger.debug("verifySM2SignedData::::::verifySM2SignerInfoByFile,ifZValue=False");
        return this.verifySM2SignerInfoByFile(sourceFilePath, false, null, aset, null);
    }

    public boolean verifySM2SignedData(byte[] sourceData, boolean ifZValue, byte[] userId) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifySM2SignedData::>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n ifZValue: " + ifZValue);
            buffer.append("\n userId: ");
            buffer.append(Debugger.dump(userId));
            logger.debug(buffer.toString());
        }
        ASN1Set aset = this.signedData.getSignerInfos();
        if (ifZValue) {
            if (userId != null) {
                logger.debug("verifySM2SignedData::::::verifySM2SignerInfo,ifZValue=True");
                return this.verifySM2SignerInfo((byte[])sourceData.clone(), (byte[])userId.clone(), aset, null);
            }
            logger.debug("verifySM2SignedData::::::verifySM2SignerInfo,ifZValue=True");
            return this.verifySM2SignerInfo((byte[])sourceData.clone(), null, aset, null);
        }
        logger.debug("verifySM2SignedData::::::verifySM2SignerInfo,ifZValue=False");
        return this.verifySM2SignerInfo((byte[])sourceData.clone(), null, aset, null);
    }

    public byte[] packageRSASignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] encryptData, Mechanism mechanism, X509Cert[] certs) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("packageRSASignedData::>>>>>>Running");
            buffer.append("\n ifAttach: " + ifAttach);
            buffer.append("\n contentType: ");
            buffer.append(Debugger.dump(contentType));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n encryptData: ");
            buffer.append(Debugger.dump(encryptData));
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n certs: ");
            buffer.append(Debugger.dump(certs));
            logger.debug(buffer.toString());
        }
        if (certs == null) {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        DEROctetString encryptedData = new DEROctetString(encryptData);
        BigInteger sn = certs[0].getSerialNumber();
        X500Name issuer = certs[0].getIssuerX500Name();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
        AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)new DERNull());
        AlgorithmIdentifier digestAlgIdentifier = null;
        String digestAlgorithm = mechanism.getMechanismType();
        if (digestAlgorithm.equals("MD5") || digestAlgorithm.equals("MD5withRSAEncryption")) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, (ASN1Encodable)new DERNull());
        } else if (digestAlgorithm.equals("SHA1") || digestAlgorithm.equals("SHA1withRSAEncryption")) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, (ASN1Encodable)new DERNull());
        } else if (digestAlgorithm.equals("SHA256") || digestAlgorithm.equals("SHA256withRSAEncryption")) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256, (ASN1Encodable)new DERNull());
        } else if (digestAlgorithm.equals("SHA512") || digestAlgorithm.equals("SHA512withRSA")) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512, (ASN1Encodable)new DERNull());
        }
        SignerInfo signerInfo = new SignerInfo(new ASN1Integer(1), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, encryptedData, null);
        ContentInfo contentInfo = null;
        if (ifAttach) {
            DEROctetString derSourceData = new DEROctetString(sourceData);
            if (contentType == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("packageRSASignedData::::::Attach contentType=RFC(" + PKCSObjectIdentifiers.data.getId() + ")");
                }
                contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, derSourceData);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("packageRSASignedData::::::Attach contentType=" + contentType);
                }
                contentInfo = new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
            }
        } else if (contentType == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("packageRSASignedData::::::Detach contentType=RFC(" + PKCSObjectIdentifiers.data.getId() + ")");
            }
            contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, null);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("packageRSASignedData::::::Detach contentType=" + contentType);
            }
            contentInfo = new ContentInfo(new ASN1ObjectIdentifier(contentType), null);
        }
        ASN1EncodableVector derV = new ASN1EncodableVector();
        derV.add(digestAlgIdentifier);
        BERSet digestAlgorithmSets = new BERSet(derV);
        derV = new ASN1EncodableVector();
        derV.add(signerInfo);
        DERSet signerInfos = new DERSet(derV);
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < certs.length; ++i) {
            Certificate certStruc = certs[i].getCertStructure();
            v.add(certStruc);
        }
        BERSet setCert = new BERSet(v);
        SignedData signedData = new SignedData(new ASN1Integer(1), digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
        ContentInfo contentInfoTemp = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
        return ASN1Parser.writeDERObj2Bytes(contentInfoTemp);
    }

    public boolean verifyP7SignedDataByHash(byte[] digest) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifyP7SignedDataByHash>>>>>>Running");
            buffer.append("\n digest: ");
            buffer.append(Debugger.dump(digest));
            logger.debug(buffer.toString());
        }
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            logger.debug("verifyP7SignedDataByHash::::::verifySM2SignerInfoByHash");
            return this.verifySM2SignerInfoByHash(digest, aset, null);
        }
        logger.debug("verifyP7SignedDataByHash::::::verifySignerInfoByHash");
        return this.verifySignerInfoByHash(digest, aset, null);
    }

    private boolean verifySignerInfoByHash(byte[] digest, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifySignerInfoByHash::>>>>>>Running");
            buffer.append("\n digest: ");
            buffer.append(Debugger.dump(digest));
            buffer.append("\n certs: ");
            buffer.append(Debugger.dump(certs));
            logger.debug(buffer.toString());
        }
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifySignerInfoByHash::<<<<<<Failure: DO NOT FIND SignerCert");
                        buffer.append("\n issuerAndSN: ");
                        buffer.append(Debugger.dump(issuerAndSN));
                        buffer.append("\n certs: ");
                        buffer.append(Debugger.dump(certs));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifySignerInfoByHash::<<<<<<Failure: DO NOT SUPPORT DigestEncryptionAlgorithm");
                        buffer.append("\n encryptionId: ");
                        buffer.append(Debugger.dump(encryptionId));
                        buffer.append("\n Valid DigestEncryptionAlgorithm : ");
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.rsaEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.md5WithRSAEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.sha1WithRSAEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.sha256WithRSAEncryption));
                        buffer.append("\n ").append(Debugger.dump(PKCSObjectIdentifiers.sha512WithRSAEncryption));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                Mechanism signM = null;
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("MD5withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = new Mechanism("SHA1withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                    signM = new Mechanism("SHA256withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                    signM = new Mechanism("SHA512withRSA");
                } else {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySignerInfoByHash::::::::verifySign Running signature=" + Debugger.dump(signature));
                }
                boolean verifyResult = this.session.verifyByHash(signM, pubKey, digest, signature);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySignerInfoByHash::<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            logger.debug("verifySignerInfoByHash::<<<<<<Finished: False");
            return false;
        }
        catch (Exception e) {
            logger.error("verifySignerInfoByHash::<<<<<<Failure", e);
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    private boolean verifySM2SignerInfoByHash(byte[] digest, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifySM2SignerInfoByHash::>>>>>>Running");
            buffer.append("\n digest: ");
            buffer.append(Debugger.dump(digest));
            buffer.append("\n certs: ");
            buffer.append(Debugger.dump(certs));
            logger.debug(buffer.toString());
        }
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            SM2SignerInfox signerInfo = null;
            if (signerEnumer.hasMoreElements()) {
                signerInfo = this.isNewFormat() ? SM2SignerInfo2.getInstance(signerEnumer.nextElement()) : SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    if (logger.isErrorEnabled()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("verifySM2SignerInfoByHash::<<<<<<Failure: DO NOT FIND SignerCert");
                        buffer.append("\n issuerAndSN: ");
                        buffer.append(Debugger.dump(issuerAndSN));
                        buffer.append("\n certs: ");
                        buffer.append(Debugger.dump(certs));
                        logger.error(buffer.toString());
                    }
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySM2SignerInfoByHash::::::::verifySign Running signature=" + Debugger.dump(signature));
                }
                boolean verifyResult = this.session.verifyByHash(new Mechanism("SM3withSM2"), pubKey, digest, signature);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySM2SignerInfoByHash::<<<<<<Finished: verifyResult=" + verifyResult);
                }
                return verifyResult;
            }
            logger.debug("verifySM2SignerInfoByHash::<<<<<<Finished: False");
            return false;
        }
        catch (Exception e) {
            logger.error("verifySM2SignerInfoByHash::<<<<<<Failure", e);
            throw new PKIException("8506204", "\u9a8c\u8bc1SM2\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    boolean isNewFormat() {
        return false;
    }
}

