/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.util.cipher.lib;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cmbc.cfca.asn1.parser.BigFileCipherUtil;
import cmbc.cfca.internal.tool.HashEncoderUtil;
import cmbc.cfca.rsa.envelope.RSASymmetricCryptoUtil;
import cmbc.cfca.rsa.signature.RSAPackageUtil;
import cmbc.cfca.sm2.envelope.SM2SymmetricCryptoUtil;
import cmbc.cfca.sm2.signature.SM2PrivateKey;
import cmbc.cfca.sm2.signature.SM2PublicKey;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.system.Debugger;
import cmbc.cfca.system.SM2Compatible;
import cmbc.cfca.util.HashUtil;
import cmbc.cfca.util.cipher.lib.Session;
import java.io.File;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;

abstract class BaseLib
implements Session {
    static final Logger logger;
    static final int encryptedType_SM2 = 1;
    static final int encryptedType_RSA = 2;
    static final int encryptedType_DES_RC4 = 17;
    static final int encryptedType_SM4 = 18;
    static final HashMap hashSignatureAlgorithms;
    static final HashMap hashEncryptedAlgorithms;

    BaseLib() {
    }

    static final boolean hasSignatureAlgorithm(String mType) {
        return hashSignatureAlgorithms.containsKey(mType);
    }

    public final KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateKeyPair>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n keyLength: " + keyLength);
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("null not allowed for mechanism");
            }
            KeyPair keypair = null;
            if ("SM2".equals(mechanism.getMechanismType())) {
                logger.debug("generateKeyPair::::::SM2");
                keypair = this.SM2GenerateKeyPair();
            } else if ("RSA".equals(mechanism.getMechanismType())) {
                logger.debug("generateKeyPai::::::RSA");
                keypair = this.RSAGenerateKeyPair(keyLength);
            } else {
                throw new PKIException("GenerateKeyPair failure with invalid MechanismType=" + mechanism.getMechanismType());
            }
            logger.debug("generateKeyPair<<<<<<Finished");
            return keypair;
        }
        catch (PKIException e) {
            logger.error("generateKeyPair<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("generateKeyPair<<<<<<Failure", e);
            throw new PKIException(e);
        }
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData, boolean sm2WithZFlag) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sign>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n priKey: ");
            buffer.append(Debugger.dump(priKey));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n sm2WithZFlag: " + sm2WithZFlag);
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("null not allowed for mechanism");
            }
            if (priKey == null) {
                throw new PKIException("null not allowed for priKey");
            }
            if (sourceData == null) {
                throw new PKIException("null not allowed for sourceData");
            }
            String mType = mechanism.getMechanismType();
            if (!BaseLib.hasSignatureAlgorithm(mType)) {
                throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
            }
            byte[] signValue = null;
            if ("SM3withSM2".equals(mType)) {
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                SM2PrivateKey sm2priKey = (SM2PrivateKey)priKey;
                byte[] hash = HashUtil.sm2HashMessage(sm2priKey.getSM2PublicKey(), sourceData, sm2WithZFlag);
                if (logger.isDebugEnabled()) {
                    logger.debug("sign<<<<<<hash=" + Debugger.dump(hash));
                }
                signValue = this.SM2Sign(hash, sm2priKey);
            } else {
                if (!(priKey instanceof RSAPrivateKey)) {
                    throw new PKIException("The private key type is not rsa type!");
                }
                RSAPrivateKey privateKey = (RSAPrivateKey)priKey;
                byte[] hash = HashUtil.rsaHashMessageDER(sourceData, mechanism);
                if (logger.isDebugEnabled()) {
                    logger.debug("sign<<<<<<hash=" + Debugger.dump(hash));
                }
                signValue = this.RSASignEncrypt(privateKey, hash);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("sign<<<<<<Finished,signValue=" + Debugger.dump(signValue));
            }
            return signValue;
        }
        catch (PKIException e) {
            logger.error("sign<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("sign<<<<<<Failure", e);
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, String sourceFilePath, boolean sm2WithZFlag) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sign>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n priKey: ");
            buffer.append(Debugger.dump(priKey));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n sm2WithZFlag: " + sm2WithZFlag);
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("null not allowed for mechanism");
            }
            if (priKey == null) {
                throw new PKIException("null not allowed for priKey");
            }
            if (sourceFilePath == null) {
                throw new PKIException("null not allowed for sourceFilePath");
            }
            String mType = mechanism.getMechanismType();
            if (!BaseLib.hasSignatureAlgorithm(mType)) {
                throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
            }
            byte[] signValue = null;
            if ("SM3withSM2".equals(mType)) {
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                SM2PrivateKey sm2priKey = (SM2PrivateKey)priKey;
                byte[] hash = HashUtil.sm2HashFile(sm2priKey.getSM2PublicKey(), sourceFilePath, sm2WithZFlag);
                if (logger.isDebugEnabled()) {
                    logger.debug("sign<<<<<<hash=" + Debugger.dump(hash));
                }
                signValue = this.SM2Sign(hash, sm2priKey);
            } else {
                if (!(priKey instanceof RSAPrivateKey)) {
                    throw new PKIException("The private key type is not rsa type!");
                }
                RSAPrivateKey privateKey = (RSAPrivateKey)priKey;
                byte[] hash = HashUtil.rsaHashFileDER(sourceFilePath, mechanism);
                if (logger.isDebugEnabled()) {
                    logger.debug("sign<<<<<<hash=" + Debugger.dump(hash));
                }
                signValue = this.RSASignEncrypt(privateKey, hash);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("sign<<<<<<Finished,signValue=" + Debugger.dump(signValue));
            }
            return signValue;
        }
        catch (PKIException e) {
            logger.error("sign<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("sign<<<<<<Failure", e);
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean verifySign(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifySign>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n pubKey: ");
            buffer.append(Debugger.dump(pubKey));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            buffer.append("\n signData: ");
            buffer.append(Debugger.dump(signData));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("null not allowed for mechanism");
            }
            if (pubKey == null) {
                throw new PKIException("null not allowed for pubKey");
            }
            if (sourceData == null) {
                throw new PKIException("null not allowed for sourceData");
            }
            if (signData == null) {
                throw new PKIException("null not allowed for signData");
            }
            String mType = mechanism.getMechanismType();
            if (!BaseLib.hasSignatureAlgorithm(mType)) {
                throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
            }
            boolean verifyResult = false;
            if ("SM3withSM2".equals(mType)) {
                if (!(pubKey instanceof SM2PublicKey)) {
                    throw new PKIException("The public key type is not sm2 type!");
                }
                SM2PublicKey sm2PublicKey = (SM2PublicKey)pubKey;
                byte[] hash = null;
                if (64 == signData.length) {
                    hash = this.SM3HashMessage(sm2PublicKey, sourceData, true);
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifySign<<<<<<[withZ]Hash=" + Debugger.dump(hash));
                    }
                    verifyResult = this.SM2Verify(hash, signData, sm2PublicKey);
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifySign<<<<<<[withZ]verifyResult=" + verifyResult);
                    }
                    if (!verifyResult) {
                        hash = this.SM3HashMessage(sm2PublicKey, sourceData, false);
                        if (logger.isDebugEnabled()) {
                            logger.debug("verifySign<<<<<<[noneZ]Hash=" + Debugger.dump(hash));
                        }
                        verifyResult = this.SM2Verify(hash, signData, sm2PublicKey);
                        if (logger.isDebugEnabled()) {
                            logger.debug("verifySign<<<<<<[noneZ]verifyResult=" + verifyResult);
                        }
                    }
                } else {
                    if (128 != signData.length) throw new PKIException("the sm2 signature length must be 64 or 128 bytes!");
                    hash = HashUtil.sm2HashMessage(sm2PublicKey, sourceData, true);
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifySign<<<<<<[CMBC-Custom]SM2Operation: hash=" + Debugger.dump(hash));
                    }
                    verifyResult = this.SM2CMBCVerify(sm2PublicKey, signData, hash);
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifySign<<<<<<[CMBC-Custom]SM2Operation,Finished=" + verifyResult);
                    }
                }
            } else {
                if (!(pubKey instanceof RSAPublicKey)) {
                    throw new PKIException("The public key type is not rsa type!");
                }
                byte[] hash = HashUtil.rsaHashMessageDER(sourceData, mechanism);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySign<<<<<<[RSA]SourceHash=" + Debugger.dump(hash));
                }
                byte[] hashValue = this.RSAVerifyDecrypt((RSAPublicKey)pubKey, signData);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySign<<<<<<[RSA]DecryptHash=" + Debugger.dump(hashValue));
                }
                verifyResult = RSAPackageUtil.isRSAHashEqual(hashValue, hash);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySign<<<<<<[RSA]verifyResult=" + verifyResult);
                }
            }
            if (!logger.isDebugEnabled()) return verifyResult;
            logger.debug("verifySign<<<<<<Finished,verifyResult=" + verifyResult);
            return verifyResult;
        }
        catch (PKIException e) {
            logger.error("verifySign<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("verifySign<<<<<<Failure", e);
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final boolean verifySign(Mechanism mechanism, PublicKey pubKey, String sourceFilePath, byte[] signData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifySign>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n pubKey: ");
            buffer.append(Debugger.dump(pubKey));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n signData: ");
            buffer.append(Debugger.dump(signData));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("null not allowed for mechanism");
            }
            if (pubKey == null) {
                throw new PKIException("null not allowed for pubKey");
            }
            if (sourceFilePath == null) {
                throw new PKIException("null not allowed for sourceFilePath");
            }
            if (signData == null) {
                throw new PKIException("null not allowed for signData");
            }
            String mType = mechanism.getMechanismType();
            if (!BaseLib.hasSignatureAlgorithm(mType)) {
                throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
            }
            boolean verifyResult = false;
            if ("SM3withSM2".equals(mType)) {
                if (!(pubKey instanceof SM2PublicKey)) {
                    throw new PKIException("The public key type is not sm2 type!");
                }
                SM2PublicKey sm2PublicKey = (SM2PublicKey)pubKey;
                if (signData.length == 64) {
                    byte[] hash = HashUtil.sm2HashFile(sm2PublicKey, sourceFilePath, true);
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifySign<<<<<<[withZ]Hash=" + Debugger.dump(hash));
                    }
                    verifyResult = this.SM2Verify(hash, signData, sm2PublicKey);
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifySign<<<<<<[withZ]verifyResult=" + verifyResult);
                    }
                    if (!verifyResult) {
                        hash = HashUtil.sm2HashFile(sm2PublicKey, sourceFilePath, false);
                        if (logger.isDebugEnabled()) {
                            logger.debug("verifySign<<<<<<[noneZ]Hash=" + Debugger.dump(hash));
                        }
                        verifyResult = this.SM2Verify(hash, signData, sm2PublicKey);
                        if (logger.isDebugEnabled()) {
                            logger.debug("verifySign<<<<<<[noneZ]verifyResult=" + verifyResult);
                        }
                    }
                } else {
                    byte[] hash = HashUtil.sm2HashFile(sm2PublicKey, sourceFilePath, true);
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifySign<<<<<<[CMBC-Custom]SM2Operation: hash=" + Debugger.dump(hash));
                    }
                    verifyResult = this.SM2CMBCVerify(sm2PublicKey, signData, hash);
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifySign<<<<<<[CMBC-Custom]SM2Operation: verifyResult=" + verifyResult);
                    }
                }
            } else {
                if (!(pubKey instanceof RSAPublicKey)) {
                    throw new PKIException("The public key type is not rsa type!");
                }
                byte[] hash = HashUtil.rsaHashFileDER(sourceFilePath, mechanism);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySign<<<<<<[RSA]SourceHash=" + Debugger.dump(hash));
                }
                byte[] hashValue = this.RSAVerifyDecrypt((RSAPublicKey)pubKey, signData);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySign<<<<<<[RSA]DecryptHash=" + Debugger.dump(hashValue));
                }
                verifyResult = RSAPackageUtil.isRSAHashEqual(hashValue, hash);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifySign<<<<<<[RSA]verifyResult=" + verifyResult);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("verifySign<<<<<<Finished,verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (PKIException e) {
            logger.error("verifySign<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("verifySign<<<<<<Failure", e);
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final byte[] signByHash(Mechanism mechanism, PrivateKey priKey, byte[] rawHashValue) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("signByHash>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n priKey: ");
            buffer.append(Debugger.dump(priKey));
            buffer.append("\n rawHashValue: ");
            buffer.append(Debugger.dump(rawHashValue));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("null not allowed for mechanism");
            }
            if (priKey == null) {
                throw new PKIException("null not allowed for priKey");
            }
            if (rawHashValue == null) {
                throw new PKIException("null not allowed for digest");
            }
            String mType = mechanism.getMechanismType();
            if (!BaseLib.hasSignatureAlgorithm(mType)) {
                throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
            }
            byte[] signValue = null;
            if ("SM3withSM2".equals(mType)) {
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                SM2PrivateKey sm2priKey = (SM2PrivateKey)priKey;
                if (logger.isDebugEnabled()) {
                    logger.debug("signByHash<<<<<<hash=" + Debugger.dump(rawHashValue));
                }
                signValue = this.SM2Sign(rawHashValue, sm2priKey);
            } else {
                if (!(priKey instanceof RSAPrivateKey)) {
                    throw new PKIException("The private key type is not rsa type!");
                }
                RSAPrivateKey privateKey = (RSAPrivateKey)priKey;
                byte[] hashValue = HashEncoderUtil.derEncoder(mType, rawHashValue);
                if (logger.isDebugEnabled()) {
                    logger.debug("signByHash<<<<<<hash=" + Debugger.dump(hashValue));
                }
                signValue = this.RSASignEncrypt(privateKey, hashValue);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("signByHash<<<<<<Finished,signValue=" + Debugger.dump(signValue));
            }
            return signValue;
        }
        catch (PKIException e) {
            logger.error("signByHash<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("signByHash<<<<<<Failure", e);
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] rawHashValue, byte[] signData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifyByHash>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n pubKey: ");
            buffer.append(Debugger.dump(pubKey));
            buffer.append("\n rawHashValue: ");
            buffer.append(Debugger.dump(rawHashValue));
            buffer.append("\n signData: ");
            buffer.append(Debugger.dump(signData));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("null not allowed for mechanism");
            }
            if (pubKey == null) {
                throw new PKIException("null not allowed for pubKey");
            }
            if (rawHashValue == null) {
                throw new PKIException("null not allowed for digest");
            }
            if (signData == null) {
                throw new PKIException("null not allowed for signData");
            }
            String mType = mechanism.getMechanismType();
            if (!BaseLib.hasSignatureAlgorithm(mType)) {
                throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
            }
            boolean verifyResult = false;
            if ("SM3withSM2".equals(mType)) {
                if (!(pubKey instanceof SM2PublicKey)) {
                    throw new PKIException("The public key type is not sm2 type!");
                }
                SM2PublicKey sm2PublicKey = (SM2PublicKey)pubKey;
                if (signData.length == 64) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifyByHash<<<<<<Hash=" + Debugger.dump(rawHashValue));
                    }
                    verifyResult = this.SM2Verify(rawHashValue, signData, sm2PublicKey);
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifyByHash<<<<<<verifyResult=" + verifyResult);
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifyByHash<<<<<<[CMBC-Custom]SM2Operation: hash=" + Debugger.dump(rawHashValue));
                    }
                    verifyResult = this.SM2CMBCVerify(sm2PublicKey, signData, rawHashValue);
                    if (logger.isDebugEnabled()) {
                        logger.debug("verifyByHash<<<<<<[CMBC-Custom]SM2Operation: verifyResult=" + verifyResult);
                    }
                }
            } else {
                if (!(pubKey instanceof RSAPublicKey)) {
                    throw new PKIException("The public key type is not rsa type!");
                }
                byte[] hash = HashEncoderUtil.derEncoder(mType, rawHashValue);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifyByHash<<<<<<[RSA]SourceHash=" + Debugger.dump(hash));
                }
                byte[] hashValue = this.RSAVerifyDecrypt((RSAPublicKey)pubKey, signData);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifyByHash<<<<<<[RSA]DecryptHash=" + Debugger.dump(hashValue));
                }
                verifyResult = RSAPackageUtil.isRSAHashEqual(hashValue, hash);
                if (logger.isDebugEnabled()) {
                    logger.debug("verifyByHash<<<<<<[RSA]verifyResult=" + verifyResult);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("verifyByHash<<<<<<Finished,verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (PKIException e) {
            logger.error("verifyByHash<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("verifyByHash<<<<<<Failure", e);
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encrypt>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(Debugger.dump(key));
            buffer.append("\n sourceData: ");
            buffer.append(Debugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("null not allowed for mechanism");
            }
            if (key == null) {
                throw new PKIException("null not allowed for key");
            }
            if (sourceData == null) {
                throw new PKIException("null not allowed for sourceData");
            }
            String mType = mechanism.getMechanismType();
            Integer value = (Integer)hashEncryptedAlgorithms.get(mType);
            if (value == null) {
                throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mType);
            }
            byte[] encryptedData = null;
            switch (value) {
                case 1: {
                    logger.debug("encrypt<<<<<<SM2Encrypt");
                    encryptedData = this.SM2Encrypt((SM2PublicKey)key, sourceData);
                    break;
                }
                case 2: {
                    logger.debug("encrypt<<<<<<RSAEncrypt");
                    encryptedData = this.RSAEncrypt((RSAPublicKey)key, sourceData, mechanism);
                    break;
                }
                case 17: {
                    logger.debug("encrypt<<<<<<RC4/DES3");
                    encryptedData = RSASymmetricCryptoUtil.encrypt(key.getEncoded(), sourceData, mechanism);
                    break;
                }
                case 18: {
                    logger.debug("encrypt<<<<<<SM4");
                    encryptedData = SM2SymmetricCryptoUtil.cryptoUtil(true, key.getEncoded(), sourceData, mechanism);
                    break;
                }
                default: {
                    throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mType);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("encrypt<<<<<<Finished,encryptedData=" + Debugger.dump(encryptedData));
            }
            return encryptedData;
        }
        catch (PKIException e) {
            logger.error("encrypt<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("encrypt<<<<<<Failure", e);
            throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("decrypt>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(Debugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(Debugger.dump(encryptData));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("null not allowed for mechanism");
            }
            if (key == null) {
                throw new PKIException("null not allowed for key");
            }
            if (encryptData == null) {
                throw new PKIException("null not allowed for encryptData");
            }
            String mType = mechanism.getMechanismType();
            Integer value = (Integer)hashEncryptedAlgorithms.get(mType);
            if (value == null) {
                throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mType);
            }
            byte[] decryptedData = null;
            switch (value) {
                case 1: {
                    logger.debug("decrypt<<<<<<SM2Decrypt");
                    decryptedData = this.SM2Decrypt((SM2PrivateKey)key, encryptData);
                    break;
                }
                case 2: {
                    logger.debug("decrypt<<<<<<RSADecrypt");
                    decryptedData = this.RSADecrypt((RSAPrivateKey)key, encryptData, mechanism);
                    break;
                }
                case 17: {
                    logger.debug("decrypt<<<<<<RC4/DES3");
                    decryptedData = RSASymmetricCryptoUtil.decrypt(key.getEncoded(), encryptData, mechanism);
                    break;
                }
                case 18: {
                    logger.debug("decrypt<<<<<<SM4");
                    decryptedData = SM2SymmetricCryptoUtil.cryptoUtil(false, key.getEncoded(), encryptData, mechanism);
                    break;
                }
                default: {
                    throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mType);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("decrypt<<<<<<Finished,decryptedData=" + Debugger.dump(decryptedData));
            }
            return decryptedData;
        }
        catch (PKIException e) {
            logger.error("decrypt<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("decrypt<<<<<<Failure", e);
            throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final void encrypt(Mechanism mechanism, Key key, String sourceFilePath, String encryptFilePath) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encrypt>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(Debugger.dump(key));
            buffer.append("\n sourceFilePath: ");
            buffer.append(Debugger.dump(sourceFilePath));
            buffer.append("\n encryptFilePath: ");
            buffer.append(Debugger.dump(encryptFilePath));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("null not allowed for mechanism");
            }
            if (key == null) {
                throw new PKIException("null not allowed for key");
            }
            if (sourceFilePath == null) {
                throw new PKIException("null not allowed for sourceFilePath");
            }
            if (encryptFilePath == null) {
                throw new PKIException("null not allowed for encryptFilePath");
            }
            BigFileCipherUtil.bigFileBlockCipher(true, mechanism, key.getEncoded(), new File(sourceFilePath), new File(encryptFilePath));
            if (logger.isDebugEnabled()) {
                logger.debug("encrypt<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            logger.error("encrypt<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("encrypt<<<<<<Failure", e);
            throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final void decrypt(Mechanism mechanism, Key key, String encryptFilePath, String plainTextFilePath) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("decrypt>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(Debugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(Debugger.dump(key));
            buffer.append("\n encryptFilePath: ");
            buffer.append(Debugger.dump(encryptFilePath));
            buffer.append("\n plainTextFilePath: ");
            buffer.append(Debugger.dump(plainTextFilePath));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("null not allowed for mechanism");
            }
            if (key == null) {
                throw new PKIException("null not allowed for key");
            }
            if (encryptFilePath == null) {
                throw new PKIException("null not allowed for encryptFilePath");
            }
            if (plainTextFilePath == null) {
                throw new PKIException("null not allowed for plainTextFilePath");
            }
            BigFileCipherUtil.bigFileBlockCipher(false, mechanism, key.getEncoded(), new File(encryptFilePath), new File(plainTextFilePath));
            if (logger.isDebugEnabled()) {
                logger.debug("decrypt<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            logger.error("decrypt<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("decrypt<<<<<<Failure", e);
            throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final Key generateKey(Mechanism mechanism) throws PKIException {
        return RSASymmetricCryptoUtil.generateSecureKey(mechanism);
    }

    public final byte[] sign(Mechanism signAlg, PrivateKey priKey, byte[] sourceData) throws PKIException {
        return this.sign(signAlg, priKey, sourceData, SM2Compatible.isOutputSM2SignedWithZ());
    }

    public final byte[] sign(Mechanism signAlg, PrivateKey priKey, String sourceFilePath) throws PKIException {
        return this.sign(signAlg, priKey, sourceFilePath, SM2Compatible.isOutputSM2SignedWithZ());
    }

    abstract KeyPair SM2GenerateKeyPair() throws PKIException;

    abstract KeyPair RSAGenerateKeyPair(int var1) throws PKIException;

    abstract byte[] SM2Sign(byte[] var1, SM2PrivateKey var2) throws PKIException;

    abstract boolean SM2Verify(byte[] var1, byte[] var2, SM2PublicKey var3) throws PKIException;

    abstract boolean SM2CMBCVerify(SM2PublicKey var1, byte[] var2, byte[] var3) throws PKIException;

    abstract byte[] SM2Encrypt(SM2PublicKey var1, byte[] var2) throws PKIException;

    abstract byte[] SM2Decrypt(SM2PrivateKey var1, byte[] var2) throws PKIException;

    abstract byte[] SM3HashMessage(SM2PublicKey var1, byte[] var2, boolean var3) throws PKIException;

    abstract byte[] RSASignEncrypt(RSAPrivateKey var1, byte[] var2) throws PKIException;

    abstract byte[] RSAVerifyDecrypt(RSAPublicKey var1, byte[] var2) throws PKIException;

    abstract byte[] RSAEncrypt(RSAPublicKey var1, byte[] var2, Mechanism var3) throws PKIException;

    abstract byte[] RSADecrypt(RSAPrivateKey var1, byte[] var2, Mechanism var3) throws PKIException;

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(BaseLib.class);
        hashSignatureAlgorithms = new HashMap();
        hashEncryptedAlgorithms = new HashMap();
        hashSignatureAlgorithms.put("SM3withSM2", null);
        hashSignatureAlgorithms.put("SHA1withRSAEncryption", null);
        hashSignatureAlgorithms.put("SHA256withRSAEncryption", null);
        hashSignatureAlgorithms.put("SHA512withRSA", null);
        hashSignatureAlgorithms.put("MD5withRSAEncryption", null);
        hashEncryptedAlgorithms.put("SM2", new Integer(1));
        hashEncryptedAlgorithms.put("RSA/ECB/PKCS1PADDING", new Integer(2));
        hashEncryptedAlgorithms.put("DESede/CBC/PKCS7Padding", new Integer(17));
        hashEncryptedAlgorithms.put("DESede/ECB/PKCS7Padding", new Integer(17));
        hashEncryptedAlgorithms.put("RC4", new Integer(17));
        hashEncryptedAlgorithms.put("SM4/CBC/PKCS7Padding", new Integer(18));
        hashEncryptedAlgorithms.put("SM4/ECB/PKCS7Padding", new Integer(18));
    }
}

