/*
 * Decompiled with CFR 0.152.
 */
package com.cmbc.openbank.api.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cmbc.openbank.api.client.CmbcClient;
import com.cmbc.openbank.api.exception.CmbcApiException;
import com.cmbc.openbank.api.request.BusiParam;
import com.cmbc.openbank.api.request.CmbcRequest;
import com.cmbc.openbank.api.response.CmbcResponse;
import com.cmbc.openbank.api.utils.HttpClientUtil;
import com.cmbc.openbank.api.utils.SignVerifyTenantUtil;
import com.cmbc.openbank.api.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCmbcClient
implements CmbcClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCmbcClient.class);
    protected String app_id;
    protected String encrypt_type = "SM2";
    protected String format = "json";
    protected String auth_token;
    protected String notify_url;
    protected String privateKey;
    protected String privateKeyPwd;
    protected String cmbcPublicKey;
    protected String customerNo;
    protected String cust_id;
    protected String cust_sign;

    public DefaultCmbcClient(String app_id) {
        this.app_id = app_id;
    }

    public DefaultCmbcClient(String app_id, String encrypt_type, String format) {
        this.app_id = app_id;
        this.encrypt_type = encrypt_type;
        this.format = format;
    }

    public DefaultCmbcClient(String app_id, String privateKey, String privateKeyPwd, String cmbcPublicKey, String customerNo) {
        this.app_id = app_id;
        this.privateKey = privateKey;
        this.privateKeyPwd = privateKeyPwd;
        this.cmbcPublicKey = cmbcPublicKey;
        this.customerNo = customerNo;
    }

    public DefaultCmbcClient(String app_id, String privateKey, String privateKeyPwd, String cmbcPublicKey, String customerNo, String auth_token, String notify_url) {
        this.app_id = app_id;
        this.privateKey = privateKey;
        this.privateKeyPwd = privateKeyPwd;
        this.cmbcPublicKey = cmbcPublicKey;
        this.customerNo = customerNo;
        this.auth_token = auth_token;
        this.notify_url = notify_url;
    }

    public DefaultCmbcClient(String app_id, String privateKey, String privateKeyPwd, String cmbcPublicKey, String customerNo, String auth_token, String notify_url, String cust_id, String cust_sign) {
        this.app_id = app_id;
        this.privateKey = privateKey;
        this.privateKeyPwd = privateKeyPwd;
        this.cmbcPublicKey = cmbcPublicKey;
        this.customerNo = customerNo;
        this.auth_token = auth_token;
        this.notify_url = notify_url;
        this.cust_id = cust_id;
        this.cust_sign = cust_sign;
    }

    @Override
    public <T extends CmbcResponse> T execute(CmbcRequest<T> paramCmbcRequest) throws CmbcApiException {
        UUID uuid = UUID.randomUUID();
        String uuidStr = uuid.toString().replace("-", "");
        return this.execute(paramCmbcRequest, uuidStr);
    }

    @Override
    public <T extends CmbcResponse> T execute(CmbcRequest<T> paramCmbcRequest, String paramString) throws CmbcApiException {
        return this.execute(paramCmbcRequest, paramString, "");
    }

    @Override
    public <T extends CmbcResponse> T execute(CmbcRequest<T> paramCmbcRequest, String paramString, String paramString2) throws CmbcApiException {
        String paramsStr;
        Map params = this.prepareParams(paramCmbcRequest, paramString, paramString2);
        String respStr = null;
        if (paramCmbcRequest.getRequestType().equals("GET")) {
            return null;
        }
        if (paramCmbcRequest.getRequestType().equals("POST")) {
            paramsStr = null;
            if (this.format.equals("json")) {
                paramsStr = JSON.toJSONString((Object)params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
            }
        } else {
            logger.error("only support GET or POST, requestType:{} ", (Object)paramCmbcRequest.getRequestType());
            throw new CmbcApiException("only support GET or POST, requestType: " + paramCmbcRequest.getRequestType());
        }
        HttpClientUtil httpClientUtil = new HttpClientUtil();
        respStr = httpClientUtil.execute(paramsStr, paramCmbcRequest.getServiceUrl());
        T response = this.parse(paramCmbcRequest, respStr);
        if (response == null) {
            logger.error("response is null.");
            throw new CmbcApiException("response is null.");
        }
        return response;
    }

    protected <T extends CmbcResponse> T parse(CmbcRequest<T> request, String respStr) throws CmbcApiException {
        return this.parseJsonWithSign(request, respStr);
    }

    private <T extends CmbcResponse> T parseJsonWithSign(CmbcRequest<T> request, String respStr) throws CmbcApiException {
        Object sign = null;
        String responseBusiStr = null;
        Map responseMap = null;
        CmbcResponse response = null;
        try {
            response = new CmbcResponse();
            responseMap = (Map)JSON.parseObject((String)respStr, Map.class);
            if (request.isNeedEncrypt()) {
                if (responseMap.containsKey("response_busi")) {
                    responseBusiStr = SignVerifyTenantUtil.openEnvelopedMessageA(this.privateKey, this.privateKeyPwd, this.cmbcPublicKey, (String)responseMap.get("response_busi"));
                }
                if (responseMap.containsKey("sign")) {
                    boolean passed = SignVerifyTenantUtil.verifyA(this.privateKey, this.privateKeyPwd, this.cmbcPublicKey, (String)responseMap.get("sign"), responseBusiStr);
                    if (passed) {
                        response.setResponse_busi(responseBusiStr);
                        response.setReturn_code((String)responseMap.get("return_code"));
                        if (responseMap.containsKey("return_msg")) {
                            response.setReturn_msg((String)responseMap.get("return_msg"));
                        }
                        return (T)response;
                    }
                    response.setReturn_code("checkSignError01");
                    response.setReturn_msg("\u9a8c\u7b7e\u5931\u8d25");
                    return (T)response;
                }
            }
        }
        catch (Exception e) {
            logger.error("response is not format json. respStr :\n" + respStr, (Throwable)e);
            throw new CmbcApiException("response is not format json. respStr :\n" + respStr, e);
        }
        try {
            return (T)((CmbcResponse)JSON.parseObject((String)respStr, request.getResponseClass()));
        }
        catch (Exception e) {
            logger.error("response can not transform to defined class. response: " + respStr + " defined class name: " + request.getResponseClass().getName(), (Throwable)e);
            throw new CmbcApiException("response can not transform to defined class. response: " + respStr + " defined class name: " + request.getResponseClass().getName(), e);
        }
    }

    protected Map prepareParams(CmbcRequest<?> request, String paramString, String paramString2) throws CmbcApiException {
        ArrayList<String> commonParam = new ArrayList<String>();
        Map busiParamMap = this.buildBusiParamMap(request);
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map<String, String> extraParams = request.getExtraParameters();
        if (extraParams != null) {
            params.putAll(extraParams);
        }
        params.put("request_id", paramString);
        params.put("app_id", this.app_id);
        params.put("method", request.getMethod());
        params.put("version", request.getVersion());
        params.put("encrypt_type", this.encrypt_type);
        params.put("format", this.format);
        params.put("auth_token", this.auth_token);
        params.put("cust_id", this.cust_id);
        params.put("cust_sign", this.cust_sign);
        params.put("notify_url", this.notify_url);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        String time = dateFormat.format(new Date(timestamp));
        params.put("timestamp", time);
        commonParam.add(paramString);
        commonParam.add(this.app_id);
        commonParam.add(request.getMethod());
        commonParam.add(request.getVersion());
        commonParam.add(this.encrypt_type);
        commonParam.add(this.format);
        commonParam.add(this.auth_token);
        commonParam.add(this.cust_id);
        commonParam.add(this.cust_sign);
        commonParam.add(this.notify_url);
        commonParam.add(time);
        if (request.isNeedEncrypt()) {
            if (!StringUtils.areNotEmpty(new String[]{this.encrypt_type})) {
                logger.error("request need be encrypted, encrypt type can not be null.");
                throw new CmbcApiException("request need be encrypted, encrypt type can not be null.");
            }
            if (busiParamMap != null) {
                StringBuilder str;
                String signedStr = "";
                String busiParamStr = "";
                if (this.encrypt_type.equals("SM2")) {
                    busiParamStr = JSON.toJSONString((Object)busiParamMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
                    str = new StringBuilder(busiParamStr);
                    for (Object e : commonParam) {
                        String value = null;
                        if (null != e) {
                            if (e instanceof String) {
                                value = (String)e;
                            } else if (e instanceof Map) {
                                value = JSON.toJSONString(e, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
                            }
                        }
                        str.append("|");
                        if (value == null) continue;
                        str.append(value);
                    }
                } else {
                    if (this.encrypt_type.equals("AES")) {
                        return null;
                    }
                    logger.error("encryptType is not supported.");
                    throw new CmbcApiException("encryptType is not supported.");
                }
                signedStr = SignVerifyTenantUtil.p7DetachMsgSignA(str.toString(), this.privateKey, this.privateKeyPwd, this.cmbcPublicKey);
                busiParamStr = SignVerifyTenantUtil.envelopeEncryptMessage(busiParamStr, this.customerNo, this.privateKey, this.privateKeyPwd, this.cmbcPublicKey);
                params.put("sign", signedStr);
                params.put("busi_param", busiParamStr);
            }
        } else {
            params.put("busi_param", busiParamMap);
            params.put("sign", "");
        }
        return params;
    }

    protected Map buildBusiParamMap(CmbcRequest<?> request) throws CmbcApiException {
        return this.buildBusiParamMap(request.getBusiParam());
    }

    protected Map buildBusiParamMap(BusiParam busiParam) throws CmbcApiException {
        if (busiParam == null) {
            return null;
        }
        if (this.format.equals("json")) {
            return (Map)JSON.toJSON((Object)busiParam);
        }
        logger.error("only support json format, current format is not supported. format: {}", (Object)this.format);
        throw new CmbcApiException("only support json format, current format is not supported. format: " + this.format);
    }

    protected String buildBusiParamStr(CmbcRequest<?> request) throws CmbcApiException {
        if (request.getBusiParam() == null) {
            return null;
        }
        if (this.format.equals("json")) {
            return JSON.toJSONString((Object)request.getBusiParam(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
        }
        logger.error("only support json format, current format is not supported. format: {}", (Object)this.format);
        throw new CmbcApiException("only support json format, current format is not supported. format: " + this.format);
    }
}

