/*
 * Decompiled with CFR 0.152.
 */
package com.cmbc.openbank.api.client;

import com.cmbc.openbank.api.client.DefaultCmbcClient;
import com.cmbc.openbank.api.exception.CmbcApiException;
import com.cmbc.openbank.api.request.CmbcRequest;
import com.cmbc.openbank.api.utils.WebUtils;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebCmbcClient
extends DefaultCmbcClient {
    private static final Logger logger = LoggerFactory.getLogger(WebCmbcClient.class);

    public WebCmbcClient(String appId) {
        super(appId);
    }

    public WebCmbcClient(String appId, String encryptType, String format) {
        super(appId, encryptType, format);
    }

    public WebCmbcClient(String appId, String privateKey, String privateKeyPwd, String cmbcPublicKey, String customerNo) {
        super(appId, privateKey, privateKeyPwd, cmbcPublicKey, customerNo);
    }

    public WebCmbcClient(String appId, String privateKey, String privateKeyPwd, String cmbcPublicKey, String customerNo, String authToken, String notifyUrl) {
        super(appId, privateKey, privateKeyPwd, cmbcPublicKey, customerNo, authToken, notifyUrl);
    }

    public String buildPostJson(CmbcRequest<?> request) throws CmbcApiException {
        UUID uuid = UUID.randomUUID();
        String uuidStr = uuid.toString().replace("-", "");
        return this.buildPostJson(request, uuidStr, null);
    }

    public String buildPostJson(CmbcRequest<?> request, String paramString) throws CmbcApiException {
        return this.buildPostJson(request, paramString, null);
    }

    public String buildPostJson(CmbcRequest<?> request, String paramString, String paramString2) throws CmbcApiException {
        Map paramsMap = super.prepareParams(request, paramString, paramString2);
        return WebUtils.buildJson(request.getServiceUrl(), paramsMap);
    }

    public String buildPostForm(CmbcRequest<?> request) throws CmbcApiException {
        UUID uuid = UUID.randomUUID();
        String uuidStr = uuid.toString().replace("-", "");
        return this.buildPostForm(request, uuidStr, null);
    }

    public String buildPostForm(CmbcRequest<?> request, String paramString) throws CmbcApiException {
        return this.buildPostForm(request, paramString, null);
    }

    public String buildPostForm(CmbcRequest<?> request, String paramString, String paramString2) throws CmbcApiException {
        Map paramsMap = super.prepareParams(request, paramString, paramString2);
        return WebUtils.buildForm(request.getServiceUrl(), paramsMap);
    }

    public String buildGetForm(CmbcRequest<?> request, String paramString, String paramString2) throws CmbcApiException {
        Map paramsMap = super.prepareParams(request, paramString, paramString2);
        String url = WebUtils.buildGetUrl(request.getServiceUrl(), paramsMap, "UTF-8");
        return WebUtils.buildForm(url, paramsMap);
    }
}

