/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.pure.impl;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTKey;
import cfca.sadk.tls.pure.CryptoException;
import cfca.sadk.tls.pure.ISignature;
import cfca.sadk.tls.pure.impl.SM2Helper;
import cfca.sadk.tls.sun.security.ssl.sec.CryptoFactory;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class SM2Signature
implements ISignature {
    private static final Mechanism signAlg = new Mechanism("sm3WithSM2Encryption");
    private final SM3Digest hash = new SM3Digest();
    private GMTKey publicKey = null;
    private GMTKey privateKey = null;

    @Override
    public void initSign(PrivateKey sm2PrivateKey) throws CryptoException {
        GMTKey sm2Key = SM2Helper.form(sm2PrivateKey);
        byte[] defaultZ = sm2Key.getDefaultZ();
        this.hash.reset();
        this.hash.update(defaultZ, 0, defaultZ.length);
        this.privateKey = sm2Key;
    }

    @Override
    public void initVerify(PublicKey sm2PublicKey) throws CryptoException {
        GMTKey sm2Key = SM2Helper.form(sm2PublicKey);
        byte[] defaultZ = sm2Key.getDefaultZ();
        this.hash.reset();
        this.hash.update(defaultZ, 0, defaultZ.length);
        this.publicKey = sm2Key;
    }

    @Override
    public int update(byte[] data) throws CryptoException {
        if (data != null) {
            this.hash.update(data, 0, data.length);
        }
        return data == null ? 0 : data.length;
    }

    @Override
    public int update(byte[] data, int offset, int length) throws CryptoException {
        int len = 0;
        if (data != null && data.length > offset) {
            len = data.length - offset;
            len = len > length ? length : len;
            this.hash.update(data, offset, len);
        }
        return len;
    }

    @Override
    public int update(byte data) throws CryptoException {
        this.hash.update(data);
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] sign() throws CryptoException {
        if (this.privateKey == null) {
            throw new CryptoException("privateKey not inited");
        }
        byte[] signData = null;
        if (!(this.privateKey instanceof SM2PrivateKey)) throw new CryptoException("privateKey not SM2PrivateKey");
        try {
            Session session = CryptoFactory.singleton().session();
            byte[] hashValue = new byte[32];
            this.hash.doFinal(hashValue, 0);
            signData = session.signByHash(signAlg, (PrivateKey)((SM2PrivateKey)this.privateKey), hashValue);
            if (signData.length != 64) return signData;
            return new ASN1SM2Signature(signData).getEncoded();
        }
        catch (Exception e) {
            throw new CryptoException("sign failed", e);
        }
    }

    @Override
    public boolean verify(byte[] signValue) throws CryptoException {
        if (this.publicKey == null) {
            throw new CryptoException("publicKey not inited");
        }
        if (signValue == null) {
            throw new CryptoException("signValue==null");
        }
        boolean verifiedResult = false;
        if (this.publicKey instanceof SM2PublicKey) {
            try {
                Session session = CryptoFactory.singleton().session();
                if (signValue.length != 64) {
                    ASN1SM2Signature signval = new ASN1SM2Signature(signValue);
                    signValue = signval.getRSRaw64Bytes();
                }
                byte[] hashValue = new byte[32];
                this.hash.doFinal(hashValue, 0);
                verifiedResult = session.verifyByHash(signAlg, (PublicKey)((SM2PublicKey)this.publicKey), hashValue, signValue);
            }
            catch (Exception e) {
                throw new CryptoException("verify failed", e);
            }
        } else {
            throw new CryptoException("publicKey not SM2PublicKey");
        }
        return verifiedResult;
    }
}

