/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.pure.impl;

import cfca.sadk.org.bouncycastle.crypto.digests.GeneralDigest;
import cfca.sadk.org.bouncycastle.util.Memoable;
import cfca.sadk.tls.pure.CryptoException;
import cfca.sadk.tls.pure.IDigest;

public class SM3Digest
implements IDigest {
    private final GeneralDigest digest;

    public SM3Digest() {
        this((GeneralDigest)new cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest());
    }

    private SM3Digest(GeneralDigest digest) {
        this.digest = digest;
    }

    @Override
    public String getAlgorithmName() {
        return this.digest.getAlgorithmName();
    }

    @Override
    public int getDigestSize() {
        return this.digest.getDigestSize();
    }

    @Override
    public void update(byte in) {
        this.digest.update(in);
    }

    @Override
    public void update(byte[] in) {
        if (in != null) {
            this.digest.update(in, 0, in.length);
        }
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.digest.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return this.digest.doFinal(out, outOff);
    }

    @Override
    public byte[] digest() {
        byte[] result = new byte[this.getDigestSize()];
        this.doFinal(result, 0);
        return result;
    }

    @Override
    public int digest(byte[] buf, int offset, int len) throws CryptoException {
        if (buf == null) {
            throw new IllegalArgumentException("No output buffer given");
        }
        if (buf.length - offset < len) {
            throw new IllegalArgumentException("Output buffer too small for specified offset and length");
        }
        byte[] digest = this.digest();
        if (len < digest.length) {
            throw new CryptoException("partial digests not returned");
        }
        if (buf.length - offset < digest.length) {
            throw new CryptoException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(digest, 0, buf, offset, digest.length);
        return digest.length;
    }

    @Override
    public byte[] digest(byte[] input) {
        this.update(input);
        return this.digest();
    }

    @Override
    public void reset() {
        this.digest.reset();
    }

    public Memoable copy() {
        return new SM3Digest((GeneralDigest)this.digest.copy());
    }

    public void reset(Memoable other) {
        this.digest.reset((Memoable)((SM3Digest)other).digest);
    }
}

