/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.Authenticator;
import cfca.sadk.tls.sun.security.ssl.ByteBufferInputStream;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.InputRecord;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.SSLEngineImpl;
import cfca.sadk.tls.sun.security.ssl.sec.CipherBox;
import cfca.sadk.tls.sun.security.ssl.sec.MAC;
import cfca.sadk.tls.util.Hex;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;

final class EngineInputRecord
extends InputRecord {
    private SSLEngineImpl engine;
    private static ByteBuffer tmpBuffer = ByteBuffer.allocate(0);
    private boolean internalData;

    EngineInputRecord(SSLEngineImpl engine) {
        this.engine = engine;
    }

    @Override
    byte contentType() {
        if (this.internalData) {
            return super.contentType();
        }
        return 23;
    }

    int bytesInCompletePacket(ByteBuffer buffer) throws SSLException {
        if (buffer.remaining() < 5) {
            return -1;
        }
        int pos = buffer.position();
        byte byteZero = buffer.get(pos);
        int len = 0;
        if (this.formatVerified || byteZero == 22 || byteZero == 21) {
            ProtocolVersion recordVersion = ProtocolVersion.valueOf(buffer.get(pos + 1), buffer.get(pos + 2));
            if (recordVersion.version < ProtocolVersion.MIN.version || recordVersion.major > ProtocolVersion.MAX.major) {
                throw new SSLException("Unsupported record version " + recordVersion);
            }
            this.formatVerified = true;
            len = ((buffer.get(pos + 3) & 0xFF) << 8) + (buffer.get(pos + 4) & 0xFF) + 5;
        } else {
            boolean isShort;
            boolean bl = isShort = (byteZero & 0x80) != 0;
            if (isShort && (buffer.get(pos + 2) == 1 || buffer.get(pos + 2) == 4)) {
                ProtocolVersion recordVersion = ProtocolVersion.valueOf(buffer.get(pos + 3), buffer.get(pos + 4));
                if ((recordVersion.version < ProtocolVersion.MIN.version || recordVersion.major > ProtocolVersion.MAX.major) && recordVersion.version != ProtocolVersion.SSL20Hello.version) {
                    throw new SSLException("Unsupported record version " + recordVersion);
                }
                byte byteOne = buffer.get(pos + 1);
                len = this.calcHelloMessageLength(isShort, byteZero, byteOne);
            } else {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
        }
        return len;
    }

    final int calcHelloMessageLength(boolean isShort, byte byteZero, byte byteOne) {
        int mask = isShort ? 127 : 63;
        int len = ((byteZero & mask) << 8) + (byteOne & 0xFF) + (isShort ? 2 : 3);
        return len;
    }

    ByteBuffer decrypt(Authenticator authenticator, CipherBox box, ByteBuffer buffer) throws BadPaddingException {
        if (this.internalData) {
            this.decrypt(authenticator, box);
            return tmpBuffer;
        }
        BadPaddingException reservedBPE = null;
        int tagLen = authenticator instanceof MAC ? ((MAC)authenticator).MAClen() : 0;
        int cipheredLength = buffer.remaining();
        if (!box.isNullCipher()) {
            try {
                int nonceSize = box.applyExplicitNonce(authenticator, this.contentType(), buffer);
                box.decrypt(buffer, tagLen);
                buffer.position(nonceSize);
            }
            catch (BadPaddingException bpe) {
                reservedBPE = bpe;
            }
        }
        if (authenticator instanceof MAC && tagLen != 0) {
            MAC signer = (MAC)authenticator;
            int macOffset = buffer.limit() - tagLen;
            if (buffer.remaining() < tagLen) {
                if (reservedBPE == null) {
                    reservedBPE = new BadPaddingException("bad record");
                }
                macOffset = cipheredLength - tagLen;
                buffer.limit(cipheredLength);
            }
            if (EngineInputRecord.checkMacTags(this.contentType(), buffer, signer, false) && reservedBPE == null) {
                reservedBPE = new BadPaddingException("bad record MAC");
            }
            if (box.isCBCMode()) {
                int remainingLen = EngineInputRecord.calculateRemainingLen(signer, cipheredLength, macOffset);
                if (remainingLen > this.buf.length) {
                    throw new RuntimeException("Internal buffer capacity error");
                }
                EngineInputRecord.checkMacTags(this.contentType(), this.buf, 0, remainingLen, signer, true);
            }
            buffer.limit(macOffset);
        }
        if (reservedBPE != null) {
            throw reservedBPE;
        }
        return buffer.slice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkMacTags(byte contentType, ByteBuffer buffer, MAC signer, boolean isSimulated) {
        int position = buffer.position();
        int tagLen = signer.MAClen();
        int limitedLength = buffer.limit();
        int macData = limitedLength - tagLen;
        buffer.limit(macData);
        byte[] hash = signer.compute(contentType, buffer, isSimulated);
        if (hash == null || tagLen != hash.length) {
            throw new RuntimeException("Internal MAC error");
        }
        buffer.position(macData);
        buffer.limit(limitedLength);
        try {
            int[] results = EngineInputRecord.compareMacTags(buffer, hash);
            boolean bl = results[0] != 0;
            return bl;
        }
        finally {
            buffer.position(position);
            buffer.limit(macData);
        }
    }

    private static int[] compareMacTags(ByteBuffer buffer, byte[] tag) {
        int[] results = new int[]{0, 0};
        for (int i = 0; i < tag.length; ++i) {
            if (buffer.get() != tag[i]) {
                results[0] = results[0] + 1;
                continue;
            }
            results[1] = results[1] + 1;
        }
        return results;
    }

    @Override
    void writeBuffer(OutputStream out, byte[] buffer, int off, int len) throws IOException {
        ByteBuffer netBuffer = (ByteBuffer)ByteBuffer.allocate(len).put(buffer, 0, len).flip();
        this.engine.writer.putOutboundDataSync(netBuffer);
    }

    ByteBuffer read(ByteBuffer srcBuffer) throws IOException {
        if (!this.formatVerified || srcBuffer.get(srcBuffer.position()) != 23) {
            this.internalData = true;
            this.read(new ByteBufferInputStream(srcBuffer), null);
            return tmpBuffer;
        }
        this.internalData = false;
        int srcPos = srcBuffer.position();
        int srcLim = srcBuffer.limit();
        ProtocolVersion recordVersion = ProtocolVersion.valueOf(srcBuffer.get(srcPos + 1), srcBuffer.get(srcPos + 2));
        if (recordVersion.version < ProtocolVersion.MIN.version || recordVersion.major > ProtocolVersion.MAX.major) {
            throw new SSLException("Unsupported record version " + recordVersion);
        }
        int len = this.bytesInCompletePacket(srcBuffer);
        assert (len > 0);
        if (Debugger.datashaker.isDebugEnabled()) {
            try {
                ByteBuffer data = (ByteBuffer)srcBuffer.duplicate().limit(srcPos + len);
                StringBuilder builder = new StringBuilder();
                builder.append("\n[Raw read (bb)]: length = ").append(len);
                builder.append('\n');
                builder.append((CharSequence)Hex.dump("", data));
                Debugger.datashaker.debug(builder.toString());
                builder = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        srcBuffer.position(srcPos + 5);
        srcBuffer.limit(srcPos + len);
        ByteBuffer buffer = srcBuffer.slice();
        srcBuffer.position(srcBuffer.limit());
        srcBuffer.limit(srcLim);
        return buffer;
    }
}

