/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.javax.net.ssl.GMSSLParameters;
import cfca.sadk.tls.sun.security.ssl.AlertDescription;
import cfca.sadk.tls.sun.security.ssl.AlertLevel;
import cfca.sadk.tls.sun.security.ssl.Alerts;
import cfca.sadk.tls.sun.security.ssl.AppInputStream;
import cfca.sadk.tls.sun.security.ssl.AppOutputStream;
import cfca.sadk.tls.sun.security.ssl.Authenticator;
import cfca.sadk.tls.sun.security.ssl.BaseSSLSocketImpl;
import cfca.sadk.tls.sun.security.ssl.CipherSuiteList;
import cfca.sadk.tls.sun.security.ssl.ClientHandshaker;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.Handshaker;
import cfca.sadk.tls.sun.security.ssl.InputRecord;
import cfca.sadk.tls.sun.security.ssl.OutputRecord;
import cfca.sadk.tls.sun.security.ssl.ProtocolList;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.SSLContextImpl;
import cfca.sadk.tls.sun.security.ssl.SSLSessionImpl;
import cfca.sadk.tls.sun.security.ssl.ServerHandshaker;
import cfca.sadk.tls.sun.security.ssl.manager.GMHosts;
import cfca.sadk.tls.sun.security.ssl.sec.CipherBox;
import cfca.sadk.tls.sun.security.ssl.sec.MAC;
import cfca.sadk.tls.sun.security.validator.GMAlgorithmConstraints;
import cfca.sadk.tls.sun.security.validator.GMCertificateException;
import cfca.sadk.tls.sun.security.validator.GMCertificateExpiredException;
import cfca.sadk.tls.sun.security.validator.GMCertificateNotYetValidException;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.BadPaddingException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;

public final class SSLSocketImpl
extends BaseSSLSocketImpl {
    private static final int cs_START = 0;
    private static final int cs_HANDSHAKE = 1;
    private static final int cs_DATA = 2;
    private static final int cs_RENEGOTIATE = 3;
    private static final int cs_ERROR = 4;
    private static final int cs_SENT_CLOSE = 5;
    private static final int cs_CLOSED = 6;
    private static final int cs_APP_CLOSED = 7;
    private volatile int connectionState;
    private boolean expectingFinished;
    private SSLException closeReason;
    private byte doClientAuth;
    private boolean roleIsServer;
    private boolean enableSessionCreation = true;
    private String host;
    private boolean autoClose = true;
    private AccessControlContext acc;
    private CipherSuiteList enabledCipherSuites;
    private String identificationProtocol = null;
    private GMAlgorithmConstraints algorithmConstraints = null;
    private final Object handshakeLock = new Object();
    final ReentrantLock writeLock = new ReentrantLock();
    private final Object readLock = new Object();
    private InputRecord inrec;
    private Authenticator readAuthenticator;
    private Authenticator writeAuthenticator;
    private CipherBox readCipher;
    private CipherBox writeCipher;
    private boolean secureRenegotiation;
    private byte[] clientVerifyData;
    private byte[] serverVerifyData;
    private SSLContextImpl sslContext;
    private Handshaker handshaker;
    private SSLSessionImpl sess;
    private volatile SSLSessionImpl handshakeSession;
    private HashMap<HandshakeCompletedListener, AccessControlContext> handshakeListeners;
    private InputStream sockInput;
    private OutputStream sockOutput;
    private AppInputStream input;
    private AppOutputStream output;
    private ProtocolList enabledProtocols;
    private ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT;
    private boolean isFirstAppOutputRecord = true;
    private ByteArrayOutputStream heldRecordBuffer = null;
    private boolean preferLocalCipherSuites = false;

    SSLSocketImpl(SSLContextImpl context, String host, int port) throws IOException, UnknownHostException {
        this.host = this.checkHost(host);
        Debugger.handshaker.debug("SSLSocketImpl(context,host={},port={}) running...", (Object)host, (Object)port);
        this.init(context, false);
        Debugger.handshaker.debug("SSLSocketImpl init okay.");
        SocketAddress socketAddress = GMHosts.INSTANCE.getAddr(host, port);
        this.connect(socketAddress, 0);
        Debugger.handshaker.debug("SSLSocketImpl connect finished.");
    }

    SSLSocketImpl(SSLContextImpl context, InetAddress host, int port) throws IOException {
        Debugger.handshaker.debug("SSLSocketImpl(context,InetAddress={},port={}) running...", (Object)host, (Object)port);
        this.init(context, false);
        Debugger.handshaker.debug("SSLSocketImpl init okay.");
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        this.connect(socketAddress, 0);
        Debugger.handshaker.debug("SSLSocketImpl connect finished.");
    }

    SSLSocketImpl(SSLContextImpl context, String host, int port, InetAddress localAddr, int localPort) throws IOException, UnknownHostException {
        this.host = this.checkHost(host);
        Debugger.handshaker.debug("SSLSocketImpl(context,host={},port={},localAddr,localPort) running...", (Object)host, (Object)port);
        this.init(context, false);
        Debugger.handshaker.debug("SSLSocketImpl init okay.bind->localAddr->{},localPort->{}", (Object)localAddr, (Object)localPort);
        this.bind(new InetSocketAddress(localAddr, localPort));
        Debugger.handshaker.debug("SSLSocketImpl bind okay");
        SocketAddress socketAddress = GMHosts.INSTANCE.getAddr(host, port);
        this.connect(socketAddress, 0);
        Debugger.handshaker.debug("SSLSocketImpl connect finished.");
    }

    SSLSocketImpl(SSLContextImpl context, InetAddress host, int port, InetAddress localAddr, int localPort) throws IOException {
        Debugger.handshaker.debug("SSLSocketImpl(context,InetAddress={},port={},localAddr,localPort) running...", (Object)host, (Object)port);
        this.init(context, false);
        Debugger.handshaker.debug("SSLSocketImpl init okay.bind->localAddr->{},localPort->{}", (Object)localAddr, (Object)localPort);
        this.bind(new InetSocketAddress(localAddr, localPort));
        Debugger.handshaker.debug("SSLSocketImpl bind okay");
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        this.connect(socketAddress, 0);
        Debugger.handshaker.debug("SSLSocketImpl connect finished.");
    }

    SSLSocketImpl(SSLContextImpl context, boolean serverMode, CipherSuiteList suites, byte clientAuth, boolean sessionCreation, ProtocolList protocols, String identificationProtocol, GMAlgorithmConstraints algorithmConstraints, boolean preferLocalCipherSuites) throws IOException {
        this.doClientAuth = clientAuth;
        this.enableSessionCreation = sessionCreation;
        this.identificationProtocol = identificationProtocol;
        this.algorithmConstraints = algorithmConstraints;
        this.preferLocalCipherSuites = preferLocalCipherSuites;
        Debugger.handshaker.debug("SSLSocketImpl(context,boolean,...) running...");
        Debugger.handshaker.debug("SSLSocketImpl#serverMode->{},clientAuth->{},sessionCreation->{}", new Object[]{serverMode, clientAuth, sessionCreation});
        this.init(context, serverMode);
        Debugger.handshaker.debug("SSLSocketImpl finished.");
        this.enabledCipherSuites = suites;
        this.enabledProtocols = protocols;
    }

    SSLSocketImpl(SSLContextImpl context) {
        Debugger.handshaker.debug("SSLSocketImpl() running...");
        this.init(context, false);
        Debugger.handshaker.debug("SSLSocketImpl() finished.");
    }

    SSLSocketImpl(SSLContextImpl context, Socket sock, String host, int port, boolean autoClose) throws IOException {
        super(sock);
        this.host = this.checkHost(host);
        if (!sock.isConnected()) {
            throw new SocketException("Underlying socket is not connected");
        }
        Debugger.handshaker.debug("SSLSocketImpl(context,Socket,host={},port={},autoClose) running...", (Object)host, (Object)port);
        this.init(context, false);
        Debugger.handshaker.debug("SSLSocketImpl init okay.doneConnect->autoClose->{}", (Object)autoClose);
        this.autoClose = autoClose;
        this.doneConnect();
        Debugger.handshaker.debug("SSLSocketImpl doneConnect finished.");
    }

    SSLSocketImpl(SSLContextImpl context, Socket sock, InputStream consumed, boolean autoClose) throws IOException {
        super(sock, consumed);
        if (!sock.isConnected()) {
            throw new SocketException("Underlying socket is not connected");
        }
        Debugger.handshaker.debug("SSLSocketImpl(context,Socket,consumed,autoClose) running...");
        this.init(context, true);
        Debugger.handshaker.debug("SSLSocketImpl init okay.doneConnect->autoClose->{}", (Object)autoClose);
        this.autoClose = autoClose;
        this.doneConnect();
        Debugger.handshaker.debug("SSLSocketImpl doneConnect finished.");
    }

    private String checkHost(String host) throws UnknownHostException {
        if (host == null) {
            throw new UnknownHostException("host==null");
        }
        return host;
    }

    private void init(SSLContextImpl context, boolean isServer) {
        Debugger.handshaker.debug("SSLSocketImpl init->isServer->{}", (Object)isServer);
        this.sslContext = context;
        this.sess = SSLSessionImpl.nullSession;
        this.handshakeSession = null;
        this.roleIsServer = isServer;
        this.connectionState = 0;
        this.readCipher = CipherBox.NULL;
        this.readAuthenticator = MAC.NULL;
        this.writeCipher = CipherBox.NULL;
        this.writeAuthenticator = MAC.NULL;
        this.secureRenegotiation = false;
        this.clientVerifyData = new byte[0];
        this.serverVerifyData = new byte[0];
        this.enabledCipherSuites = this.sslContext.getDefaultCipherSuiteList(this.roleIsServer);
        this.enabledProtocols = this.sslContext.getDefaultProtocolList(this.roleIsServer);
        this.inrec = null;
        this.acc = AccessController.getContext();
        this.input = new AppInputStream(this);
        this.output = new AppOutputStream(this);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        Debugger.handshaker.debug("SSLSocketImpl connect->timeout->{}", (Object)timeout);
        if (this.isLayered()) {
            throw new SocketException("Already connected");
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new SocketException("Cannot handle non-Inet socket addresses.");
        }
        Debugger.handshaker.debug("connect endpoint={} running: localPort={}, timeout={}", new Object[]{endpoint, this.getLocalPort(), timeout});
        super.connect(endpoint, timeout);
        Debugger.handshaker.debug("connect endpoint={} finished: isConnected={}", (Object)endpoint, (Object)this.isConnected());
        this.doneConnect();
    }

    void doneConnect() throws IOException {
        this.sockInput = super.getInputStream();
        this.sockOutput = super.getOutputStream();
        this.initHandshaker();
    }

    private synchronized int getConnectionState() {
        return this.connectionState;
    }

    private synchronized void setConnectionState(int state) {
        this.connectionState = state;
    }

    AccessControlContext getAcc() {
        return this.acc;
    }

    void writeRecord(OutputRecord r) throws IOException {
        this.writeRecord(r, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRecord(OutputRecord r, boolean holdRecord) throws IOException {
        block14: while (r.contentType() == 23) {
            switch (this.getConnectionState()) {
                case 1: {
                    this.performInitialHandshake();
                    continue block14;
                }
                case 2: 
                case 3: {
                    break block14;
                }
                case 4: {
                    this.fatal(AlertDescription.alert_close_notify, "error while writing to socket");
                    continue block14;
                }
                case 5: 
                case 6: 
                case 7: {
                    if (this.closeReason != null) {
                        throw this.closeReason;
                    }
                    throw new SocketException("Socket closed");
                }
                default: {
                    throw new SSLProtocolException("State error, send app data");
                }
            }
        }
        if (!r.isEmpty()) {
            if (r.isAlert(AlertDescription.alert_close_notify) && this.getSoLinger() >= 0) {
                boolean interrupted;
                block24: {
                    interrupted = Thread.interrupted();
                    try {
                        if (this.writeLock.tryLock(this.getSoLinger(), TimeUnit.SECONDS)) {
                            try {
                                this.writeRecordInternal(r, holdRecord);
                                break block24;
                            }
                            finally {
                                this.writeLock.unlock();
                            }
                        }
                        SSLException ssle = new SSLException("SO_LINGER timeout, close_notify message cannot be sent.");
                        if (this.isLayered() && !this.autoClose) {
                            this.fatal(null, ssle);
                        } else if (Debugger.datashaker.isDebugEnabled()) {
                            Debugger.datashaker.debug("received Exception: ", (Throwable)ssle);
                        }
                        this.sess.invalidate();
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            } else {
                this.writeLock.lock();
                try {
                    this.writeRecordInternal(r, holdRecord);
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
    }

    private void writeRecordInternal(OutputRecord r, boolean holdRecord) throws IOException {
        r.encrypt(this.writeAuthenticator, this.writeCipher);
        if (holdRecord) {
            if (this.getTcpNoDelay()) {
                holdRecord = false;
            } else if (this.heldRecordBuffer == null) {
                this.heldRecordBuffer = new ByteArrayOutputStream(40);
            }
        }
        r.write(this.sockOutput, holdRecord, this.heldRecordBuffer);
        if (this.connectionState < 4) {
            this.checkSequenceNumber(this.writeAuthenticator, r.contentType());
        }
        if (this.isFirstAppOutputRecord && r.contentType() == 23) {
            this.isFirstAppOutputRecord = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needToSplitPayload() {
        this.writeLock.lock();
        try {
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void readDataRecord(InputRecord r) throws IOException {
        if (this.getConnectionState() == 1) {
            this.performInitialHandshake();
        }
        this.readRecord(r, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRecord(InputRecord r, boolean needAppData) throws IOException {
        Debugger.handshaker.debug("readRecord running...");
        Object object = this.readLock;
        synchronized (object) {
            int state;
            block19: while ((state = this.getConnectionState()) != 6 && state != 4 && state != 7) {
                try {
                    r.setAppDataValid(false);
                    r.read(this.sockInput, this.sockOutput);
                }
                catch (SSLProtocolException e) {
                    try {
                        this.fatal(AlertDescription.alert_unexpected_message, e);
                    }
                    catch (IOException x) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (EOFException eof) {
                    boolean rethrow;
                    boolean handshaking = this.getConnectionState() <= 1;
                    boolean bl = rethrow = requireCloseNotify || handshaking;
                    if (Debugger.datashaker.isDebugEnabled()) {
                        Debugger.datashaker.debug("received EOFException: " + (rethrow ? "error" : "ignored"));
                    }
                    if (rethrow) {
                        SSLException e = handshaking ? new SSLHandshakeException("Remote host closed connection during handshake") : new SSLProtocolException("Remote host closed connection incorrectly");
                        e.initCause(eof);
                        throw e;
                    }
                    this.closeInternal(false);
                    continue;
                }
                try {
                    r.decrypt(this.readAuthenticator, this.readCipher);
                }
                catch (BadPaddingException e) {
                    AlertDescription alertType = r.contentType() == 22 ? AlertDescription.alert_handshake_failure : AlertDescription.alert_bad_record_mac;
                    this.fatal(alertType, e.getMessage(), e);
                }
                SSLSocketImpl sSLSocketImpl = this;
                synchronized (sSLSocketImpl) {
                    switch (r.contentType()) {
                        case 22: {
                            this.initHandshaker();
                            if (!this.handshaker.activated()) {
                                if (this.connectionState == 3) {
                                    this.handshaker.activate(this.protocolVersion);
                                } else {
                                    this.handshaker.activate(null);
                                }
                            }
                            this.handshaker.process_record(r, this.expectingFinished);
                            this.expectingFinished = false;
                            if (this.handshaker.invalidated) {
                                this.handshaker = null;
                                if (this.connectionState == 3) {
                                    this.connectionState = 2;
                                }
                            } else if (this.handshaker.isDone()) {
                                this.secureRenegotiation = this.handshaker.isSecureRenegotiation();
                                this.clientVerifyData = this.handshaker.getClientVerifyData();
                                this.serverVerifyData = this.handshaker.getServerVerifyData();
                                this.sess = this.handshaker.getSession();
                                this.handshakeSession = null;
                                this.handshaker = null;
                                this.connectionState = 2;
                                if (this.handshakeListeners != null) {
                                    HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.sess);
                                    NotifyHandshakeThread t = new NotifyHandshakeThread(this.handshakeListeners.entrySet(), event);
                                    t.start();
                                }
                            }
                            if (!needAppData && this.connectionState == 2) break;
                            continue block19;
                        }
                        case 23: {
                            if (this.connectionState != 2 && this.connectionState != 3 && this.connectionState != 5) {
                                throw new SSLProtocolException("Data received in non-data state: " + this.connectionState);
                            }
                            if (this.expectingFinished) {
                                throw new SSLProtocolException("Expecting finished message, received data");
                            }
                            if (!needAppData) {
                                throw new SSLException("Discarding app data");
                            }
                            r.setAppDataValid(true);
                            break;
                        }
                        case 21: {
                            this.recvAlert(r);
                            continue block19;
                        }
                        case 20: {
                            if (this.connectionState != 1 && this.connectionState != 3 || r.available() != 1 || r.read() != 1) {
                                this.fatal(AlertDescription.alert_unexpected_message, "illegal change cipher spec msg, state = " + this.connectionState);
                            }
                            this.changeReadCiphers();
                            this.expectingFinished = true;
                            continue block19;
                        }
                        default: {
                            if (Debugger.datashaker.isDebugEnabled()) {
                                Debugger.datashaker.debug("Received record type: " + r.contentType());
                            }
                            continue block19;
                        }
                    }
                    if (this.connectionState < 4) {
                        this.checkSequenceNumber(this.readAuthenticator, r.contentType());
                    }
                    Debugger.handshaker.debug("readRecord finished#1.");
                    return;
                }
            }
            r.close();
            Debugger.handshaker.debug("readRecord finished#2.");
            return;
        }
    }

    private void checkSequenceNumber(Authenticator authenticator, byte type) throws IOException {
        if (this.connectionState >= 4 || authenticator == MAC.NULL) {
            return;
        }
        if (authenticator.seqNumOverflow()) {
            Debugger.datashaker.debug("sequence number extremely close to overflow (2^64-1 packets). Closing connection.");
            this.fatal(AlertDescription.alert_handshake_failure, "sequence number overflow");
        }
        if (type != 22 && authenticator.seqNumIsHuge()) {
            Debugger.datashaker.debug("request renegotiation to avoid sequence number overflow");
            this.startHandshake();
        }
    }

    AppInputStream getAppInputStream() {
        return this.input;
    }

    AppOutputStream getAppOutputStream() {
        return this.output;
    }

    private void initHandshaker() {
        Debugger.handshaker.debug("initHandshaker running...");
        switch (this.connectionState) {
            case 0: 
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                return;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
        this.connectionState = this.connectionState == 0 ? 1 : 3;
        if (this.roleIsServer) {
            Debugger.handshaker.debug("initHandshaker->ServerHandshaker");
            this.handshaker = new ServerHandshaker(this, this.sslContext, this.enabledProtocols, this.doClientAuth, this.protocolVersion, this.connectionState == 1, this.secureRenegotiation, this.clientVerifyData, this.serverVerifyData);
            this.handshaker.setUseCipherSuitesOrder(this.preferLocalCipherSuites);
        } else {
            Debugger.handshaker.debug("initHandshaker->ClientHandshaker");
            this.handshaker = new ClientHandshaker(this, this.sslContext, this.enabledProtocols, this.protocolVersion, this.connectionState == 1, this.secureRenegotiation, this.clientVerifyData, this.serverVerifyData);
        }
        this.handshaker.setEnabledCipherSuites(this.enabledCipherSuites);
        this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
        Debugger.handshaker.debug("initHandshaker finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInitialHandshake() throws IOException {
        Debugger.handshaker.debug("performInitialHandshake() running...");
        long startTime = System.currentTimeMillis();
        Object object = this.handshakeLock;
        synchronized (object) {
            if (this.getConnectionState() == 1) {
                this.kickstartHandshake();
                if (this.inrec == null) {
                    this.inrec = new InputRecord();
                    this.inrec.setHandshakeHash(this.input.record.getHandshakeHash());
                    this.inrec.setHelloVersion(this.input.record.getHelloVersion());
                    this.inrec.enableFormatChecks();
                }
                this.readRecord(this.inrec, false);
                this.inrec = null;
            }
        }
        long costTime = System.currentTimeMillis() - startTime;
        Debugger.handshaker.debug("performInitialHandshake() finished.costTime->{}", (Object)costTime);
        if (costTime > 1000L) {
            Debugger.handshaker.warn("performInitialHandshake() finished.costTime->{}", (Object)costTime);
        }
    }

    @Override
    public void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    private void startHandshake(boolean resumable) throws IOException {
        Debugger.handshaker.debug("startHandshake(resumable->{}) running...", (Object)resumable);
        this.checkWrite();
        try {
            if (this.getConnectionState() == 1) {
                this.performInitialHandshake();
            } else {
                this.kickstartHandshake();
            }
        }
        catch (Exception e) {
            this.handleException(e, resumable);
        }
        Debugger.handshaker.debug("startHandshake finished.");
    }

    private synchronized void kickstartHandshake() throws IOException {
        Debugger.handshaker.debug("kickstartHandshake() running...");
        long startTime = System.currentTimeMillis();
        switch (this.connectionState) {
            case 1: {
                break;
            }
            case 2: {
                if (!this.secureRenegotiation && !Handshaker.allowUnsafeRenegotiation) {
                    throw new SSLHandshakeException("Insecure renegotiation is not allowed");
                }
                if (!this.secureRenegotiation) {
                    Debugger.datashaker.debug("Warning: Using insecure renegotiation");
                }
                this.initHandshaker();
                break;
            }
            case 3: {
                Debugger.handshaker.debug("kickstartHandshake() skipped for handshaking already in progress.");
                return;
            }
            case 0: {
                throw new SocketException("handshaking attempted on unconnected socket");
            }
            default: {
                throw new SocketException("connection is closed");
            }
        }
        if (!this.handshaker.activated()) {
            if (this.connectionState == 3) {
                this.handshaker.activate(this.protocolVersion);
            } else {
                this.handshaker.activate(null);
            }
            if (this.handshaker instanceof ClientHandshaker) {
                Debugger.handshaker.debug("kickstart(send client hello) running...");
                this.handshaker.kickstart();
                Debugger.handshaker.debug("kickstart(send client hello) finished.");
            } else if (this.connectionState != 1) {
                Debugger.handshaker.debug("kickstart(renegotiate) running...");
                this.handshaker.kickstart();
                this.handshaker.handshakeHash.reset();
                Debugger.handshaker.debug("kickstart(renegotiate) finished.");
            }
        }
        long costTime = System.currentTimeMillis() - startTime;
        Debugger.handshaker.debug("kickstartHandshake() finished.costTime->{}", (Object)costTime);
        if (costTime > 1000L) {
            Debugger.handshaker.warn("kickstartHandshake() finished.costTime->{}", (Object)costTime);
        }
    }

    @Override
    public boolean isClosed() {
        return this.connectionState == 7;
    }

    boolean checkEOF() throws IOException {
        switch (this.getConnectionState()) {
            case 0: {
                throw new SocketException("Socket is not connected");
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
            case 7: {
                throw new SocketException("Socket is closed");
            }
        }
        if (this.closeReason == null) {
            return true;
        }
        SSLException e = new SSLException("Connection has been shutdown: " + this.closeReason);
        e.initCause(this.closeReason);
        throw e;
    }

    void checkWrite() throws IOException {
        if (this.checkEOF() || this.getConnectionState() == 5) {
            throw new SocketException("Connection closed by remote host");
        }
    }

    protected void closeSocket() throws IOException {
        Debugger.datashaker.debug("called closeSocket()");
        super.close();
    }

    private void closeSocket(boolean selfInitiated) throws IOException {
        Debugger.datashaker.debug("called closeSocket({})", (Object)selfInitiated);
        if (!this.isLayered() || this.autoClose) {
            super.close();
        } else if (selfInitiated) {
            this.waitForClose(false);
        }
    }

    @Override
    public void close() throws IOException {
        Debugger.datashaker.debug("called close()");
        this.closeInternal(true);
        this.setConnectionState(7);
    }

    /*
     * Exception decompiling
     */
    private void closeInternal(boolean selfInitiated) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 25[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void waitForClose(boolean rethrow) throws IOException {
        block7: {
            if (Debugger.datashaker.isDebugEnabled()) {
                Debugger.datashaker.debug("waiting for close_notify or alert: state ={}", (Object)this.getConnectionState());
            }
            try {
                int state;
                while ((state = this.getConnectionState()) != 6 && state != 4 && state != 7) {
                    if (this.inrec == null) {
                        this.inrec = new InputRecord();
                    }
                    try {
                        this.readRecord(this.inrec, true);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {}
                }
                this.inrec = null;
            }
            catch (IOException e) {
                Debugger.datashaker.debug("Exception while waiting for close", (Throwable)e);
                if (!rethrow) break block7;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeCiphers() {
        Object object = this.readLock;
        synchronized (object) {
            this.readCipher.dispose();
        }
        this.writeLock.lock();
        try {
            this.writeCipher.dispose();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void handleException(Exception e) throws IOException {
        this.handleException(e, true);
    }

    private synchronized void handleException(Exception e, boolean resumable) throws IOException {
        Debugger.datashaker.debug("handling exception", (Throwable)e);
        if (e instanceof InterruptedIOException && resumable) {
            throw (IOException)e;
        }
        if (this.closeReason != null) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw Alerts.getSSLException(AlertDescription.alert_internal_error, e, "Unexpected exception");
        }
        boolean isSSLException = e instanceof SSLException;
        if (!isSSLException && e instanceof IOException) {
            try {
                this.fatal(AlertDescription.alert_unexpected_message, e);
            }
            catch (IOException ee) {
                // empty catch block
            }
            throw (IOException)e;
        }
        AlertDescription alertType = isSSLException ? (e instanceof SSLHandshakeException ? AlertDescription.alert_handshake_failure : AlertDescription.alert_unexpected_message) : AlertDescription.alert_internal_error;
        this.fatal(alertType, e);
    }

    void warning(AlertDescription description) {
        this.sendAlert(AlertLevel.alert_warning, description);
    }

    synchronized void fatal(AlertDescription description, String diagnostic) throws IOException {
        this.fatal(description, diagnostic, null);
    }

    synchronized void fatal(AlertDescription description, Throwable cause) throws IOException {
        this.fatal(description, null, cause);
    }

    synchronized void fatal(AlertDescription description, String diagnostic, Throwable cause) throws IOException {
        if (this.input != null && this.input.record != null) {
            this.input.record.close();
        }
        this.sess.invalidate();
        if (this.handshakeSession != null) {
            this.handshakeSession.invalidate();
        }
        int oldState = this.connectionState;
        if (this.connectionState < 4) {
            this.connectionState = 4;
        }
        if (this.closeReason == null) {
            if (oldState == 1) {
                this.sockInput.skip(this.sockInput.available());
            }
            if (cause instanceof SSLException) {
                this.closeReason = (SSLException)cause;
            } else if (cause instanceof GMCertificateNotYetValidException) {
                description = AlertDescription.alert_bad_certificate;
                this.closeReason = Alerts.getSSLException(description, cause, diagnostic);
            } else if (cause instanceof GMCertificateExpiredException) {
                description = AlertDescription.alert_certificate_expired;
                this.closeReason = Alerts.getSSLException(description, cause, diagnostic);
            } else if (cause instanceof GMCertificateException) {
                description = AlertDescription.alert_bad_certificate;
                this.closeReason = Alerts.getSSLException(description, cause, diagnostic);
            } else {
                this.closeReason = Alerts.getSSLException(description, cause, diagnostic);
            }
            if (description != null) {
                this.sendAlert(AlertLevel.alert_fatal, description);
            }
        }
        this.closeSocket();
        if (this.connectionState < 6) {
            this.connectionState = oldState == 7 ? 7 : 6;
            this.readCipher.dispose();
            this.writeCipher.dispose();
        }
        throw this.closeReason;
    }

    private void recvAlert(InputRecord r) throws IOException {
        AlertDescription description;
        AlertLevel level = AlertLevel.find((byte)r.read());
        byte code = (byte)r.read();
        if (code == -1) {
            this.fatal(AlertDescription.alert_illegal_parameter, "Short alert message");
        }
        if ((description = AlertDescription.find(code)) == null) {
            this.fatal(AlertDescription.alert_illegal_parameter, "<UNKNOWN ALERT: " + (code & 0xFF) + ">");
        }
        Debugger.debug("RECV", this.protocolVersion, level, description);
        if (level == AlertLevel.alert_warning) {
            if (description == AlertDescription.alert_close_notify) {
                if (this.connectionState == 1) {
                    this.fatal(AlertDescription.alert_unexpected_message, "Received close_notify during handshake");
                } else {
                    this.closeInternal(false);
                }
            } else if (this.handshaker != null) {
                this.handshaker.handshakeAlert(description);
            }
        } else {
            String reason = "Received fatal alert: " + Alerts.alertDescription(description);
            if (this.closeReason == null) {
                this.closeReason = Alerts.getSSLException(description, reason);
            }
            this.fatal(AlertDescription.alert_unexpected_message, reason);
        }
    }

    private void sendAlert(AlertLevel level, AlertDescription description) {
        if (this.connectionState >= 5) {
            return;
        }
        if (!(this.connectionState != 1 || this.handshaker != null && this.handshaker.started())) {
            return;
        }
        OutputRecord r = new OutputRecord(21);
        r.setVersion(this.protocolVersion);
        Debugger.debug("SEND", this.protocolVersion, level, description);
        r.write(level.level);
        r.write(description.code);
        try {
            this.writeRecord(r);
        }
        catch (IOException e) {
            Debugger.datashaker.debug("Exception sending alert:", (Throwable)e);
        }
    }

    private void changeReadCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        CipherBox oldCipher = this.readCipher;
        try {
            this.readCipher = this.handshaker.newReadCipher();
            this.readAuthenticator = this.handshaker.newReadAuthenticator();
        }
        catch (GeneralSecurityException e) {
            throw new SSLException("Algorithm missing:  ", e);
        }
        oldCipher.dispose();
    }

    void changeWriteCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        CipherBox oldCipher = this.writeCipher;
        try {
            this.writeCipher = this.handshaker.newWriteCipher();
            this.writeAuthenticator = this.handshaker.newWriteAuthenticator();
        }
        catch (GeneralSecurityException e) {
            throw new SSLException("Algorithm missing:  ", e);
        }
        oldCipher.dispose();
        this.isFirstAppOutputRecord = true;
    }

    synchronized void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.output.record.setVersion(protocolVersion);
    }

    synchronized String getHost() {
        if (this.host == null || this.host.length() == 0) {
            Debugger.handshaker.debug("SSLSocketImpl->GetHostName running...");
            InetAddress addr = this.getInetAddress();
            Debugger.handshaker.debug("SSLSocketImpl->address={}", (Object)addr);
            String hostname = GMHosts.INSTANCE.getHost(addr.getHostAddress());
            Debugger.handshaker.debug("SSLSocketImpl->cache hostname={}", (Object)hostname);
            if (hostname == null) {
                long strTime = System.currentTimeMillis();
                hostname = this.getInetAddress().getHostName();
                long runTime = System.currentTimeMillis() - strTime;
                Debugger.handshaker.debug("SSLSocketImpl->GetHostName={},callTime={}", (Object)hostname, (Object)runTime);
            }
            this.host = hostname;
        } else {
            Debugger.handshaker.debug("SSLSocketImpl->GetHostName skipped.{}", (Object)this.host);
        }
        return this.host;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.connectionState == 0) {
            throw new SocketException("Socket is not connected");
        }
        return this.input;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.connectionState == 0) {
            throw new SocketException("Socket is not connected");
        }
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLSession getSession() {
        if (this.getConnectionState() == 1) {
            try {
                this.startHandshake(false);
            }
            catch (IOException e) {
                Debugger.datashaker.debug("IOException in getSession():", (Throwable)e);
            }
        }
        SSLSocketImpl sSLSocketImpl = this;
        synchronized (sSLSocketImpl) {
            return this.sess;
        }
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    synchronized void setHandshakeSession(SSLSessionImpl session) {
        this.handshakeSession = session;
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
        }
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean flag) {
        this.doClientAuth = (byte)(flag ? 2 : 0);
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.activated()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    @Override
    public synchronized void setWantClientAuth(boolean flag) {
        byte by = this.doClientAuth = flag ? (byte)1 : 0;
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.activated()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    @Override
    public synchronized void setUseClientMode(boolean flag) {
        switch (this.connectionState) {
            case 0: {
                if (this.roleIsServer != !flag && this.sslContext.isDefaultProtocolList(this.enabledProtocols)) {
                    this.enabledProtocols = this.sslContext.getDefaultProtocolList(!flag);
                }
                this.roleIsServer = !flag;
                break;
            }
            case 1: {
                assert (this.handshaker != null);
                if (!this.handshaker.activated()) {
                    if (this.roleIsServer != !flag && this.sslContext.isDefaultProtocolList(this.enabledProtocols)) {
                        this.enabledProtocols = this.sslContext.getDefaultProtocolList(!flag);
                    }
                    this.roleIsServer = !flag;
                    this.connectionState = 0;
                    this.initHandshaker();
                    break;
                }
            }
            default: {
                Debugger.datashaker.debug("setUseClientMode() invoked in state ={}", (Object)this.connectionState);
                throw new IllegalArgumentException("Cannot change mode after SSL traffic has started");
            }
        }
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return !this.roleIsServer;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslContext.getSupportedCipherSuiteList().toStringArray();
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.enabledCipherSuites = new CipherSuiteList(suites);
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setEnabledCipherSuites(this.enabledCipherSuites);
        }
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.sslContext.getSuportedProtocolList().toStringArray();
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = new ProtocolList(protocols);
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setEnabledProtocols(this.enabledProtocols);
        }
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        Debugger.datashaker.debug("setSoTimeout({}) called", (Object)timeout);
        super.setSoTimeout(timeout);
    }

    @Override
    public synchronized void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (this.handshakeListeners == null) {
            this.handshakeListeners = new HashMap(4);
        }
        this.handshakeListeners.put(listener, AccessController.getContext());
    }

    @Override
    public synchronized void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (this.handshakeListeners == null) {
            throw new IllegalArgumentException("no listeners");
        }
        if (this.handshakeListeners.remove(listener) == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (this.handshakeListeners.isEmpty()) {
            this.handshakeListeners = null;
        }
    }

    @Override
    public synchronized GMSSLParameters getCFCASSLParameters() {
        GMSSLParameters params = super.getCFCASSLParameters();
        params.setEndpointIdentificationAlgorithm(this.identificationProtocol);
        params.setAlgorithmConstraints(this.algorithmConstraints);
        params.setUseCipherSuitesOrder(this.preferLocalCipherSuites);
        return params;
    }

    @Override
    public synchronized void setCFCASSLParameters(GMSSLParameters params) {
        super.setCFCASSLParameters(params);
        this.identificationProtocol = params.getEndpointIdentificationAlgorithm();
        this.algorithmConstraints = params.getAlgorithmConstraints();
        this.preferLocalCipherSuites = params.getUseCipherSuitesOrder();
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.setIdentificationProtocol(this.identificationProtocol);
            this.handshaker.setAlgorithmConstraints(this.algorithmConstraints);
            if (this.roleIsServer) {
                this.handshaker.setUseCipherSuitesOrder(this.preferLocalCipherSuites);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append(Integer.toHexString(this.hashCode()));
        builder.append('[');
        builder.append(this.sess.getCipherSuite());
        builder.append(": ");
        builder.append(super.toString());
        builder.append(']');
        return builder.toString();
    }

    private static class NotifyHandshakeThread
    extends Thread {
        private Set<Map.Entry<HandshakeCompletedListener, AccessControlContext>> targets;
        private HandshakeCompletedEvent event;

        NotifyHandshakeThread(Set<Map.Entry<HandshakeCompletedListener, AccessControlContext>> entrySet, HandshakeCompletedEvent e) {
            super("HandshakeCompletedNotify-Thread");
            this.targets = new HashSet<Map.Entry<HandshakeCompletedListener, AccessControlContext>>(entrySet);
            this.event = e;
        }

        @Override
        public void run() {
            for (Map.Entry<HandshakeCompletedListener, AccessControlContext> entry : this.targets) {
                final HandshakeCompletedListener l = entry.getKey();
                AccessControlContext acc = entry.getValue();
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        l.handshakeCompleted(NotifyHandshakeThread.this.event);
                        return null;
                    }
                }, acc);
            }
        }
    }
}

