/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.validator;

import cfca.sadk.tls.sun.security.validator.GMAlgorithmConstraints;
import cfca.sadk.tls.sun.security.validator.GMCertificateExpiredException;
import cfca.sadk.tls.sun.security.validator.GMCertificateNotYetValidException;
import cfca.sadk.tls.sun.security.validator.TLSKeyUsageChecker;
import cfca.sadk.tls.sun.security.validator.TLSPKIXValidator;
import cfca.sadk.tls.sun.security.validator.TLSValidatorVariant;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

public abstract class TLSValidator {
    static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    static final String OID_KEY_USAGE = "2.5.29.15";
    static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    static final X509Certificate[] CHAIN0 = new X509Certificate[0];
    final TLSKeyUsageChecker endEntityChecker;
    final TLSValidatorVariant variant;

    TLSValidator(TLSValidatorVariant variant) {
        this.variant = variant;
        this.endEntityChecker = TLSKeyUsageChecker.getInstance(variant);
    }

    public static TLSValidator getInstance(TLSValidatorVariant variant, Collection<X509Certificate> trustedCerts) {
        return new TLSPKIXValidator(variant, trustedCerts);
    }

    public static TLSValidator getInstance(TLSValidatorVariant variant, PKIXBuilderParameters params) {
        return new TLSPKIXValidator(variant, params);
    }

    public final X509Certificate[] validate(X509Certificate[] chain, Collection<X509Certificate> additionals, GMAlgorithmConstraints constraints, Object parameter) throws CertificateException {
        if ((chain = this.engineValidate(chain, additionals, constraints)) != null && chain.length > 1) {
            this.endEntityChecker.check(chain[0], parameter);
        }
        return chain;
    }

    abstract X509Certificate[] engineValidate(X509Certificate[] var1, Collection<X509Certificate> var2, GMAlgorithmConstraints var3) throws CertificateException;

    public abstract Collection<X509Certificate> getTrustedCertificates();

    public static void validate(X509Cert cert) {
        if (cert != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            Date current = new Date();
            if (current.before(cert.getNotBefore())) {
                String message = String.format("NotYetValid SN=%s,NotBefore=%s,servTime=%s", cert.getStringSerialNumber(), dateFormat.format(cert.getNotBefore()), dateFormat.format(current));
                throw new GMCertificateNotYetValidException(message);
            }
            if (current.after(cert.getNotAfter())) {
                String message = String.format("Expired SN=%s,NotAfter=%s,servTime=%s", cert.getStringSerialNumber(), dateFormat.format(cert.getNotAfter()), dateFormat.format(current));
                throw new GMCertificateExpiredException(message);
            }
        }
    }
}

