/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.tls;

import com.nbcb.bouncycastle.crypto.Digest;
import com.nbcb.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.nbcb.bouncycastle.crypto.prng.RandomGenerator;
import com.nbcb.bouncycastle.crypto.tls.ProtocolVersion;
import com.nbcb.bouncycastle.crypto.tls.SecurityParameters;
import com.nbcb.bouncycastle.crypto.tls.TlsContext;
import com.nbcb.bouncycastle.crypto.tls.TlsSession;
import com.nbcb.bouncycastle.crypto.tls.TlsUtils;
import com.nbcb.bouncycastle.util.Times;
import java.security.SecureRandom;

abstract class AbstractTlsContext
implements TlsContext {
    private static long counter = Times.nanoTime();
    private RandomGenerator nonceRandom;
    private SecureRandom secureRandom;
    private SecurityParameters securityParameters;
    private ProtocolVersion clientVersion = null;
    private ProtocolVersion serverVersion = null;
    private TlsSession session = null;
    private Object userObject = null;

    private static synchronized long nextCounterValue() {
        return ++counter;
    }

    AbstractTlsContext(SecureRandom secureRandom, SecurityParameters securityParameters) {
        Digest d = TlsUtils.createHash((short)4);
        byte[] seed = new byte[d.getDigestSize()];
        secureRandom.nextBytes(seed);
        this.nonceRandom = new DigestRandomGenerator(d);
        this.nonceRandom.addSeedMaterial(AbstractTlsContext.nextCounterValue());
        this.nonceRandom.addSeedMaterial(Times.nanoTime());
        this.nonceRandom.addSeedMaterial(seed);
        this.secureRandom = secureRandom;
        this.securityParameters = securityParameters;
    }

    @Override
    public RandomGenerator getNonceRandomGenerator() {
        return this.nonceRandom;
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    @Override
    public SecurityParameters getSecurityParameters() {
        return this.securityParameters;
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    void setClientVersion(ProtocolVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    @Override
    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    void setServerVersion(ProtocolVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    @Override
    public TlsSession getResumableSession() {
        return this.session;
    }

    void setResumableSession(TlsSession session) {
        this.session = session;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public byte[] exportKeyingMaterial(String asciiLabel, byte[] context_value, int length) {
        if (context_value != null && !TlsUtils.isValidUint16(context_value.length)) {
            throw new IllegalArgumentException("'context_value' must have length less than 2^16 (or be null)");
        }
        SecurityParameters sp = this.getSecurityParameters();
        byte[] cr = sp.getClientRandom();
        byte[] sr = sp.getServerRandom();
        int seedLength = cr.length + sr.length;
        if (context_value != null) {
            seedLength += 2 + context_value.length;
        }
        byte[] seed = new byte[seedLength];
        int seedPos = 0;
        System.arraycopy(cr, 0, seed, seedPos, cr.length);
        System.arraycopy(sr, 0, seed, seedPos += cr.length, sr.length);
        seedPos += sr.length;
        if (context_value != null) {
            TlsUtils.writeUint16(context_value.length, seed, seedPos);
            System.arraycopy(context_value, 0, seed, seedPos += 2, context_value.length);
            seedPos += context_value.length;
        }
        if (seedPos != seedLength) {
            throw new IllegalStateException("error in calculation of seed for export");
        }
        return TlsUtils.PRF(this, sp.getMasterSecret(), asciiLabel, seed, length);
    }
}

