/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.tls;

import com.nbcb.bouncycastle.crypto.tls.AbstractTlsClient;
import com.nbcb.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import com.nbcb.bouncycastle.crypto.tls.TlsAuthentication;
import com.nbcb.bouncycastle.crypto.tls.TlsCipherFactory;
import com.nbcb.bouncycastle.crypto.tls.TlsFatalAlert;
import com.nbcb.bouncycastle.crypto.tls.TlsKeyExchange;
import com.nbcb.bouncycastle.crypto.tls.TlsPSKIdentity;
import com.nbcb.bouncycastle.crypto.tls.TlsPSKKeyExchange;
import com.nbcb.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;

public class PSKTlsClient
extends AbstractTlsClient {
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsPSKIdentity pskIdentity) {
        this(new DefaultTlsCipherFactory(), pskIdentity);
    }

    public PSKTlsClient(TlsCipherFactory cipherFactory, TlsPSKIdentity pskIdentity) {
        super(cipherFactory);
        this.pskIdentity = pskIdentity;
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49207, 49205, 178, 144};
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange) {
        return new TlsPSKKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentity, null, null, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

