/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.tls;

import com.nbcb.bouncycastle.crypto.agreement.DHStandardGroups;
import com.nbcb.bouncycastle.crypto.params.DHParameters;
import com.nbcb.bouncycastle.crypto.tls.AbstractTlsServer;
import com.nbcb.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import com.nbcb.bouncycastle.crypto.tls.TlsCipherFactory;
import com.nbcb.bouncycastle.crypto.tls.TlsCredentials;
import com.nbcb.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import com.nbcb.bouncycastle.crypto.tls.TlsFatalAlert;
import com.nbcb.bouncycastle.crypto.tls.TlsKeyExchange;
import com.nbcb.bouncycastle.crypto.tls.TlsPSKIdentityManager;
import com.nbcb.bouncycastle.crypto.tls.TlsPSKKeyExchange;
import com.nbcb.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;

public class PSKTlsServer
extends AbstractTlsServer {
    protected TlsPSKIdentityManager pskIdentityManager;

    public PSKTlsServer(TlsPSKIdentityManager pskIdentityManager) {
        this(new DefaultTlsCipherFactory(), pskIdentityManager);
    }

    public PSKTlsServer(TlsCipherFactory cipherFactory, TlsPSKIdentityManager pskIdentityManager) {
        super(cipherFactory);
        this.pskIdentityManager = pskIdentityManager;
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected DHParameters getDHParameters() {
        return DHStandardGroups.rfc7919_ffdhe2048;
    }

    @Override
    protected int[] getCipherSuites() {
        return new int[]{49207, 49205, 178, 144};
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange) {
        return new TlsPSKKeyExchange(keyExchange, this.supportedSignatureAlgorithms, null, this.pskIdentityManager, this.getDHParameters(), this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

