/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.pqc.math.linearalgebra;

import com.nbcb.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.nbcb.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import com.nbcb.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.nbcb.bouncycastle.pqc.math.linearalgebra.RandUtils;
import java.security.SecureRandom;

public class Permutation {
    private int[] perm;

    public Permutation(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.perm = new int[n];
        for (int i = n - 1; i >= 0; --i) {
            this.perm[i] = i;
        }
    }

    public Permutation(int[] perm) {
        if (!this.isPermutation(perm)) {
            throw new IllegalArgumentException("array is not a permutation vector");
        }
        this.perm = IntUtils.clone(perm);
    }

    public Permutation(byte[] enc) {
        int size;
        if (enc.length <= 4) {
            throw new IllegalArgumentException("invalid encoding");
        }
        int n = LittleEndianConversions.OS2IP(enc, 0);
        if (enc.length != 4 + n * (size = IntegerFunctions.ceilLog256(n - 1))) {
            throw new IllegalArgumentException("invalid encoding");
        }
        this.perm = new int[n];
        for (int i = 0; i < n; ++i) {
            this.perm[i] = LittleEndianConversions.OS2IP(enc, 4 + i * size, size);
        }
        if (!this.isPermutation(this.perm)) {
            throw new IllegalArgumentException("invalid encoding");
        }
    }

    public Permutation(int n, SecureRandom sr) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.perm = new int[n];
        int[] help = new int[n];
        for (int i = 0; i < n; ++i) {
            help[i] = i;
        }
        int k = n;
        for (int j = 0; j < n; ++j) {
            int i = RandUtils.nextInt(sr, k);
            this.perm[j] = help[i];
            help[i] = help[--k];
        }
    }

    public byte[] getEncoded() {
        int n = this.perm.length;
        int size = IntegerFunctions.ceilLog256(n - 1);
        byte[] result = new byte[4 + n * size];
        LittleEndianConversions.I2OSP(n, result, 0);
        for (int i = 0; i < n; ++i) {
            LittleEndianConversions.I2OSP(this.perm[i], result, 4 + i * size, size);
        }
        return result;
    }

    public int[] getVector() {
        return IntUtils.clone(this.perm);
    }

    public Permutation computeInverse() {
        Permutation result = new Permutation(this.perm.length);
        for (int i = this.perm.length - 1; i >= 0; --i) {
            result.perm[this.perm[i]] = i;
        }
        return result;
    }

    public Permutation rightMultiply(Permutation p) {
        if (p.perm.length != this.perm.length) {
            throw new IllegalArgumentException("length mismatch");
        }
        Permutation result = new Permutation(this.perm.length);
        for (int i = this.perm.length - 1; i >= 0; --i) {
            result.perm[i] = this.perm[p.perm[i]];
        }
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Permutation)) {
            return false;
        }
        Permutation otherPerm = (Permutation)other;
        return IntUtils.equals(this.perm, otherPerm.perm);
    }

    public String toString() {
        String result = "[" + this.perm[0];
        for (int i = 1; i < this.perm.length; ++i) {
            result = result + ", " + this.perm[i];
        }
        result = result + "]";
        return result;
    }

    public int hashCode() {
        return this.perm.hashCode();
    }

    private boolean isPermutation(int[] perm) {
        int n = perm.length;
        boolean[] onlyOnce = new boolean[n];
        for (int i = 0; i < n; ++i) {
            if (perm[i] < 0 || perm[i] >= n || onlyOnce[perm[i]]) {
                return false;
            }
            onlyOnce[perm[i]] = true;
        }
        return true;
    }
}

