/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.aes.param;

import com.nbcb.bouncycastle.util.encoders.Base64;
import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.exception.SDKExceptionEnums;
import com.nbcb.sdk.aes.param.ArrayConfig;
import com.nbcb.sdk.aes.param.ConfigFile;
import com.nbcb.sdk.aes.utils.SecurityUtils;
import com.nbcb.sdk.gm.KeyUtils;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class KeyStoreFactory
implements Cloneable {
    private static Log log = NbczLogger.getLog(KeyStoreFactory.class);
    private static KeyStoreFactory instance = null;
    private KeyStore keyStore = null;
    private SSLContext sslcontext;
    private PrivateKey merchantPrivatekey;
    private PublicKey openPublicKey;
    private Map<String, Object> tokenMap;
    private TrustAnyHostnameVerifier trustAnyHostnameVerifier;

    public static KeyStoreFactory getInstance() throws SDKException {
        if (null == instance) {
            instance = new KeyStoreFactory();
        }
        return instance;
    }

    private KeyStoreFactory() throws SDKException {
        this.createGMPrivateKey();
        this.createGMPublicKey();
        this.ignoreSSLContext();
        this.ignoreHostnameVerifier();
    }

    public KeyStoreFactory getClone(ArrayConfig config) throws CloneNotSupportedException, SDKException {
        KeyStoreFactory clone = (KeyStoreFactory)super.clone();
        try {
            clone.merchantPrivatekey = KeyUtils.createPrivateKey(config.getPRIVATEKEY());
            clone.openPublicKey = KeyUtils.createPublicKey(config.getPUBLICKEY());
            clone.ignoreSSLContext();
            clone.ignoreHostnameVerifier();
            return clone;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u751f\u6210\u4e09\u65b9\u79c1\u94a5\u5bf9\u8c61\u5f02\u5e38", e);
            }
            throw new SDKException(SDKExceptionEnums.INITIALIZE_KEYSTORE_ERROR);
        }
    }

    private void createGMPrivateKey() throws SDKException {
        try {
            this.merchantPrivatekey = KeyUtils.createPrivateKey(ConfigFile.PRIVATEKEY);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u751f\u6210\u4e09\u65b9\u79c1\u94a5\u5bf9\u8c61\u5f02\u5e38", e);
            }
            throw new SDKException(SDKExceptionEnums.INITIALIZE_KEYSTORE_ERROR);
        }
    }

    private void createGMPublicKey() throws SDKException {
        try {
            this.openPublicKey = KeyUtils.createPublicKey(ConfigFile.PUBLICKEY);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u751f\u6210\u5f00\u653e\u94f6\u884c\u516c\u94a5\u5bf9\u8c61\u5f02\u5e38", e);
            }
            throw new SDKException(SDKExceptionEnums.INITIALIZE_KEYSTORE_ERROR);
        }
    }

    private void createSSLContext() throws SDKException {
        KeyManagerFactory manager = null;
        try {
            this.sslcontext = SSLContext.getInstance("SSL");
            this.keyStore = KeyStore.getInstance("PKCS12");
            FileInputStream fis = new FileInputStream(ConfigFile.KEYPATH);
            this.keyStore.load(fis, ConfigFile.KEYPWD.toCharArray());
            fis.close();
            fis = null;
            manager = KeyManagerFactory.getInstance("SunX509");
            manager.init(this.keyStore, ConfigFile.KEYPWD.toCharArray());
            KeyManager[] keyManagers = manager.getKeyManagers();
            this.sslcontext.init(keyManagers, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u52a0\u8f7d\u8bc1\u4e66\u5f02\u5e38", e);
            }
            throw new SDKException(SDKExceptionEnums.INITIALIZE_KEYSTORE_ERROR);
        }
    }

    private void ignoreSSLContext() {
        try {
            this.sslcontext = SSLContext.getInstance("TLS");
            TrustManager[] xcf = new X509TrustManager[]{new MyX509TrustManager()};
            this.sslcontext.init(null, xcf, new SecureRandom());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void ignoreHostnameVerifier() {
        this.trustAnyHostnameVerifier = new TrustAnyHostnameVerifier();
    }

    private void createCCBSSLContext() throws SDKException {
        KeyManagerFactory manager = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.sslcontext = SSLContext.getInstance("TLS");
            this.keyStore = KeyStore.getInstance("JKS");
            FileInputStream fis = new FileInputStream(ConfigFile.KEYPATH);
            Certificate cer = cf.generateCertificate(fis);
            this.keyStore.load(null, null);
            this.keyStore.setKeyEntry("mykey", this.merchantPrivatekey, "".toCharArray(), new Certificate[]{cer});
            fis.close();
            fis = null;
            manager = KeyManagerFactory.getInstance("SunX509");
            manager.init(this.keyStore, "".toCharArray());
            KeyManager[] keyManagers = manager.getKeyManagers();
            FileInputStream caInput = new FileInputStream(ConfigFile.CAPATH);
            Certificate ca = cf.generateCertificate(caInput);
            ((InputStream)caInput).close();
            String keyStoreType = KeyStore.getDefaultType();
            KeyStore cakeyStore = KeyStore.getInstance(keyStoreType);
            cakeyStore.load(null, null);
            cakeyStore.setCertificateEntry("CA", ca);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(cakeyStore);
            this.sslcontext.init(keyManagers, tmf.getTrustManagers(), new SecureRandom());
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u52a0\u8f7d\u8bc1\u4e66\u5f02\u5e38", e);
            }
            throw new SDKException(SDKExceptionEnums.INITIALIZE_KEYSTORE_ERROR);
        }
    }

    private void createCcbPrivateKey() throws SDKException {
        try {
            this.merchantPrivatekey = KeyStoreFactory.getPrivateKey(ConfigFile.PRIVATEKEY);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u751f\u6210\u4e09\u65b9\u79c1\u94a5\u5bf9\u8c61\u5f02\u5e38", e);
            }
            throw new SDKException(SDKExceptionEnums.INITIALIZE_KEYSTORE_ERROR);
        }
    }

    private void createPublicKey() throws SDKException {
        try {
            byte[] bt = SecurityUtils.decryptByBASE64(ConfigFile.PUBLICKEY);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(bt);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.openPublicKey = keyFactory.generatePublic(publicKeySpec);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u751f\u6210\u5f00\u653e\u94f6\u884c\u516c\u94a5\u5bf9\u8c61\u5f02\u5e38", e);
            }
            throw new SDKException(SDKExceptionEnums.INITIALIZE_KEYSTORE_ERROR);
        }
    }

    private static PrivateKey getPrivateKey(String privateKey) throws Exception {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decode(privateKey));
        PrivateKey priKey = KeyFactory.getInstance("RSA").generatePrivate(pkcs8EncodedKeySpec);
        return priKey;
    }

    public SSLContext getSslcontext() {
        return this.sslcontext;
    }

    public Map<String, Object> getTokenMap() {
        return this.tokenMap;
    }

    public void setTokenMap(Map<String, Object> tokenMap) {
        this.tokenMap = tokenMap;
    }

    public PrivateKey getmerchantPrivatekey() {
        return this.merchantPrivatekey;
    }

    public void setmerchantPrivatekey(PrivateKey merchantPrivatekey) {
        this.merchantPrivatekey = merchantPrivatekey;
    }

    public PublicKey getOpenPublicKey() {
        return this.openPublicKey;
    }

    public void setOpenPublicKey(PublicKey openPublicKey) {
        this.openPublicKey = openPublicKey;
    }

    public TrustAnyHostnameVerifier getTrustAnyHostnameVerifier() {
        return this.trustAnyHostnameVerifier;
    }

    public boolean checkTokenVaild(String expirein, String updatetime) {
        long currenttime = System.currentTimeMillis();
        try {
            long expireinTemp = Long.parseLong(expirein);
            long updateTimeTemp = Long.parseLong(updatetime);
            if (expireinTemp - currenttime < updateTimeTemp && expireinTemp - currenttime > 0L) {
                return false;
            }
            if (expireinTemp - currenttime < 0L) {
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    public class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            System.out.println("Warning: URL Host: " + hostname + " vs. " + session.getPeerHost());
            return true;
        }
    }

    class MyX509TrustManager
    implements X509TrustManager {
        MyX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

