/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.gm;

import com.nbcb.bouncycastle.crypto.digests.SM3Digest;
import com.nbcb.bouncycastle.crypto.macs.HMac;
import com.nbcb.bouncycastle.crypto.params.KeyParameter;
import com.nbcb.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import com.nbcb.bouncycastle.util.encoders.Base64;
import com.nbcb.bouncycastle.util.encoders.Hex;
import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.exception.SDKExceptionEnums;
import com.nbcb.sdk.gm.Utils;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;

public class SM3Utils {
    private static Log log = NbczLogger.getLog(SM3Utils.class);
    private static final String CHARSET = "UTF-8";
    private static final String DEFAULT_XRO_KEY = "BC614E";

    public static String hexEncrypt(String hexString) {
        byte[] srcData = Hex.decode(hexString);
        byte[] encrypt = SM3Utils.encrypt(srcData);
        String cipherStr = Hex.toHexString(encrypt);
        return cipherStr;
    }

    public static String hexEncrypt(String hexKey, String hexString) {
        byte[] key = Hex.decode(hexKey);
        byte[] srcData = Hex.decode(hexString);
        byte[] encrypt = SM3Utils.encrypt(key, srcData);
        String cipherStr = Hex.toHexString(encrypt);
        return cipherStr;
    }

    public static String plainEncrypt(String plain) {
        String cipherStr = null;
        try {
            byte[] srcData = plain.getBytes(CHARSET);
            byte[] encrypt = SM3Utils.encrypt(srcData);
            cipherStr = Hex.toHexString(encrypt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cipherStr;
    }

    public static String plainEncrypt(String hexKey, String plain) {
        String cipherStr = null;
        try {
            byte[] srcData = plain.getBytes(CHARSET);
            byte[] key = Hex.decode(hexKey);
            byte[] encrypt = SM3Utils.encrypt(key, srcData);
            cipherStr = Hex.toHexString(encrypt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cipherStr;
    }

    public static byte[] encrypt(byte[] srcData) {
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(srcData, 0, srcData.length);
        byte[] encrypt = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(encrypt, 0);
        return encrypt;
    }

    public static byte[] encrypt(File file) throws SDKException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int numRead = -1;
            SM3Digest sm3Digest = new SM3Digest();
            while ((numRead = fileInputStream.read(buffer)) != -1) {
                sm3Digest.update(buffer, 0, numRead);
            }
            byte[] encrypt = new byte[sm3Digest.getDigestSize()];
            sm3Digest.doFinal(encrypt, 0);
            byte[] byArray = encrypt;
            return byArray;
        }
        catch (IOException e) {
            log.error("file error", e);
            throw new SDKException(SDKExceptionEnums.FILE_ENCRYPT_ERROR);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String encryptStr(File file) throws SDKException {
        byte[] encrypt = SM3Utils.encrypt(file);
        return Hex.toHexString(encrypt);
    }

    public static byte[] hash(byte[] srcData) {
        return SM3Utils.encrypt(srcData);
    }

    public static byte[] encrypt(byte[] key, byte[] srcData) {
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac(digest);
        mac.init(keyParameter);
        mac.update(srcData, 0, srcData.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    public static byte[] encrypt_0(byte[] srcData) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SM3", "BC");
        byte[] digest = messageDigest.digest(srcData);
        return digest;
    }

    public static byte[] encodexor(byte[] src, int xorkey) {
        int key = xorkey != 0 ? xorkey : Utils.hexStringToAlgorism(DEFAULT_XRO_KEY);
        byte[] tmp = new byte[src.length];
        for (int i = 0; i < src.length; ++i) {
            tmp[i] = (byte)(src[i] ^ key);
        }
        return tmp;
    }

    public static byte[] hashXor(byte[] src) {
        byte[] srcData = Base64.toBase64String(src).replaceAll("\r\n", "").replaceAll("\n", "").getBytes();
        SM3Digest digest = new SM3Digest();
        digest.update(srcData, 0, srcData.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        byte[] xor = SM3Utils.encodexor(hash, src.length);
        System.arraycopy(hash, 0, hash, 0, hash.length / 2);
        System.arraycopy(xor, 0, hash, hash.length / 2, xor.length / 2);
        return ByteUtils.toHexString(hash).replaceAll("\n", "").getBytes();
    }
}

