/*
 * Decompiled with CFR 0.152.
 */
package com.cib.fintech.dfp.open.sdk.util;

import com.cib.fintech.dfp.open.sdk.exception.SdkExType;
import com.cib.fintech.dfp.open.sdk.exception.SdkException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class FileUtil {
    public static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileByBytes(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException(filePath);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)file.length());
        BufferedInputStream in = null;
        try {
            int len;
            in = new BufferedInputStream(new FileInputStream(file));
            int bufSize = 1024;
            byte[] buffer = new byte[bufSize];
            while (-1 != (len = in.read(buffer, 0, bufSize))) {
                baos.write(buffer, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            baos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileHash(String filePath, String algorithm) throws Exception {
        MessageDigest messagedigest = null;
        try {
            messagedigest = MessageDigest.getInstance(algorithm);
            try (FileInputStream fis = null;){
                fis = new FileInputStream(filePath);
                byte[] buffer = new byte[1024];
                int numRead = 0;
                while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                    messagedigest.update(buffer, 0, numRead);
                }
            }
        }
        catch (Exception e) {
            SdkException ex = new SdkException(SdkExType.FILE_ERROR_RESULT);
            return ex.toString();
        }
        return FileUtil.toHexString(messagedigest.digest());
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEX_CHAR[(b[i] & 0xF0) >>> 4]);
            sb.append(HEX_CHAR[b[i] & 0xF]);
        }
        return sb.toString();
    }
}

