/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.dc.services.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.pab.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.pab.dc.services.PackerHelper;
import kd.ebg.aqap.banks.pab.dc.services.PageUtil;
import kd.ebg.aqap.banks.pab.dc.services.ParserHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        if (BankBusinessConfig.isFixedAcnt(request.getAcnt().getAccNo())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u4e0d\u652f\u6301\u67e5\u8be2\u5386\u53f2\u4f59\u989d\u3002", (String)"HisBalanceImpl_0", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]));
        }
        Element Result = new Element("Result");
        JDomUtils.addChild((Element)Result, (String)"Account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Result, (String)"RptDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Result, (String)"CcyCode", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)Result, (String)"Reserve", (String)"");
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        return PackerHelper.createReqMsgWithHead(EBContext.getContext().getBankRequestSeq(), "4012", xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        BankResponse bankRsp = new BankResponse();
        PageUtil pageUtil = ParserHelper.parseResponse(responseStr, bankRsp);
        if (!"000000".equals(bankRsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage()));
        }
        Element root = JDomUtils.string2Root((String)pageUtil.getXmlStr(), (String)RequestContextUtils.getCharset());
        String account = root.getChildTextTrim("Account");
        String ccyCode = root.getChildTextTrim("CcyCode");
        String HisBalance = root.getChildTextTrim("HisBalance");
        String HisBookBalance = root.getChildTextTrim("HisBookBalance");
        String dateStr = root.getChildTextTrim("RptDate");
        ArrayList<BalanceInfo> resultList = new ArrayList<BalanceInfo>(1);
        BalanceInfo balance = new BalanceInfo();
        this.setBankAcnt(balance, request.getBankAcntList(), account);
        this.setBankCurrency(balance, ccyCode);
        this.setCurrentBalance(balance, HisBalance);
        this.setAvailableBalance(balance, HisBookBalance);
        this.setBalanceDateTime(balance, dateStr + "235959", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        resultList.add(balance);
        return new EBBankBalanceResponse(resultList);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "CQRC17";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"CQRC17(\u5386\u53f2\u4f59\u989d)", (String)"HisBalanceImpl_5", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public int queryDays() {
        return 1;
    }
}

