/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.dc.services.payment.company.otherbank;

import java.math.BigDecimal;
import java.util.List;
import kd.ebg.aqap.banks.pab.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.pab.dc.services.PackerHelper;
import kd.ebg.aqap.banks.pab.dc.services.ParserHelper;
import kd.ebg.aqap.banks.pab.dc.services.payment.company.otherbank.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element Result = new Element("Result");
        String useEx = paymentInfo.getExplanation();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            useEx = BizNoUtil.cont((String)paymentInfo.getBankDetailSeqId(), (String)useEx);
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
        }
        useEx = StringUtils.substringChinese((String)useEx, (String)RequestContextUtils.getCharset(), (int)20);
        JDomUtils.addChild((Element)Result, (String)"OrderNumber", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)Result, (String)"AcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)Result, (String)"BusiType", (String)"00000");
        JDomUtils.addChild((Element)Result, (String)"CorpId", (String)"");
        JDomUtils.addChild((Element)Result, (String)"CcyCode", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)Result, (String)"TranAmount", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
        JDomUtils.addChild((Element)Result, (String)"InAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)Result, (String)"InAcctName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)Result, (String)"InAcctBankName", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)Result, (String)"InAcctBankNode", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)Result, (String)"Mobile", (String)paymentInfo.getMobiles());
        JDomUtils.addChild((Element)Result, (String)"Remark", (String)useEx);
        JDomUtils.addChild((Element)Result, (String)"InAcctProvinceName", (String)"");
        JDomUtils.addChild((Element)Result, (String)"InAcctCityName", (String)"");
        JDomUtils.addChild((Element)Result, (String)"SubAcctNo", (String)"");
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        return PackerHelper.createReqMsgWithHead(Sequence.genSequence(), "KHKF03", xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse bankRsp = new BankResponse();
        ParserHelper.parseResponse(rspStr, bankRsp);
        if ("000000".equalsIgnoreCase(bankRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "KHKF03";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo info) {
        return false;
    }
}

