/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.wlbl.services.pay.hndsz;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.wlbl.services.pay.query.QueryPay1013Impl;
import kd.ebg.aqap.banks.cmb.wlbl.utils.MessageUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;

public class Pay2008Impl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPay1013Impl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        JSONObject body = MessageUtils.getReqBody();
        body.put("orderFlowNo", (Object)"");
        body.put("payAccount", (Object)paymentInfo.getAccNo());
        body.put("payAccountCurrency", (Object)paymentInfo.getPayCurrency());
        body.put("recAccount", (Object)paymentInfo.getIncomeAccNo());
        if (!MessageUtils.isNotContainChinese(paymentInfo.getIncomeAccName())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u6237\u4e0d\u80fd\u662f\u4e2d\u6587\u3002", (String)"Pay2008Impl_0", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]));
        }
        body.put("exchangeRate", (Object)"");
        body.put("recAccountName", (Object)paymentInfo.getIncomeAccName());
        body.put("transferAmt", (Object)paymentInfo.getAmount().toPlainString());
        body.put("transferCurrency", (Object)paymentInfo.getPayCurrency());
        body.put("payRem", (Object)MessageUtils.checkRem(paymentInfo.getExplanation(), 50));
        body.put("payUse", (Object)"");
        body.put("mobileNo", (Object)"");
        body.put("regInd", (Object)"N");
        return MessageUtils.sendToBankForPay(bankPayRequest.getHeader(), this.getBizCode(), body, paymentInfo.getBankBatchSeqID());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        JSONObject body = MessageUtils.receive(s);
        String orderFlowNo = body.getString("orderFlowNo");
        if (StringUtils.isEmpty((String)orderFlowNo)) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u4ea4\u6613\u6d41\u6c34\u53f7\u3002", (String)"Pay2008Impl_1", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]), (String)"", (String)"");
        } else {
            ((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).setBankRefID(orderFlowNo);
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "2008";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u7b2c\u4e09\u8005", (String)"Pay2008Impl_2", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String hndsz = PropertiesConstants.getValue((String)"HNDSZ");
        return "2008".equalsIgnoreCase(paymentInfo.getUseCN()) || hndsz.equalsIgnoreCase(paymentInfo.getUseCN());
    }

    public void configFactory(ConnectionFactory factory) {
        MessageUtils.setRequestProperty(factory);
    }
}

