/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.srcb.dc.services.utils;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Locale;
import kd.ebg.aqap.banks.srcb.dc.services.utils.CryptoException;
import kd.ebg.aqap.banks.srcb.dc.services.utils.GlobalBouncyCastleProvider;
import kd.ebg.egf.common.utils.collect.ArrayUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class KeyUtil {
    public static final String KEY_TYPE_JKS = "JKS";
    public static final String KEY_TYPE_JCEKS = "jceks";
    public static final String KEY_TYPE_PKCS12 = "pkcs12";
    public static final String CERT_TYPE_X509 = "X.509";
    public static final int DEFAULT_KEY_SIZE = 1024;
    public static final String SM2_DEFAULT_CURVE = "sm2p256v1";

    public static PrivateKey generatePrivateKey(String algorithm, byte[] key) {
        if (null == key) {
            return null;
        }
        return KeyUtil.generatePrivateKey(algorithm, new PKCS8EncodedKeySpec(key));
    }

    public static PrivateKey generatePrivateKey(String algorithm, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        algorithm = KeyUtil.getAlgorithmAfterWith(algorithm);
        try {
            return KeyUtil.getKeyFactory(algorithm).generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static PublicKey generatePublicKey(String algorithm, byte[] key) {
        if (null == key) {
            return null;
        }
        return KeyUtil.generatePublicKey(algorithm, new X509EncodedKeySpec(key));
    }

    public static PublicKey generatePublicKey(String algorithm, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        algorithm = KeyUtil.getAlgorithmAfterWith(algorithm);
        try {
            return KeyUtil.getKeyFactory(algorithm).generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static KeyPair generateKeyPair(String algorithm) {
        int keySize = 1024;
        if ("ECIES".equalsIgnoreCase(algorithm)) {
            keySize = 256;
        }
        return KeyUtil.generateKeyPair(algorithm, keySize);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        return KeyUtil.generateKeyPair(algorithm, keySize, null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        if ("SM2".equalsIgnoreCase(algorithm)) {
            ECGenParameterSpec sm2p256v1 = new ECGenParameterSpec(SM2_DEFAULT_CURVE);
            return KeyUtil.generateKeyPair(algorithm, keySize, seed, sm2p256v1);
        }
        return KeyUtil.generateKeyPair(algorithm, keySize, seed, (AlgorithmParameterSpec[])null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed, AlgorithmParameterSpec ... params) {
        return KeyUtil.generateKeyPair(algorithm, keySize, new SecureRandom(), params);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, SecureRandom random, AlgorithmParameterSpec ... params) {
        algorithm = KeyUtil.getAlgorithmAfterWith(algorithm);
        KeyPairGenerator keyPairGen = KeyUtil.getKeyPairGenerator(algorithm);
        if (keySize > 0) {
            if ("EC".equalsIgnoreCase(algorithm) && keySize > 256) {
                keySize = 256;
            }
            if (null != random) {
                keyPairGen.initialize(keySize, random);
            } else {
                keyPairGen.initialize(keySize);
            }
        }
        if (ArrayUtil.isNotEmpty((Object[])params)) {
            for (AlgorithmParameterSpec param : params) {
                if (null == param) continue;
                try {
                    if (null != random) {
                        keyPairGen.initialize(param, random);
                        continue;
                    }
                    keyPairGen.initialize(param);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new CryptoException(e);
                }
            }
        }
        return keyPairGen.generateKeyPair();
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) {
        KeyPairGenerator keyPairGen;
        Provider provider = GlobalBouncyCastleProvider.getInstance().getProvider();
        try {
            keyPairGen = null == provider ? KeyPairGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : KeyPairGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return keyPairGen;
    }

    public static KeyFactory getKeyFactory(String algorithm) {
        KeyFactory keyFactory;
        Provider provider = GlobalBouncyCastleProvider.getInstance().getProvider();
        try {
            keyFactory = null == provider ? KeyFactory.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : KeyFactory.getInstance(KeyUtil.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return keyFactory;
    }

    public static String getMainAlgorithm(String algorithm) {
        int slashIndex = algorithm.indexOf("'/'");
        if (slashIndex > 0) {
            return algorithm.substring(0, slashIndex);
        }
        return algorithm;
    }

    public static String getAlgorithmAfterWith(String algorithm) {
        if (algorithm.toUpperCase(Locale.ENGLISH).startsWith("ECIESWith".toUpperCase(Locale.ENGLISH))) {
            return "EC";
        }
        int indexOfWith = algorithm.lastIndexOf("with");
        if (indexOfWith > 0) {
            algorithm = KeyUtil.sub(algorithm, indexOfWith + "with".length(), algorithm.length());
        }
        if ("ECDSA".equalsIgnoreCase(algorithm) || "SM2".equalsIgnoreCase(algorithm) || "ECIES".equalsIgnoreCase(algorithm)) {
            algorithm = "EC";
        }
        return algorithm;
    }

    public static String sub(String str, int fromIndex, int toIndex) {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        int len = str.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return "";
        }
        return str.substring(fromIndex, toIndex);
    }
}

