/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.dc.services.payment.local;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dbs.dc.services.DBS_DC_Constants;
import kd.ebg.aqap.banks.dbs.dc.services.DBS_DC_Packer;
import kd.ebg.aqap.banks.dbs.dc.services.DBS_DC_Parser;
import kd.ebg.aqap.banks.dbs.dc.services.payment.local.QueryFastPayImpl;
import kd.ebg.aqap.banks.dbs.dc.services.utils.DbsHelper;
import kd.ebg.aqap.banks.dbs.dc.services.utils.PgpHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PayImpl.class);

    public EBBankPayResponse pay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String requestStr = this.pack(request);
        try {
            String response = DbsHelper.sendRequestAndReceive(RequestContextUtils.getBankParameterValue((String)"payFastUri"), ((PaymentInfo)paymentInfos.get(0)).getAccNo(), requestStr);
            return this.parse(request, response);
        }
        catch (EBServiceException e) {
            EBContext.getContext().setThrowableAfterSend((Throwable)e);
            return new EBBankPayResponse(paymentInfos);
        }
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryFastPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return DBS_DC_Packer.packFastPayment(bankPayRequest);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        String origin;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        try {
            origin = PgpHelper.decry(s);
        }
        catch (Throwable e) {
            this.logger.error("\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"PayImpl_4", (String)"ebg-aqap-banks-dbs-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return this.parseInfo(origin, paymentInfos);
    }

    public EBBankPayResponse parseInfo(String origin, List<PaymentInfo> paymentInfos) {
        JSONObject total = JSONObject.parseObject((String)origin);
        DBS_DC_Parser.checkError(total);
        JSONObject txnResponses = total.getJSONObject("txnResponse");
        String txnStatus = txnResponses.getString("txnStatus");
        String txnStatusDescription = txnResponses.getString("txnStatusDescription");
        if ("RJCT".equalsIgnoreCase(txnStatus)) {
            String txnRejectCode = txnResponses.getString("txnRejectCode");
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)txnRejectCode, (String)txnStatusDescription);
        } else if ("ACTC".equalsIgnoreCase(txnStatus) || "ACWC".equalsIgnoreCase(txnStatus)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)txnStatus, (String)txnStatusDescription);
        } else if ("PDNG".equalsIgnoreCase(txnStatus)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)txnStatus, (String)txnStatusDescription);
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)txnStatus, (String)txnStatusDescription);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ("GPP".equalsIgnoreCase(paymentInfo.getUseCN())) {
            return true;
        }
        return "SGD".equalsIgnoreCase(paymentInfo.getCurrency()) && (DBS_DC_Constants.bicLists.contains(paymentInfo.getIncomeSwiftCode()) || DBS_DC_Constants.bicListsForTest.contains(paymentInfo.getIncomeSwiftCode()));
    }
}

