/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdnx.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sdnx.dc.services.SDNX_DC_Packer;
import kd.ebg.aqap.banks.sdnx.dc.services.SDNX_DC_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public void configFactory(ConnectionFactory factory) {
        StringBuilder uri = new StringBuilder("/eweb/b2econnect.do");
        String signFlag = RequestContextUtils.getBankParameterValue((String)"signData");
        String accessnum = RequestContextUtils.getBankParameterValue((String)"password");
        if (StringUtils.isEmpty((String)signFlag) || "0".equalsIgnoreCase(signFlag)) {
            uri.append("?userPassword=").append(accessnum).append("&SIGDATA=0");
        } else {
            uri.append("?userPassword=").append(accessnum).append("&SIGDATA=1");
        }
        factory.setUri(uri.toString());
    }

    public String getDeveloper() {
        return "HSQ";
    }

    public String getBizCode() {
        return "QRCB002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"IESI109012\uff0c\u8d26\u6237\u660e\u7ec6\u67e5\u8be2\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]);
    }

    public String pack(BankDetailRequest rqst) {
        Element root = SDNX_DC_Packer.getCommonHeader("QRCB002", RequestContextUtils.getRequestContext().getBankRequestSeq(), LocalDateTime.now());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        if (rqst.getExtData() != null) {
            String[] page = rqst.getExtData().split("\\|");
            JDomUtils.addChild((Element)body, (String)"StartKey", (String)page[0]);
            JDomUtils.addChild((Element)body, (String)"EndKey", (String)page[1]);
        }
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String rspStr) {
        Element list;
        this.setLastPage(true);
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(1);
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = SDNX_DC_Parser.parserCommonHeader(root);
        if (null == bankResponse.getResponseCode() || !"000000".equals(bankResponse.getResponseCode())) {
            return new EBBankDetailResponse(result);
        }
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        String NextData = JDomUtils.getChildText((Element)body, (String)"NextData");
        if (!NextData.contains("N")) {
            this.setLastPage(false);
            String StartKey = JDomUtils.getChildText((Element)body, (String)"StartKey");
            String EndKey = JDomUtils.getChildText((Element)body, (String)"EndKey");
            rqst.setExtData(StartKey + "|" + EndKey);
        }
        if (null == (list = JDomUtils.getChildElement((Element)body, (String)"List"))) {
            return new EBBankDetailResponse(result);
        }
        List mapList = list.getChildren("Map");
        for (int i = 0; i < mapList.size(); ++i) {
            Element map = (Element)mapList.get(i);
            String oppositeAccNo = JDomUtils.getChildText((Element)map, (String)"oppositeAccNo");
            String oppositeName = JDomUtils.getChildText((Element)map, (String)"oppositeName");
            String OpInsinName = JDomUtils.getChildText((Element)map, (String)"OpInsinName");
            String currency = JDomUtils.getChildText((Element)map, (String)"Currency");
            String onloanFlag = JDomUtils.getChildText((Element)map, (String)"onloanFlag");
            String amountStr = JDomUtils.getChildText((Element)map, (String)"amount");
            String balance = JDomUtils.getChildText((Element)map, (String)"balance");
            String hostFlowNo = JDomUtils.getChildText((Element)map, (String)"hostFlowNo");
            String payUse = JDomUtils.getChildText((Element)map, (String)"payUse");
            String summary = JDomUtils.getChildText((Element)map, (String)"summary");
            String payerAcName = JDomUtils.getChildText((Element)map, (String)"bkhName");
            String payerAcNo = JDomUtils.getChildText((Element)map, (String)"bkhNo");
            String transferDate = JDomUtils.getChildText((Element)map, (String)"transferDate");
            String transferTime = JDomUtils.getChildText((Element)map, (String)"transferTime");
            DetailInfo detailInfo = new DetailInfo();
            if (StringUtils.isEmpty((String)transferTime)) {
                transferTime = "000000";
            }
            LocalDateTime transTime = LocalDateTime.parse(transferDate + transferTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            detailInfo.setTransTime(transTime);
            detailInfo.setTransDate(transTime.toLocalDate());
            detailInfo.setAccName(rqst.getAcnt().getAccName());
            detailInfo.setAccNo(rqst.getAcnt().getAccNo());
            detailInfo.setUseCn(payUse);
            detailInfo.setExplanation(summary);
            if (StringUtils.isEmpty((String)currency)) {
                detailInfo.setCurrency(rqst.getBankCurrency());
            } else {
                detailInfo.setCurrency(currency);
            }
            if (onloanFlag.equals("D")) {
                detailInfo.setOppAccName(oppositeName);
                detailInfo.setOppAccNo(oppositeAccNo);
                detailInfo.setOppBankName(OpInsinName);
                detailInfo.setCreditAmount(new BigDecimal("0"));
                detailInfo.setDebitAmount(new BigDecimal(amountStr));
            } else {
                detailInfo.setOppAccName(payerAcName);
                detailInfo.setOppAccNo(payerAcNo);
                detailInfo.setOppBankName(rqst.getAcnt().getBankName());
                detailInfo.setCreditAmount(new BigDecimal(amountStr));
                detailInfo.setDebitAmount(new BigDecimal("0"));
            }
            if (StringUtils.isNotEmpty((String)balance)) {
                detailInfo.setBalance(new BigDecimal(balance));
            }
            DetailSysFiled.set((DetailInfo)detailInfo, (String)"bizRefNo", (String)hostFlowNo);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(map);
            detailInfo.setJsonMap(jsonStr);
            detailInfo.setBankDetailNo(hostFlowNo);
            result.add(detailInfo);
        }
        return new EBBankDetailResponse(result);
    }

    public boolean isSupportPage() {
        return true;
    }
}

