/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdnx.dc.services.payment.inner;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sdnx.dc.services.SDNX_DC_Packer;
import kd.ebg.aqap.banks.sdnx.dc.services.SDNX_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SameBankQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = SDNX_DC_Packer.getCommonHeader("QRCB005", Sequence.gen14Sequence(), LocalDateTime.now());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"orderFlowNo", (String)paymentInfo.getBankBatchSeqId());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = SDNX_DC_Parser.parserCommonHeader(root);
        if (null == bankResponse.getResponseCode() || !"000000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
            String orderState = JDomUtils.getChildText((Element)body, (String)"Proc_stat");
            String orderFlowDescript = JDomUtils.getChildText((Element)body, (String)"orderFlowDescript");
            if ("90".equals(orderState)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SameBankQueryPayImpl_1", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]), (String)orderState, (String)orderFlowDescript);
            } else if ("91".equals(orderState)) {
                String target = PropertiesConstants.getValue((String)"SDNX_DC_1");
                if (!StringUtils.isEmpty((String)orderFlowDescript) && orderFlowDescript.contains(target)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SameBankQueryPayImpl_5", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]), (String)orderState, (String)orderFlowDescript);
                } else {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SameBankQueryPayImpl_0", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]), (String)orderState, (String)orderFlowDescript);
                }
            } else if ("99".equals(orderState)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SameBankPayImpl_2", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]), (String)orderState, (String)orderFlowDescript);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SameBankQueryPayImpl_5", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]), (String)orderState, (String)orderFlowDescript);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QRCB005";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2", (String)"SameBankQueryPayImpl_3", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder uri = new StringBuilder("/eweb/b2econnect.do");
        String signFlag = RequestContextUtils.getBankParameterValue((String)"signData");
        String accessnum = RequestContextUtils.getBankParameterValue((String)"password");
        if (StringUtils.isEmpty((String)signFlag) || "0".equalsIgnoreCase(signFlag)) {
            uri.append("?userPassword=").append(accessnum).append("&SIGDATA=0");
        } else {
            uri.append("?userPassword=").append(accessnum).append("&SIGDATA=1");
        }
        factory.setUri(uri.toString());
    }
}

