/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbb.dc.service.payment.salary;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hbb.dc.util.HeadPacker;
import kd.ebg.aqap.banks.hbb.dc.util.HeadParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final String TRANCODE = "eb2e-transfer.PaySalaryListQry";
    private static final String TRANCODEDEATIL = "eb2e-transfer.PaySalaryDetailQry";
    private EBGLogger logger = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());

    public int getBatchSize() {
        return 100;
    }

    public void configFactory(ConnectionFactory factory) {
        String transCode = TRANCODE;
        Map runningParams = EBContext.getContext().getRunningParams();
        if (runningParams != null && StringUtils.isNotEmpty((String)((String)runningParams.get("joinno")))) {
            transCode = TRANCODEDEATIL;
        }
        String s = "/eb2e/" + transCode + ".do?";
        s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("userPassword") + "&SIGDATA=1&_locale=zh_CN";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public String pack(BankPayRequest bankPayRequest) {
        String joinno = PaymentInfoSysFiled.get((PaymentInfo)((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)), (String)"joinno");
        if (StringUtils.isNotEmpty((String)joinno)) {
            HashMap<String, String> runningParams = EBContext.getContext().getRunningParams();
            if (runningParams == null) {
                runningParams = new HashMap<String, String>(1);
                EBContext.getContext().setRunningParams(runningParams);
            }
            runningParams.put("joinno", joinno);
            return this.packDetail(joinno);
        }
        return this.packList(bankPayRequest);
    }

    public String packList(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)HeadPacker.buildHead(TRANCODE, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"payerAcNo", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)body, (String)"ERPJnlNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public String packDetail(String joinno) {
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)HeadPacker.buildHead(TRANCODEDEATIL, Sequence.genSequence()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"batchNo", (String)joinno);
        JDomUtils.addChild((Element)body, (String)"paging", (String)"0");
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public void parse2(List<PaymentInfo> paymentInfos, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element body = bank_root.getChild("Body");
        BankResponse bankResponse = HeadParser.parserCommonInfo(bank_root);
        if (!"00000000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return;
        }
        List lists = body.getChildren("list");
        if (lists != null && lists.size() == 0) {
            return;
        }
        Iterator iterator = lists.iterator();
        if (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String jnlNo = element.getChildText("batchNo");
            this.logger.info("\u83b7\u53d6\u5230\u7684\u6d41\u6c34\u53f7\uff1a" + jnlNo);
            PaymentInfoSysFiled.set(paymentInfos, (String)"joinno", (String)jnlNo);
        }
        this.logger.info("\u67e5\u8be2\u4ee3\u53d1\u5de5\u8d44\u5217\u8868\uff08eb2e-transfer.PaySalaryListQry\uff09\u51fa\u9519");
    }

    public void parseDetail(BankPayRequest bankPayRequest, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element body = bank_root.getChild("Body");
        BankResponse bankResponse = HeadParser.parserCommonInfo(bank_root);
        List<PaymentInfo> paymentInfos = bankPayRequest.getPaymentInfos();
        if (!"00000000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return;
        }
        List lists = body.getChildren("detailList");
        if (lists == null || lists.size() == 0) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            paymentInfos = this.preBatchSameItemCheck(bankPayRequest);
            for (Element element : lists) {
                String key4NetSqlary;
                String key2AcNo = element.getChildText("key2AcNo");
                PaymentInfo payment = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)key2AcNo, (BigDecimal)new BigDecimal(key4NetSqlary = element.getChildText("key4NetSqlary")));
                if (payment == null) {
                    this.logger.info("\u627e\u4e0d\u5230\u4ed8\u6b3e\u4fe1\u606f");
                    continue;
                }
                String returnCode = JDomUtils.getChildText((Element)element, (String)"trsState");
                String errMsg = JDomUtils.getChildText((Element)element, (String)"errMsg");
                this.handlePayStatus(payment, returnCode, errMsg, bankResponse);
            }
            this.processingBankItemDataHandler(lists, bankResponse);
            PayStatusMatchUtil.backBatchSameItemHandler(paymentInfos, (boolean)false, (boolean)false);
        }
    }

    private List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    public void processingBankItemDataHandler(List<Element> elementList, BankResponse bankResponse) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (Element element : elementList) {
                    String bankDataKey = this.getBankDataKey(element);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String returnCode = JDomUtils.getChildText((Element)element, (String)"trsState");
                    String errMsg = JDomUtils.getChildText((Element)element, (String)"errMsg");
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, returnCode, errMsg, bankResponse);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    public PaymentInfo handlePayStatus(PaymentInfo tempInfo, String returnCode, String errMsg, BankResponse bankResponse) {
        String bankStatus = bankResponse.getResponseCode();
        if ("C".equalsIgnoreCase(returnCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankStatus, (String)bankResponse.getResponseMessage());
        } else if ("F".equalsIgnoreCase(returnCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankStatus, (String)errMsg);
        } else if ("BH".equalsIgnoreCase(returnCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)errMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankStatus, (String)errMsg);
        }
        return tempInfo;
    }

    private String getBankDataKey(Element element) {
        String incomeNo = element.getChildText("key2AcNo");
        String incomeName = element.getChildText("key3AcName");
        String amount = element.getChildText("key4NetSqlary");
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append(incomeNo).append(incomeName).append(new BigDecimal(amount).setScale(2).toString());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getAmountErrorFormatTips(), (Throwable)e);
        }
        return buffer.toString();
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        String joinno = PaymentInfoSysFiled.get((PaymentInfo)((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)), (String)"joinno");
        if (StringUtils.isNotEmpty((String)joinno)) {
            this.parseDetail(bankPayRequest, rspStr);
        } else {
            this.parse2(bankPayRequest.getPaymentInfos(), rspStr);
        }
        EBBankPayResponse response = new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        return response;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "PaySalaryListQry";
    }

    public String getBizDesc() {
        return "";
    }
}

