/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.hk.service.detail;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.hk.service.Packer;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "0024", Packer.getSeqNo());
        Element body = JDomUtils.addChild((Element)message, (String)"BODY");
        JDomUtils.addChild((Element)body, (String)"ACCOUNT", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"CURRTYPE", (String)bankDetailRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"BEGINDATE", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"ENDDATE", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(8);
        if (s.contains("encoding=\"UTF-8\"")) {
            s = s.replace("encoding=\"UTF-8\"", "encoding=\"GBK\"");
            logger.info("\u94f6\u884cxml\u62a5\u6587\u5934\u8fd4\u56de\u7f16\u7801\u662fUTF-8\uff0c\u8f6c\u5230GBK");
        }
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element message = JDomUtils.getChildElement((Element)root, (String)"MESSAGE");
        Element commHead = JDomUtils.getChildElement((Element)message, (String)"COMMHEAD");
        String retCode = JDomUtils.getChildText((Element)commHead, (String)"RETCODE");
        Element body = JDomUtils.getChildElement((Element)message, (String)"BODY");
        if ("000".equals(retCode)) {
            if (null != body) {
                String ERRORCODE = body.getChildText("ERRORCODE");
                if ("EBBP1012".equals(ERRORCODE)) {
                    return new EBBankDetailResponse(result);
                }
                Element records = JDomUtils.getChildElement((Element)body, (String)"RECORDS");
                if (records == null) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u8bb0\u5f55\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-gdb-hk", (Object[])new Object[0]));
                }
                List recordList = records.getChildren("RECORD");
                if (recordList != null) {
                    for (Element record : recordList) {
                        String dealDate = JDomUtils.getChildText((Element)record, (String)"DEALDATE");
                        String dealTime = JDomUtils.getChildText((Element)record, (String)"DEALTIME");
                        String loanSign = JDomUtils.getChildText((Element)record, (String)"LOANSIGN");
                        String TRANAMT = JDomUtils.getChildText((Element)record, (String)"TRANAMT");
                        String BALANCEAMT = JDomUtils.getChildText((Element)record, (String)"BALANCEAMT");
                        String RCVACCNO = JDomUtils.getChildText((Element)record, (String)"RCVACCNO");
                        String RCVACCNAME = JDomUtils.getChildText((Element)record, (String)"RCVACCNAME");
                        String DEALBRANCH = JDomUtils.getChildText((Element)record, (String)"DEALBRANCH");
                        String POSTSCRIPT = JDomUtils.getChildText((Element)record, (String)"POSTSCRIPT");
                        DetailInfo detailInfo = new DetailInfo();
                        detailInfo.setOppAccNo(RCVACCNO);
                        detailInfo.setOppAccName(RCVACCNAME);
                        detailInfo.setOppBankName(DEALBRANCH);
                        detailInfo.setCurrency(bankDetailRequest.getBankCurrency());
                        if ("+".equalsIgnoreCase(loanSign)) {
                            detailInfo.setCreditAmount(new BigDecimal(TRANAMT));
                            detailInfo.setDebitAmount(BigDecimal.ZERO);
                        }
                        if ("-".equalsIgnoreCase(loanSign)) {
                            detailInfo.setDebitAmount(new BigDecimal(TRANAMT));
                            detailInfo.setCreditAmount(BigDecimal.ZERO);
                        }
                        if (!StringUtils.isEmpty((String)dealDate)) {
                            try {
                                LocalDateTime transDateTime = !StringUtils.isEmpty((String)dealTime) ? LocalDateTime.parse(dealDate + dealTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) : LocalDateTime.parse(dealDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                                detailInfo.setTransTime(transDateTime);
                                detailInfo.setTransDate(transDateTime.toLocalDate());
                            }
                            catch (DateTimeParseException e) {
                                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-gdb-hk", (Object[])new Object[0]));
                            }
                        } else {
                            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-gdb-hk", (Object[])new Object[0]));
                        }
                        if (!StringUtils.isEmpty((String)BALANCEAMT)) {
                            detailInfo.setBalance(new BigDecimal(BALANCEAMT));
                        }
                        detailInfo.setExplanation(POSTSCRIPT);
                        String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
                        detailInfo.setJsonMap(jsonStr);
                        result.add(detailInfo);
                    }
                }
            }
        } else {
            if ("251".equals(retCode)) {
                logger.info("\u67e5\u8be2\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u54cd\u5e94\u7801251, \u6b64\u6bb5\u65f6\u95f4\u5185\u65e0\u4ea4\u6613\u3002");
                return new EBBankDetailResponse(result);
            }
            if ("242".equals(retCode)) {
                logger.info("\u67e5\u8be2\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u54cd\u5e94\u7801242, \u65e0\u7b26\u5408\u6761\u4ef6\u7684\u4ea4\u6613\u8bb0\u5f55\u3002");
                return new EBBankDetailResponse(result);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801:%s\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-gdb-hk", (Object[])new Object[0]), retCode));
        }
        return new EBBankDetailResponse(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "0024";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_4", (String)"ebg-aqap-banks-gdb-hk", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/CGBClient_mo/BankAction");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

