/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.ecny.service.balance;

import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.ecny.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.ecny.service.ABC_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final Logger logger = LoggerFactory.getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        return this.packNormalTodayBalance(request);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        return this.parseNormalTodayBalance(request, responseStr);
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CMRB22";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6bcd\u94b1\u5305\u5f53\u65e5\u4f59\u989d\u3002", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]);
    }

    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public String packNormalTodayBalance(BankBalanceRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CMRB22", Sequence.genSequence());
        Element Dcep = JDomUtils.addChild((Element)root, (String)"Dcep");
        JDomUtils.addChild((Element)Dcep, (String)"walletId", (String)acnt.getAccNo());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankBalanceResponse parseNormalTodayBalance(BankBalanceRequest rqst, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        ParserUtils.checkRspCode((BankAcnt)rqst.getAcnt(), (String)ResManager.loadKDString((String)"\u6570\u5b57\u4eba\u6c11\u5e01\u4f59\u989d\u67e5\u8be2\u3002", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]), (BankResponse)rsp, (String)"0000");
        Element Dcep = root.getChild("Dcep");
        String balanceStr = Dcep.getChildText("walletBalance");
        BalanceInfo balance = new BalanceInfo();
        logger.info("\u89e3\u6790\u5230\u519c\u884c\u8fd4\u56de\u7684'\u5f53\u524d\u4f59\u989d'\u4e3a{}\u5143", (Object)balanceStr);
        if (StringUtils.isEmpty((String)balanceStr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989dwalletBalance\u4e3a\u7a7a\u3002", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]));
        }
        this.setCurrentBalance(balance, balanceStr);
        this.setAvailableBalance(balance, balanceStr);
        this.setBankAcnt(balance, rqst.getAcnt());
        this.setBankCurrency(balance, rqst.getBankCurrency());
        this.setBalanceDateTime(balance, LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    public boolean match(BankBalanceRequest request) {
        return "WT09".equals(request.getAcnt().getAccEcnyType());
    }
}

