/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.uobsg.dc.services.handler;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractACKHandler;
import kd.ebg.aqap.proxy.oversea.utils.JDom11Utils;
import kd.ebg.aqap.proxy.oversea.utils.OverseaDBHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.commons.io.FileUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class UOBSG_DC_PAY_ACK_XML_Handler
extends AbstractACKHandler {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(UOBSG_DC_PAY_ACK_XML_Handler.class);

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    public boolean isNeedToProcessFile(String fileName) {
        return this.isStatus123(fileName) || this.isStatus4(fileName);
    }

    public boolean isStatus123(String fileName) {
        String[] regs;
        String regStatus1 = "^(PA).*(_1(\\.xml|\\.xml\\.pgp).xml)$";
        String regStatus2 = "^(PA).*(A1(\\.xml|\\.xml\\.pgp).xml)$";
        String regStatus3 = "^(PA).*(R1(\\.xml|\\.xml\\.pgp))$";
        for (String reg : regs = new String[]{regStatus1, regStatus2, regStatus3}) {
            if (!fileName.matches(reg)) continue;
            return true;
        }
        return false;
    }

    public boolean isStatus4(String fileName) {
        return fileName.matches("^(PA).*(O1.*(\\.xml|\\.xml\\.pgp))$");
    }

    public List<PaymentInfo> processFile(File file) {
        List<Object> list = Lists.newArrayList();
        try {
            if (this.isStatus123(file.getName())) {
                this.logger.info("Level 1-3 Status Report File");
                list = this.processFileLevelACK(file);
            } else if (this.isStatus4(file.getName())) {
                this.logger.info("Level 4 Status Report File");
                list = this.processTransactionLevelACK(file);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u4ed8\u6b3e\u5e94\u7b54\u62a5\u544a[%s]\u51fa\u9519", (String)"", (String)"", (Object[])new Object[0]), file.getName()), (Throwable)e);
            this.logger.error(e.getMessage());
        }
        return list;
    }

    public List<PaymentInfo> processFileLevelACK(File file) throws Exception {
        Element root = this.getRootFromFile(file, "UTF-8");
        this.logger.info(root.toString());
        Namespace ns = root.getNamespace();
        Element cstrpt = JDom11Utils.getUnNullChildElement((Element)root, (String)"CstmrPmtStsRpt", (Namespace)ns);
        Element orgnlgst = JDom11Utils.getUnNullChildElement((Element)cstrpt, (String)"OrgnlGrpInfAndSts", (Namespace)ns);
        String batchId = JDom11Utils.getUnNuLLChildText((Element)orgnlgst, (String)"OrgnlMsgId", (Namespace)ns);
        List payInfoList = OverseaDBHelper.getPaymentInfoByBatchId((String)batchId);
        this.logger.info("\u6839\u636e\u6279\u6b21\u53f7\u67e5\u8be2\u5230" + payInfoList.size() + "\u7b14\u8bb0\u5f55");
        String GrpSts = orgnlgst.getChildText("GrpSts", ns);
        Element StsRsnInf = orgnlgst.getChild("StsRsnInf", ns);
        String txMsg = GrpSts;
        if (StsRsnInf != null) {
            txMsg = StsRsnInf.getChildText("AddtlInf", ns);
        }
        this.logger.info(String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7:%1$s,GrpSts:%2$s,AddtlInf:%3$s", (String)"UOBSG_DC_PAY_ACK_XML_Handler_5", (String)"ebg-aqap-banks-uobsg-dc", (Object[])new Object[0]), batchId, GrpSts, txMsg));
        if (GrpSts.startsWith("AC") && GrpSts.length() == 4) {
            EBGBusinessUtils.setPaymentState((List)payInfoList, (PaymentState)PaymentState.SUBMITED, (String)"", (String)GrpSts, (String)"");
        } else if ("RJCT".equalsIgnoreCase(GrpSts)) {
            EBGBusinessUtils.setPaymentState((List)payInfoList, (PaymentState)PaymentState.FAIL, (String)"", (String)GrpSts, (String)txMsg);
        } else if ("RCVD".equalsIgnoreCase(GrpSts)) {
            EBGBusinessUtils.setPaymentState((List)payInfoList, (PaymentState)PaymentState.SUBMITED, (String)"", (String)GrpSts, (String)"File received");
        } else if ("PART".equalsIgnoreCase(GrpSts)) {
            EBGBusinessUtils.setPaymentState((List)payInfoList, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)GrpSts, (String)"Partially Accepted");
        } else {
            throw EBExceiptionUtil.serviceException((String)("Unknown GroupStatus`" + GrpSts + "`,please contact bank for assistance"));
        }
        return payInfoList;
    }

    protected List<PaymentInfo> processTransactionLevelACK(File file) throws Exception {
        Element root = this.getRootFromFile(file, "UTF-8");
        Namespace ns = root.getNamespace();
        Element cstrpt = JDom11Utils.getUnNullChildElement((Element)root, (String)"CstmrPmtStsRpt", (Namespace)ns);
        Element orgnlgst = JDom11Utils.getUnNullChildElement((Element)cstrpt, (String)"OrgnlGrpInfAndSts", (Namespace)ns);
        String batchId = JDom11Utils.getUnNuLLChildText((Element)orgnlgst, (String)"OrgnlMsgId", (Namespace)ns);
        List pmtList = cstrpt.getChildren("OrgnlPmtInfAndSts", ns);
        HashMap<String, PaymentInfo> map = new HashMap<String, PaymentInfo>(16);
        for (Element ele : pmtList) {
            Element TxInfAndSts = JDom11Utils.getChildElement((Element)ele, (String)"TxInfAndSts", (Namespace)ns);
            String seqId = TxInfAndSts.getChildText("OrgnlEndToEndId", ns);
            String TxSts = TxInfAndSts.getChildText("TxSts", ns);
            Element StsRsnInf = TxInfAndSts.getChild("StsRsnInf", ns);
            String txMsg = TxSts;
            if (StsRsnInf != null) {
                txMsg = StsRsnInf.getChildText("AddtlInf", ns);
            }
            this.logger.info(String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7:%1$s,TxSts:%2$s,AddtlInf:%3$s", (String)"", (String)"", (Object[])new Object[0]), batchId, TxSts, txMsg));
            PaymentInfo paymentInfo = new PaymentInfo();
            paymentInfo.setBankStatus(TxSts);
            paymentInfo.setBankMsg(txMsg);
            map.put(seqId, paymentInfo);
        }
        List payInfoList = OverseaDBHelper.getPaymentInfoByBatchId((String)batchId);
        this.logger.info("\u6839\u636e\u6279\u6b21\u53f7" + batchId + "\u67e5\u8be2\u5230" + payInfoList.size() + "\u7b14\u8bb0\u5f55");
        for (PaymentInfo paymentInfo : payInfoList) {
            PaymentInfo info = (PaymentInfo)map.get(paymentInfo.getBankDetailSeqID());
            if (info == null) continue;
            String status = info.getBankStatus();
            String txMsg = info.getBankMsg();
            if ("ACCP".equals(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)status, (String)txMsg);
            } else if ("RJCT".equals(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)status, (String)txMsg);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)status, (String)txMsg);
            }
            this.logger.info("\u4ed8\u6b3e\u5355\u660e\u7ec6\u53f7<" + paymentInfo.getBankDetailSeqID() + "> \u72b6\u6001<" + status + "> \u94f6\u884c\u4fe1\u606f<" + txMsg + ">");
        }
        return payInfoList;
    }

    protected Element getRootFromFile(File file, String encoding) throws Exception {
        String fileContent = FileUtils.readFileToString((File)file, (String)encoding);
        this.logger.info("\u6587\u4ef6\u5185\u5bb9>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        this.logger.info(fileContent);
        this.logger.info("\u6587\u4ef6\u5185\u5bb9<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        Document doc = JDom11Utils.str2Doc((String)fileContent, (String)encoding);
        return doc.getRootElement();
    }
}

