/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hdb.dcn.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hdb.dcn.services.utils.Packer;
import kd.ebg.aqap.banks.hdb.dcn.services.utils.Signature;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/linkbank/");
        sb.append(this.getBizCode());
        sb.append(".do");
        factory.setUri(sb.toString());
        factory.setHttpHeader("signature", RequestContextUtils.getRunningParam((String)"sign"));
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = Packer.packCommHeader();
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        Element listElement = JDomUtils.addChild((Element)body, (String)"linkReqList");
        JDomUtils.addChild((Element)listElement, (String)"accNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        String data = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
        String sign = Signature.getInstance().sign(data, this.getBizCode());
        RequestContextUtils.setRunningParam((String)"sign", (String)sign);
        return data;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        ArrayList list = Lists.newArrayList();
        BalanceInfo balanceInfo = new BalanceInfo();
        Element body = root.getChild("body");
        Element mapElement = body.getChild("linkRespList");
        if (mapElement == null) {
            return new EBBankBalanceResponse((List)list);
        }
        String returnCode = mapElement.getChildTextTrim("errorCode");
        String returnMsg = mapElement.getChildTextTrim("errorMsg");
        if (!"0".equals(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)returnCode, (String)returnMsg));
        }
        String accNo = mapElement.getChildTextTrim("accNo");
        String cur = mapElement.getChildTextTrim("currency");
        String bal = mapElement.getChildTextTrim("balance");
        String availBalance = mapElement.getChildTextTrim("availBal");
        this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), accNo);
        this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency(), cur);
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        this.setCurrentBalance(balanceInfo, bal);
        this.setAvailableBalance(balanceInfo, availBalance);
        list.add(balanceInfo);
        return new EBBankBalanceResponse((List)list);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "LB00001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u8d26\u6237\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]);
    }
}

